/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutableParametersRegistry;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.PrivateKeyTypeManager;
import com.google.crypto.tink.jwt.JwtEcdsaParameters;
import com.google.crypto.tink.jwt.JwtEcdsaProtoSerialization;
import com.google.crypto.tink.jwt.JwtEcdsaVerifyKeyManager;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtPublicKeySignInternal;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.proto.JwtEcdsaAlgorithm;
import com.google.crypto.tink.proto.JwtEcdsaKeyFormat;
import com.google.crypto.tink.proto.JwtEcdsaPrivateKey;
import com.google.crypto.tink.proto.JwtEcdsaPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SelfKeyTestValidators;
import com.google.crypto.tink.subtle.Validators;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class JwtEcdsaSignKeyManager
extends PrivateKeyTypeManager<JwtEcdsaPrivateKey, JwtEcdsaPublicKey> {
    JwtEcdsaSignKeyManager() {
        super(JwtEcdsaPrivateKey.class, JwtEcdsaPublicKey.class, new JwtPublicKeySignFactory());
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.JwtEcdsaPrivateKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public JwtEcdsaPublicKey getPublicKey(JwtEcdsaPrivateKey key) {
        return key.getPublicKey();
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    public JwtEcdsaPrivateKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return JwtEcdsaPrivateKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(JwtEcdsaPrivateKey privKey) throws GeneralSecurityException {
        Validators.validateVersion(privKey.getVersion(), this.getVersion());
        JwtEcdsaVerifyKeyManager.validateEcdsaAlgorithm(privKey.getPublicKey().getAlgorithm());
    }

    @Override
    public KeyTypeManager.KeyFactory<JwtEcdsaKeyFormat, JwtEcdsaPrivateKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<JwtEcdsaKeyFormat, JwtEcdsaPrivateKey>(JwtEcdsaKeyFormat.class){

            @Override
            public void validateKeyFormat(JwtEcdsaKeyFormat format) throws GeneralSecurityException {
                JwtEcdsaVerifyKeyManager.validateEcdsaAlgorithm(format.getAlgorithm());
            }

            @Override
            public JwtEcdsaKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return JwtEcdsaKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public JwtEcdsaPrivateKey createKey(JwtEcdsaKeyFormat format) throws GeneralSecurityException {
                JwtEcdsaAlgorithm ecdsaAlgorithm = format.getAlgorithm();
                KeyPair keyPair = EllipticCurves.generateKeyPair(JwtEcdsaVerifyKeyManager.getCurve(format.getAlgorithm()));
                ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
                ECPrivateKey privKey = (ECPrivateKey)keyPair.getPrivate();
                ECPoint w = pubKey.getW();
                JwtEcdsaPublicKey ecdsaPubKey = (JwtEcdsaPublicKey)JwtEcdsaPublicKey.newBuilder().setVersion(JwtEcdsaSignKeyManager.this.getVersion()).setAlgorithm(ecdsaAlgorithm).setX(ByteString.copyFrom(w.getAffineX().toByteArray())).setY(ByteString.copyFrom(w.getAffineY().toByteArray())).build();
                return (JwtEcdsaPrivateKey)JwtEcdsaPrivateKey.newBuilder().setVersion(JwtEcdsaSignKeyManager.this.getVersion()).setPublicKey(ecdsaPubKey).setKeyValue(ByteString.copyFrom(privKey.getS().toByteArray())).build();
            }
        };
    }

    private static Map<String, Parameters> namedParameters() throws GeneralSecurityException {
        HashMap<String, JwtEcdsaParameters> result = new HashMap<String, JwtEcdsaParameters>();
        result.put("JWT_ES256_RAW", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES256).setKidStrategy(JwtEcdsaParameters.KidStrategy.IGNORED).build());
        result.put("JWT_ES256", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES256).setKidStrategy(JwtEcdsaParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        result.put("JWT_ES384_RAW", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES384).setKidStrategy(JwtEcdsaParameters.KidStrategy.IGNORED).build());
        result.put("JWT_ES384", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES384).setKidStrategy(JwtEcdsaParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        result.put("JWT_ES512_RAW", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES512).setKidStrategy(JwtEcdsaParameters.KidStrategy.IGNORED).build());
        result.put("JWT_ES512", JwtEcdsaParameters.builder().setAlgorithm(JwtEcdsaParameters.Algorithm.ES512).setKidStrategy(JwtEcdsaParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    }

    public static void registerPair(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerAsymmetricKeyManagers(new JwtEcdsaSignKeyManager(), new JwtEcdsaVerifyKeyManager(), newKeyAllowed);
        JwtEcdsaProtoSerialization.register();
        MutableParametersRegistry.globalInstance().putAll(JwtEcdsaSignKeyManager.namedParameters());
    }

    private static class JwtPublicKeySignFactory
    extends PrimitiveFactory<JwtPublicKeySignInternal, JwtEcdsaPrivateKey> {
        public JwtPublicKeySignFactory() {
            super(JwtPublicKeySignInternal.class);
        }

        private static final void selfTestKey(ECPrivateKey privateKey, JwtEcdsaPrivateKey keyProto) throws GeneralSecurityException {
            Enums.HashType hash = JwtEcdsaVerifyKeyManager.hashForEcdsaAlgorithm(keyProto.getPublicKey().getAlgorithm());
            ECPublicKey publicKey = EllipticCurves.getEcPublicKey(JwtEcdsaVerifyKeyManager.getCurve(keyProto.getPublicKey().getAlgorithm()), keyProto.getPublicKey().getX().toByteArray(), keyProto.getPublicKey().getY().toByteArray());
            SelfKeyTestValidators.validateEcdsa(privateKey, publicKey, hash, EllipticCurves.EcdsaEncoding.IEEE_P1363);
        }

        @Override
        public JwtPublicKeySignInternal getPrimitive(JwtEcdsaPrivateKey keyProto) throws GeneralSecurityException {
            ECPrivateKey privateKey = EllipticCurves.getEcPrivateKey(JwtEcdsaVerifyKeyManager.getCurve(keyProto.getPublicKey().getAlgorithm()), keyProto.getKeyValue().toByteArray());
            JwtPublicKeySignFactory.selfTestKey(privateKey, keyProto);
            JwtEcdsaAlgorithm algorithm = keyProto.getPublicKey().getAlgorithm();
            Enums.HashType hash = JwtEcdsaVerifyKeyManager.hashForEcdsaAlgorithm(algorithm);
            final EcdsaSignJce signer = new EcdsaSignJce(privateKey, hash, EllipticCurves.EcdsaEncoding.IEEE_P1363);
            final String algorithmName = algorithm.name();
            final Optional customKid = keyProto.getPublicKey().hasCustomKid() ? Optional.of(keyProto.getPublicKey().getCustomKid().getValue()) : Optional.empty();
            return new JwtPublicKeySignInternal(){

                @Override
                public String signAndEncodeWithKid(RawJwt rawJwt, Optional<String> kid) throws GeneralSecurityException {
                    if (customKid.isPresent()) {
                        if (kid.isPresent()) {
                            throw new JwtInvalidException("custom_kid can only be set for RAW keys.");
                        }
                        kid = customKid;
                    }
                    String unsignedCompact = JwtFormat.createUnsignedCompact(algorithmName, kid, rawJwt);
                    return JwtFormat.createSignedCompact(unsignedCompact, signer.sign(unsignedCompact.getBytes(StandardCharsets.US_ASCII)));
                }
            };
        }
    }
}

