/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.internal.MutableKeyCreationRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.MutableSerializationRegistry;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.internal.ProtoParametersSerialization;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.MessageLite;
import com.google.crypto.tink.shaded.protobuf.Parser;
import java.security.GeneralSecurityException;

public final class LegacyKeyManagerImpl<P>
implements KeyManager<P> {
    private final String typeUrl;
    private final Class<P> primitiveClass;
    private final KeyData.KeyMaterialType keyMaterialType;
    private final Parser<? extends MessageLite> protobufKeyParser;

    public static <P> LegacyKeyManagerImpl<P> create(String typeUrl, Class<P> primitiveClass, KeyData.KeyMaterialType keyMaterialType, Parser<? extends MessageLite> protobufKeyParser) {
        return new LegacyKeyManagerImpl<P>(typeUrl, primitiveClass, keyMaterialType, protobufKeyParser);
    }

    private LegacyKeyManagerImpl(String typeUrl, Class<P> primitiveClass, KeyData.KeyMaterialType keyMaterialType, Parser<? extends MessageLite> protobufKeyParser) {
        this.protobufKeyParser = protobufKeyParser;
        this.typeUrl = typeUrl;
        this.primitiveClass = primitiveClass;
        this.keyMaterialType = keyMaterialType;
    }

    @Override
    public P getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        ProtoKeySerialization serialization = ProtoKeySerialization.create(this.typeUrl, serializedKey, this.keyMaterialType, OutputPrefixType.RAW, null);
        Key key = MutableSerializationRegistry.globalInstance().parseKey(serialization, InsecureSecretKeyAccess.get());
        return MutablePrimitiveRegistry.globalInstance().getPrimitive(key, this.primitiveClass);
    }

    @Override
    public final P getPrimitive(MessageLite key) throws GeneralSecurityException {
        return this.getPrimitive(key.toByteString());
    }

    @Override
    public final MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        KeyData keyData = this.newKeyData(serializedKeyFormat);
        try {
            return this.protobufKeyParser.parseFrom(keyData.getValue(), ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Unexpectedly failed to parse key");
        }
    }

    @Override
    public final MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        return this.newKey(keyFormat.toByteString());
    }

    @Override
    public final boolean doesSupport(String typeUrl) {
        return typeUrl.equals(this.getKeyType());
    }

    @Override
    public final String getKeyType() {
        return this.typeUrl;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public final KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        ProtoParametersSerialization parametersSerialization = ProtoParametersSerialization.checkedCreate((KeyTemplate)KeyTemplate.newBuilder().setTypeUrl(this.typeUrl).setValue(serializedKeyFormat).setOutputPrefixType(OutputPrefixType.RAW).build());
        Parameters parameters = MutableSerializationRegistry.globalInstance().parseParameters(parametersSerialization);
        Key key = MutableKeyCreationRegistry.globalInstance().createKey(parameters, null);
        ProtoKeySerialization keySerialization = MutableSerializationRegistry.globalInstance().serializeKey(key, ProtoKeySerialization.class, InsecureSecretKeyAccess.get());
        return (KeyData)KeyData.newBuilder().setTypeUrl(keySerialization.getTypeUrl()).setValue(keySerialization.getValue()).setKeyMaterialType(keySerialization.getKeyMaterialType()).build();
    }

    @Override
    public final Class<P> getPrimitiveClass() {
        return this.primitiveClass;
    }
}

