/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.MessageLite;
import java.security.GeneralSecurityException;

@Alpha
class KeyManagerImpl<PrimitiveT, KeyProtoT extends MessageLite>
implements KeyManager<PrimitiveT> {
    private final KeyTypeManager<KeyProtoT> keyTypeManager;
    private final Class<PrimitiveT> primitiveClass;

    public KeyManagerImpl(KeyTypeManager<KeyProtoT> keyTypeManager, Class<PrimitiveT> primitiveClass) {
        if (!keyTypeManager.supportedPrimitives().contains(primitiveClass) && !Void.class.equals(primitiveClass)) {
            throw new IllegalArgumentException(String.format("Given internalKeyMananger %s does not support primitive class %s", keyTypeManager.toString(), primitiveClass.getName()));
        }
        this.keyTypeManager = keyTypeManager;
        this.primitiveClass = primitiveClass;
    }

    private static <CastedT> CastedT castOrThrowSecurityException(Object objectToCast, String exceptionText, Class<CastedT> classObject) throws GeneralSecurityException {
        if (!classObject.isInstance(objectToCast)) {
            throw new GeneralSecurityException(exceptionText);
        }
        Object result = objectToCast;
        return (CastedT)result;
    }

    @Override
    public final PrimitiveT getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            KeyProtoT keyProto = this.keyTypeManager.parseKey(serializedKey);
            return this.validateKeyAndGetPrimitive(keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Failures parsing proto of type " + this.keyTypeManager.getKeyClass().getName(), e);
        }
    }

    @Override
    public final PrimitiveT getPrimitive(MessageLite key) throws GeneralSecurityException {
        return this.validateKeyAndGetPrimitive((MessageLite)KeyManagerImpl.castOrThrowSecurityException(key, "Expected proto of type " + this.keyTypeManager.getKeyClass().getName(), this.keyTypeManager.getKeyClass()));
    }

    @Override
    public final MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            return this.keyFactoryHelper().parseValidateCreate(serializedKeyFormat);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Failures parsing proto of type " + this.keyTypeManager.keyFactory().getKeyFormatClass().getName(), e);
        }
    }

    @Override
    public final MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        return this.keyFactoryHelper().castValidateCreate(keyFormat);
    }

    @Override
    public final boolean doesSupport(String typeUrl) {
        return typeUrl.equals(this.getKeyType());
    }

    @Override
    public final String getKeyType() {
        return this.keyTypeManager.getKeyType();
    }

    @Override
    public int getVersion() {
        return this.keyTypeManager.getVersion();
    }

    @Override
    public final KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            KeyProtoT key = this.keyFactoryHelper().parseValidateCreate(serializedKeyFormat);
            return (KeyData)KeyData.newBuilder().setTypeUrl(this.getKeyType()).setValue(key.toByteString()).setKeyMaterialType(this.keyTypeManager.keyMaterialType()).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Unexpected proto", e);
        }
    }

    @Override
    public final Class<PrimitiveT> getPrimitiveClass() {
        return this.primitiveClass;
    }

    private PrimitiveT validateKeyAndGetPrimitive(KeyProtoT keyProto) throws GeneralSecurityException {
        if (Void.class.equals(this.primitiveClass)) {
            throw new GeneralSecurityException("Cannot create a primitive for Void");
        }
        this.keyTypeManager.validateKey(keyProto);
        return this.keyTypeManager.getPrimitive(keyProto, this.primitiveClass);
    }

    private KeyFactoryHelper<?, KeyProtoT> keyFactoryHelper() {
        return new KeyFactoryHelper(this.keyTypeManager.keyFactory());
    }

    private static class KeyFactoryHelper<KeyFormatProtoT extends MessageLite, KeyProtoT extends MessageLite> {
        final KeyTypeManager.KeyFactory<KeyFormatProtoT, KeyProtoT> keyFactory;

        KeyFactoryHelper(KeyTypeManager.KeyFactory<KeyFormatProtoT, KeyProtoT> keyFactory) {
            this.keyFactory = keyFactory;
        }

        private KeyProtoT validateCreate(KeyFormatProtoT keyFormat) throws GeneralSecurityException {
            this.keyFactory.validateKeyFormat(keyFormat);
            return this.keyFactory.createKey(keyFormat);
        }

        KeyProtoT parseValidateCreate(ByteString serializedKeyFormat) throws GeneralSecurityException, InvalidProtocolBufferException {
            return this.validateCreate(this.keyFactory.parseKeyFormat(serializedKeyFormat));
        }

        KeyProtoT castValidateCreate(MessageLite message) throws GeneralSecurityException {
            return this.validateCreate((MessageLite)KeyManagerImpl.castOrThrowSecurityException(message, "Expected proto of type " + this.keyFactory.getKeyFormatClass().getName(), this.keyFactory.getKeyFormatClass()));
        }
    }
}

