/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.ChaCha20Poly1305Key;
import com.google.crypto.tink.aead.ChaCha20Poly1305Parameters;
import com.google.crypto.tink.aead.ChaCha20Poly1305ProtoSerialization;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutableParametersRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.proto.ChaCha20Poly1305KeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.ChaCha20Poly1305;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChaCha20Poly1305KeyManager
extends KeyTypeManager<com.google.crypto.tink.proto.ChaCha20Poly1305Key> {
    private static final PrimitiveConstructor<ChaCha20Poly1305Key, Aead> CHA_CHA_20_POLY_1305_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(ChaCha20Poly1305::create, ChaCha20Poly1305Key.class, Aead.class);
    private static final int KEY_SIZE_IN_BYTES = 32;

    ChaCha20Poly1305KeyManager() {
        super(com.google.crypto.tink.proto.ChaCha20Poly1305Key.class, new PrimitiveFactory<Aead, com.google.crypto.tink.proto.ChaCha20Poly1305Key>(Aead.class){

            @Override
            public Aead getPrimitive(com.google.crypto.tink.proto.ChaCha20Poly1305Key key) throws GeneralSecurityException {
                return new ChaCha20Poly1305(key.getKeyValue().toByteArray());
            }
        });
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(com.google.crypto.tink.proto.ChaCha20Poly1305Key key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (key.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid ChaCha20Poly1305Key: incorrect key length");
        }
    }

    @Override
    public com.google.crypto.tink.proto.ChaCha20Poly1305Key parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return com.google.crypto.tink.proto.ChaCha20Poly1305Key.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<ChaCha20Poly1305KeyFormat, com.google.crypto.tink.proto.ChaCha20Poly1305Key> keyFactory() {
        return new KeyTypeManager.KeyFactory<ChaCha20Poly1305KeyFormat, com.google.crypto.tink.proto.ChaCha20Poly1305Key>(ChaCha20Poly1305KeyFormat.class){

            @Override
            public void validateKeyFormat(ChaCha20Poly1305KeyFormat format) throws GeneralSecurityException {
            }

            @Override
            public ChaCha20Poly1305KeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return ChaCha20Poly1305KeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public com.google.crypto.tink.proto.ChaCha20Poly1305Key createKey(ChaCha20Poly1305KeyFormat format) throws GeneralSecurityException {
                return (com.google.crypto.tink.proto.ChaCha20Poly1305Key)com.google.crypto.tink.proto.ChaCha20Poly1305Key.newBuilder().setVersion(ChaCha20Poly1305KeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom(Random.randBytes(32))).build();
            }
        };
    }

    private static Map<String, Parameters> namedParameters() throws GeneralSecurityException {
        HashMap<String, ChaCha20Poly1305Parameters> result = new HashMap<String, ChaCha20Poly1305Parameters>();
        result.put("CHACHA20_POLY1305", ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.TINK));
        result.put("CHACHA20_POLY1305_RAW", ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.NO_PREFIX));
        return Collections.unmodifiableMap(result);
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new ChaCha20Poly1305KeyManager(), newKeyAllowed);
        ChaCha20Poly1305ProtoSerialization.register();
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(CHA_CHA_20_POLY_1305_PRIMITIVE_CONSTRUCTOR);
        MutableParametersRegistry.globalInstance().putAll(ChaCha20Poly1305KeyManager.namedParameters());
    }

    public static final KeyTemplate chaCha20Poly1305Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.TINK)));
    }

    public static final KeyTemplate rawChaCha20Poly1305Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.NO_PREFIX)));
    }
}

