/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation.internal;

import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.keyderivation.KeysetDeriver;
import com.google.crypto.tink.keyderivation.internal.PrfBasedDeriver;
import com.google.crypto.tink.keyderivation.internal.PrfBasedKeyDerivationKeyProtoSerialization;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.PrfBasedDeriverKey;
import com.google.crypto.tink.proto.PrfBasedDeriverKeyFormat;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;

public final class PrfBasedDeriverKeyManager
extends KeyTypeManager<PrfBasedDeriverKey> {
    public PrfBasedDeriverKeyManager() {
        super(PrfBasedDeriverKey.class, new PrimitiveFactory<KeysetDeriver, PrfBasedDeriverKey>(KeysetDeriver.class){

            @Override
            public KeysetDeriver getPrimitive(PrfBasedDeriverKey key) throws GeneralSecurityException {
                return PrfBasedDeriver.create(key.getPrfKey(), key.getParams().getDerivedKeyTemplate());
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.PrfBasedDeriverKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(PrfBasedDeriverKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (!key.hasPrfKey()) {
            throw new GeneralSecurityException("key.prf_key must be set");
        }
        if (!key.getParams().hasDerivedKeyTemplate()) {
            throw new GeneralSecurityException("key.params.derived_key_template must be set");
        }
    }

    @Override
    public PrfBasedDeriverKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return PrfBasedDeriverKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<PrfBasedDeriverKeyFormat, PrfBasedDeriverKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<PrfBasedDeriverKeyFormat, PrfBasedDeriverKey>(PrfBasedDeriverKeyFormat.class){

            @Override
            public void validateKeyFormat(PrfBasedDeriverKeyFormat format) throws GeneralSecurityException {
                if (!format.hasPrfKeyTemplate()) {
                    throw new GeneralSecurityException("format.params.prf_key_template must be set");
                }
                if (!format.getParams().hasDerivedKeyTemplate()) {
                    throw new GeneralSecurityException("format.params.derived_key_template must be set");
                }
            }

            @Override
            public PrfBasedDeriverKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return PrfBasedDeriverKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public PrfBasedDeriverKey createKey(PrfBasedDeriverKeyFormat format) throws GeneralSecurityException {
                KeyData prfKey = Registry.newKeyData(format.getPrfKeyTemplate());
                PrfBasedDeriver unused = PrfBasedDeriver.create(prfKey, format.getParams().getDerivedKeyTemplate());
                return (PrfBasedDeriverKey)PrfBasedDeriverKey.newBuilder().setVersion(PrfBasedDeriverKeyManager.this.getVersion()).setParams(format.getParams()).setPrfKey(prfKey).build();
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new PrfBasedDeriverKeyManager(), newKeyAllowed);
        PrfBasedKeyDerivationKeyProtoSerialization.register();
    }
}

