/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation.internal;

import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrivilegedRegistry;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.TinkProtoKeysetFormat;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.keyderivation.KeysetDeriver;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.prf.StreamingPrf;
import com.google.errorprone.annotations.Immutable;
import java.io.InputStream;
import java.security.GeneralSecurityException;

@Immutable
public class PrfBasedDeriver
implements KeysetDeriver {
    private final KeyData streamingPrfKey;
    private final KeyTemplate derivedKeyTemplate;

    private PrfBasedDeriver(KeyData streamingPrfKey, KeyTemplate derivedKeyTemplate) {
        this.streamingPrfKey = streamingPrfKey;
        this.derivedKeyTemplate = derivedKeyTemplate;
    }

    public static PrfBasedDeriver create(KeyData streamingPrfKey, KeyTemplate derivedKeyTemplate) throws GeneralSecurityException {
        StreamingPrf prf = Registry.getPrimitive(streamingPrfKey, StreamingPrf.class);
        KeyData unused = PrivilegedRegistry.deriveKey(derivedKeyTemplate, prf.computePrf("s".getBytes(Util.UTF_8)));
        return new PrfBasedDeriver(streamingPrfKey, derivedKeyTemplate);
    }

    @Override
    public KeysetHandle deriveKeyset(byte[] salt) throws GeneralSecurityException {
        StreamingPrf prf = Registry.getPrimitive(this.streamingPrfKey, StreamingPrf.class);
        InputStream randomness = prf.computePrf(salt);
        KeyData keyData = PrivilegedRegistry.deriveKey(this.derivedKeyTemplate, randomness);
        Keyset.Key key = (Keyset.Key)Keyset.Key.newBuilder().setKeyData(keyData).setStatus(KeyStatusType.UNKNOWN_STATUS).setKeyId(0).setOutputPrefixType(OutputPrefixType.UNKNOWN_PREFIX).build();
        return TinkProtoKeysetFormat.parseKeyset(((Keyset)Keyset.newBuilder().addKey(key).setPrimaryKeyId(0).build()).toByteArray(), InsecureSecretKeyAccess.get());
    }
}

