/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation;

import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.TinkProtoKeysetFormat;
import com.google.crypto.tink.keyderivation.KeysetDeriver;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.Keyset;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;

public class KeysetDeriverWrapper
implements PrimitiveWrapper<KeysetDeriver, KeysetDeriver> {
    private static final KeysetDeriverWrapper WRAPPER = new KeysetDeriverWrapper();

    private static void validate(PrimitiveSet<KeysetDeriver> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
    }

    KeysetDeriverWrapper() {
    }

    @Override
    public KeysetDeriver wrap(PrimitiveSet<KeysetDeriver> primitiveSet) throws GeneralSecurityException {
        KeysetDeriverWrapper.validate(primitiveSet);
        return new WrappedKeysetDeriver(primitiveSet);
    }

    @Override
    public Class<KeysetDeriver> getPrimitiveClass() {
        return KeysetDeriver.class;
    }

    @Override
    public Class<KeysetDeriver> getInputPrimitiveClass() {
        return KeysetDeriver.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedKeysetDeriver
    implements KeysetDeriver {
        private final PrimitiveSet<KeysetDeriver> primitiveSet;

        private WrappedKeysetDeriver(PrimitiveSet<KeysetDeriver> primitiveSet) {
            this.primitiveSet = primitiveSet;
        }

        private static KeyData deriveAndGetKeyData(byte[] salt, KeysetDeriver deriver) throws GeneralSecurityException {
            KeysetHandle keysetHandle = deriver.deriveKeyset(salt);
            Keyset keyset = CleartextKeysetHandle.getKeyset(keysetHandle);
            if (keyset.getKeyCount() != 1) {
                throw new GeneralSecurityException("Wrapped Deriver must create a keyset with exactly one KeyData");
            }
            return keyset.getKey(0).getKeyData();
        }

        @Override
        public KeysetHandle deriveKeyset(byte[] salt) throws GeneralSecurityException {
            Keyset.Builder builder = Keyset.newBuilder();
            for (PrimitiveSet.Entry<KeysetDeriver> entry : this.primitiveSet.getAllInKeysetOrder()) {
                builder.addKey(Keyset.Key.newBuilder().setKeyData(WrappedKeysetDeriver.deriveAndGetKeyData(salt, entry.getPrimitive())).setStatus(entry.getStatus()).setOutputPrefixType(entry.getOutputPrefixType()).setKeyId(entry.getKeyId()));
            }
            builder.setPrimaryKeyId(this.primitiveSet.getPrimary().getKeyId());
            return TinkProtoKeysetFormat.parseKeyset(((Keyset)builder.build()).toByteArray(), InsecureSecretKeyAccess.get());
        }
    }
}

