/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.KeyStatus;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.internal.BigIntegerEncoding;
import com.google.crypto.tink.internal.MutableSerializationRegistry;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.proto.JwtEcdsaAlgorithm;
import com.google.crypto.tink.proto.JwtEcdsaPublicKey;
import com.google.crypto.tink.proto.JwtRsaSsaPkcs1Algorithm;
import com.google.crypto.tink.proto.JwtRsaSsaPkcs1PublicKey;
import com.google.crypto.tink.proto.JwtRsaSsaPssAlgorithm;
import com.google.crypto.tink.proto.JwtRsaSsaPssPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.tinkkey.KeyAccess;
import com.google.errorprone.annotations.InlineMe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.annotation.Nullable;

public final class JwkSetConverter {
    private static final String JWT_ECDSA_PUBLIC_KEY_URL = "type.googleapis.com/google.crypto.tink.JwtEcdsaPublicKey";
    private static final String JWT_RSA_SSA_PKCS1_PUBLIC_KEY_URL = "type.googleapis.com/google.crypto.tink.JwtRsaSsaPkcs1PublicKey";
    private static final String JWT_RSA_SSA_PSS_PUBLIC_KEY_URL = "type.googleapis.com/google.crypto.tink.JwtRsaSsaPssPublicKey";

    public static String fromPublicKeysetHandle(KeysetHandle handle) throws IOException, GeneralSecurityException {
        handle = KeysetHandle.newBuilder(handle).build();
        JsonArray keys = new JsonArray();
        block10: for (int i = 0; i < handle.size(); ++i) {
            KeysetHandle.Entry entry = handle.getAt(i);
            if (entry.getStatus() != KeyStatus.ENABLED) continue;
            ProtoKeySerialization protoKeySerialization = MutableSerializationRegistry.globalInstance().serializeKey(entry.getKey(), ProtoKeySerialization.class, null);
            if (protoKeySerialization.getOutputPrefixType() != OutputPrefixType.RAW && protoKeySerialization.getOutputPrefixType() != OutputPrefixType.TINK) {
                throw new GeneralSecurityException("only OutputPrefixType RAW and TINK are supported");
            }
            if (protoKeySerialization.getKeyMaterialType() != KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC) {
                throw new GeneralSecurityException("only public keys can be converted");
            }
            switch (protoKeySerialization.getTypeUrl()) {
                case "type.googleapis.com/google.crypto.tink.JwtEcdsaPublicKey": {
                    keys.add((JsonElement)JwkSetConverter.convertJwtEcdsaKey(protoKeySerialization));
                    continue block10;
                }
                case "type.googleapis.com/google.crypto.tink.JwtRsaSsaPkcs1PublicKey": {
                    keys.add((JsonElement)JwkSetConverter.convertJwtRsaSsaPkcs1(protoKeySerialization));
                    continue block10;
                }
                case "type.googleapis.com/google.crypto.tink.JwtRsaSsaPssPublicKey": {
                    keys.add((JsonElement)JwkSetConverter.convertJwtRsaSsaPss(protoKeySerialization));
                    continue block10;
                }
                default: {
                    throw new GeneralSecurityException(String.format("key type %s is not supported", protoKeySerialization.getTypeUrl()));
                }
            }
        }
        JsonObject jwkSet = new JsonObject();
        jwkSet.add("keys", (JsonElement)keys);
        return jwkSet.toString();
    }

    public static KeysetHandle toPublicKeysetHandle(String jwkSet) throws IOException, GeneralSecurityException {
        JsonObject jsonKeyset;
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(jwkSet));
            jsonReader.setLenient(false);
            jsonKeyset = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
        }
        catch (JsonParseException | IllegalStateException | StackOverflowError ex) {
            throw new GeneralSecurityException("JWK set is invalid JSON", ex);
        }
        KeysetHandle.Builder builder = KeysetHandle.newBuilder();
        JsonArray jsonKeys = jsonKeyset.get("keys").getAsJsonArray();
        for (JsonElement element : jsonKeys) {
            ProtoKeySerialization keySerialization;
            String algPrefix;
            JsonObject jsonKey = element.getAsJsonObject();
            switch (algPrefix = JwkSetConverter.getStringItem(jsonKey, "alg").substring(0, 2)) {
                case "RS": {
                    keySerialization = JwkSetConverter.convertToRsaSsaPkcs1Key(jsonKey);
                    break;
                }
                case "PS": {
                    keySerialization = JwkSetConverter.convertToRsaSsaPssKey(jsonKey);
                    break;
                }
                case "ES": {
                    keySerialization = JwkSetConverter.convertToEcdsaKey(jsonKey);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unexpected alg value: " + JwkSetConverter.getStringItem(jsonKey, "alg"));
                }
            }
            builder.addEntry(KeysetHandle.importKey(MutableSerializationRegistry.globalInstance().parseKeyWithLegacyFallback(keySerialization, null)).withRandomId());
        }
        if (builder.size() <= 0) {
            throw new GeneralSecurityException("empty keyset");
        }
        builder.getAt(0).makePrimary();
        return builder.build();
    }

    private static Optional<String> getKid(@Nullable Integer idRequirement) {
        if (idRequirement == null) {
            return Optional.empty();
        }
        byte[] bigEndianKeyId = ByteBuffer.allocate(4).putInt(idRequirement).array();
        return Optional.of(Base64.urlSafeEncode(bigEndianKeyId));
    }

    private static JsonObject convertJwtEcdsaKey(ProtoKeySerialization protoKeySerialization) throws GeneralSecurityException {
        int encLength;
        String crv;
        String alg;
        JwtEcdsaPublicKey jwtEcdsaPublicKey;
        try {
            jwtEcdsaPublicKey = JwtEcdsaPublicKey.parseFrom(protoKeySerialization.getValue(), ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("failed to parse value as JwtEcdsaPublicKey proto", e);
        }
        switch (jwtEcdsaPublicKey.getAlgorithm()) {
            case ES256: {
                alg = "ES256";
                crv = "P-256";
                encLength = 32;
                break;
            }
            case ES384: {
                alg = "ES384";
                crv = "P-384";
                encLength = 48;
                break;
            }
            case ES512: {
                alg = "ES512";
                crv = "P-521";
                encLength = 66;
                break;
            }
            default: {
                throw new GeneralSecurityException("unknown algorithm");
            }
        }
        JsonObject jsonKey = new JsonObject();
        jsonKey.addProperty("kty", "EC");
        jsonKey.addProperty("crv", crv);
        BigInteger x = BigIntegerEncoding.fromUnsignedBigEndianBytes(jwtEcdsaPublicKey.getX().toByteArray());
        BigInteger y = BigIntegerEncoding.fromUnsignedBigEndianBytes(jwtEcdsaPublicKey.getY().toByteArray());
        jsonKey.addProperty("x", Base64.urlSafeEncode(BigIntegerEncoding.toBigEndianBytesOfFixedLength(x, encLength)));
        jsonKey.addProperty("y", Base64.urlSafeEncode(BigIntegerEncoding.toBigEndianBytesOfFixedLength(y, encLength)));
        jsonKey.addProperty("use", "sig");
        jsonKey.addProperty("alg", alg);
        JsonArray keyOps = new JsonArray();
        keyOps.add("verify");
        jsonKey.add("key_ops", (JsonElement)keyOps);
        Optional<String> kid = JwkSetConverter.getKid(protoKeySerialization.getIdRequirementOrNull());
        if (kid.isPresent()) {
            jsonKey.addProperty("kid", kid.get());
        } else if (jwtEcdsaPublicKey.hasCustomKid()) {
            jsonKey.addProperty("kid", jwtEcdsaPublicKey.getCustomKid().getValue());
        }
        return jsonKey;
    }

    private static JsonObject convertJwtRsaSsaPkcs1(ProtoKeySerialization protoKeySerialization) throws GeneralSecurityException {
        String alg;
        JwtRsaSsaPkcs1PublicKey jwtRsaSsaPkcs1PublicKey;
        try {
            jwtRsaSsaPkcs1PublicKey = JwtRsaSsaPkcs1PublicKey.parseFrom(protoKeySerialization.getValue(), ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("failed to parse value as JwtRsaSsaPkcs1PublicKey proto", e);
        }
        switch (jwtRsaSsaPkcs1PublicKey.getAlgorithm()) {
            case RS256: {
                alg = "RS256";
                break;
            }
            case RS384: {
                alg = "RS384";
                break;
            }
            case RS512: {
                alg = "RS512";
                break;
            }
            default: {
                throw new GeneralSecurityException("unknown algorithm");
            }
        }
        JsonObject jsonKey = new JsonObject();
        jsonKey.addProperty("kty", "RSA");
        jsonKey.addProperty("n", Base64.urlSafeEncode(jwtRsaSsaPkcs1PublicKey.getN().toByteArray()));
        jsonKey.addProperty("e", Base64.urlSafeEncode(jwtRsaSsaPkcs1PublicKey.getE().toByteArray()));
        jsonKey.addProperty("use", "sig");
        jsonKey.addProperty("alg", alg);
        JsonArray keyOps = new JsonArray();
        keyOps.add("verify");
        jsonKey.add("key_ops", (JsonElement)keyOps);
        Optional<String> kid = JwkSetConverter.getKid(protoKeySerialization.getIdRequirementOrNull());
        if (kid.isPresent()) {
            jsonKey.addProperty("kid", kid.get());
        } else if (jwtRsaSsaPkcs1PublicKey.hasCustomKid()) {
            jsonKey.addProperty("kid", jwtRsaSsaPkcs1PublicKey.getCustomKid().getValue());
        }
        return jsonKey;
    }

    private static JsonObject convertJwtRsaSsaPss(ProtoKeySerialization protoKeySerialization) throws GeneralSecurityException {
        String alg;
        JwtRsaSsaPssPublicKey jwtRsaSsaPssPublicKey;
        try {
            jwtRsaSsaPssPublicKey = JwtRsaSsaPssPublicKey.parseFrom(protoKeySerialization.getValue(), ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("failed to parse value as JwtRsaSsaPssPublicKey proto", e);
        }
        switch (jwtRsaSsaPssPublicKey.getAlgorithm()) {
            case PS256: {
                alg = "PS256";
                break;
            }
            case PS384: {
                alg = "PS384";
                break;
            }
            case PS512: {
                alg = "PS512";
                break;
            }
            default: {
                throw new GeneralSecurityException("unknown algorithm");
            }
        }
        JsonObject jsonKey = new JsonObject();
        jsonKey.addProperty("kty", "RSA");
        jsonKey.addProperty("n", Base64.urlSafeEncode(jwtRsaSsaPssPublicKey.getN().toByteArray()));
        jsonKey.addProperty("e", Base64.urlSafeEncode(jwtRsaSsaPssPublicKey.getE().toByteArray()));
        jsonKey.addProperty("use", "sig");
        jsonKey.addProperty("alg", alg);
        JsonArray keyOps = new JsonArray();
        keyOps.add("verify");
        jsonKey.add("key_ops", (JsonElement)keyOps);
        Optional<String> kid = JwkSetConverter.getKid(protoKeySerialization.getIdRequirementOrNull());
        if (kid.isPresent()) {
            jsonKey.addProperty("kid", kid.get());
        } else if (jwtRsaSsaPssPublicKey.hasCustomKid()) {
            jsonKey.addProperty("kid", jwtRsaSsaPssPublicKey.getCustomKid().getValue());
        }
        return jsonKey;
    }

    private static String getStringItem(JsonObject obj, String name) throws GeneralSecurityException {
        if (!obj.has(name)) {
            throw new GeneralSecurityException(name + " not found");
        }
        if (!obj.get(name).isJsonPrimitive() || !obj.get(name).getAsJsonPrimitive().isString()) {
            throw new GeneralSecurityException(name + " is not a string");
        }
        return obj.get(name).getAsString();
    }

    private static void expectStringItem(JsonObject obj, String name, String expectedValue) throws GeneralSecurityException {
        String value = JwkSetConverter.getStringItem(obj, name);
        if (!value.equals(expectedValue)) {
            throw new GeneralSecurityException("unexpected " + name + " value: " + value);
        }
    }

    private static void validateUseIsSig(JsonObject jsonKey) throws GeneralSecurityException {
        if (!jsonKey.has("use")) {
            return;
        }
        JwkSetConverter.expectStringItem(jsonKey, "use", "sig");
    }

    private static void validateKeyOpsIsVerify(JsonObject jsonKey) throws GeneralSecurityException {
        if (!jsonKey.has("key_ops")) {
            return;
        }
        if (!jsonKey.get("key_ops").isJsonArray()) {
            throw new GeneralSecurityException("key_ops is not an array");
        }
        JsonArray keyOps = jsonKey.get("key_ops").getAsJsonArray();
        if (keyOps.size() != 1) {
            throw new GeneralSecurityException("key_ops must contain exactly one element");
        }
        if (!keyOps.get(0).isJsonPrimitive() || !keyOps.get(0).getAsJsonPrimitive().isString()) {
            throw new GeneralSecurityException("key_ops is not a string");
        }
        if (!keyOps.get(0).getAsString().equals("verify")) {
            throw new GeneralSecurityException("unexpected keyOps value: " + keyOps.get(0).getAsString());
        }
    }

    private static ProtoKeySerialization convertToRsaSsaPkcs1Key(JsonObject jsonKey) throws GeneralSecurityException {
        JwtRsaSsaPkcs1Algorithm algorithm;
        switch (JwkSetConverter.getStringItem(jsonKey, "alg")) {
            case "RS256": {
                algorithm = JwtRsaSsaPkcs1Algorithm.RS256;
                break;
            }
            case "RS384": {
                algorithm = JwtRsaSsaPkcs1Algorithm.RS384;
                break;
            }
            case "RS512": {
                algorithm = JwtRsaSsaPkcs1Algorithm.RS512;
                break;
            }
            default: {
                throw new GeneralSecurityException("Unknown Rsa Algorithm: " + JwkSetConverter.getStringItem(jsonKey, "alg"));
            }
        }
        if (jsonKey.has("p") || jsonKey.has("q") || jsonKey.has("dp") || jsonKey.has("dq") || jsonKey.has("d") || jsonKey.has("qi")) {
            throw new UnsupportedOperationException("importing RSA private keys is not implemented");
        }
        JwkSetConverter.expectStringItem(jsonKey, "kty", "RSA");
        JwkSetConverter.validateUseIsSig(jsonKey);
        JwkSetConverter.validateKeyOpsIsVerify(jsonKey);
        JwtRsaSsaPkcs1PublicKey.Builder pkcs1PubKeyBuilder = JwtRsaSsaPkcs1PublicKey.newBuilder().setVersion(0).setAlgorithm(algorithm).setE(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "e")))).setN(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "n"))));
        if (jsonKey.has("kid")) {
            pkcs1PubKeyBuilder.setCustomKid((JwtRsaSsaPkcs1PublicKey.CustomKid)JwtRsaSsaPkcs1PublicKey.CustomKid.newBuilder().setValue(JwkSetConverter.getStringItem(jsonKey, "kid")).build());
        }
        return ProtoKeySerialization.create(JWT_RSA_SSA_PKCS1_PUBLIC_KEY_URL, ((JwtRsaSsaPkcs1PublicKey)pkcs1PubKeyBuilder.build()).toByteString(), KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC, OutputPrefixType.RAW, null);
    }

    private static ProtoKeySerialization convertToRsaSsaPssKey(JsonObject jsonKey) throws GeneralSecurityException {
        JwtRsaSsaPssAlgorithm algorithm;
        switch (JwkSetConverter.getStringItem(jsonKey, "alg")) {
            case "PS256": {
                algorithm = JwtRsaSsaPssAlgorithm.PS256;
                break;
            }
            case "PS384": {
                algorithm = JwtRsaSsaPssAlgorithm.PS384;
                break;
            }
            case "PS512": {
                algorithm = JwtRsaSsaPssAlgorithm.PS512;
                break;
            }
            default: {
                throw new GeneralSecurityException("Unknown Rsa Algorithm: " + JwkSetConverter.getStringItem(jsonKey, "alg"));
            }
        }
        if (jsonKey.has("p") || jsonKey.has("q") || jsonKey.has("dq") || jsonKey.has("dq") || jsonKey.has("d") || jsonKey.has("qi")) {
            throw new UnsupportedOperationException("importing RSA private keys is not implemented");
        }
        JwkSetConverter.expectStringItem(jsonKey, "kty", "RSA");
        JwkSetConverter.validateUseIsSig(jsonKey);
        JwkSetConverter.validateKeyOpsIsVerify(jsonKey);
        JwtRsaSsaPssPublicKey.Builder pssPubKeyBuilder = JwtRsaSsaPssPublicKey.newBuilder().setVersion(0).setAlgorithm(algorithm).setE(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "e")))).setN(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "n"))));
        if (jsonKey.has("kid")) {
            pssPubKeyBuilder.setCustomKid((JwtRsaSsaPssPublicKey.CustomKid)JwtRsaSsaPssPublicKey.CustomKid.newBuilder().setValue(JwkSetConverter.getStringItem(jsonKey, "kid")).build());
        }
        return ProtoKeySerialization.create(JWT_RSA_SSA_PSS_PUBLIC_KEY_URL, ((JwtRsaSsaPssPublicKey)pssPubKeyBuilder.build()).toByteString(), KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC, OutputPrefixType.RAW, null);
    }

    private static ProtoKeySerialization convertToEcdsaKey(JsonObject jsonKey) throws GeneralSecurityException {
        JwtEcdsaAlgorithm algorithm;
        switch (JwkSetConverter.getStringItem(jsonKey, "alg")) {
            case "ES256": {
                JwkSetConverter.expectStringItem(jsonKey, "crv", "P-256");
                algorithm = JwtEcdsaAlgorithm.ES256;
                break;
            }
            case "ES384": {
                JwkSetConverter.expectStringItem(jsonKey, "crv", "P-384");
                algorithm = JwtEcdsaAlgorithm.ES384;
                break;
            }
            case "ES512": {
                JwkSetConverter.expectStringItem(jsonKey, "crv", "P-521");
                algorithm = JwtEcdsaAlgorithm.ES512;
                break;
            }
            default: {
                throw new GeneralSecurityException("Unknown Ecdsa Algorithm: " + JwkSetConverter.getStringItem(jsonKey, "alg"));
            }
        }
        if (jsonKey.has("d")) {
            throw new UnsupportedOperationException("importing ECDSA private keys is not implemented");
        }
        JwkSetConverter.expectStringItem(jsonKey, "kty", "EC");
        JwkSetConverter.validateUseIsSig(jsonKey);
        JwkSetConverter.validateKeyOpsIsVerify(jsonKey);
        JwtEcdsaPublicKey.Builder ecdsaPubKeyBuilder = JwtEcdsaPublicKey.newBuilder().setVersion(0).setAlgorithm(algorithm).setX(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "x")))).setY(ByteString.copyFrom(Base64.urlSafeDecode(JwkSetConverter.getStringItem(jsonKey, "y"))));
        if (jsonKey.has("kid")) {
            ecdsaPubKeyBuilder.setCustomKid((JwtEcdsaPublicKey.CustomKid)JwtEcdsaPublicKey.CustomKid.newBuilder().setValue(JwkSetConverter.getStringItem(jsonKey, "kid")).build());
        }
        return ProtoKeySerialization.create(JWT_ECDSA_PUBLIC_KEY_URL, ((JwtEcdsaPublicKey)ecdsaPubKeyBuilder.build()).toByteString(), KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC, OutputPrefixType.RAW, null);
    }

    @Deprecated
    @InlineMe(replacement="JwkSetConverter.fromPublicKeysetHandle(handle)", imports={"com.google.crypto.tink.jwt.JwkSetConverter"})
    public static String fromKeysetHandle(KeysetHandle handle, KeyAccess keyAccess) throws IOException, GeneralSecurityException {
        return JwkSetConverter.fromPublicKeysetHandle(handle);
    }

    @Deprecated
    @InlineMe(replacement="JwkSetConverter.toPublicKeysetHandle(jwkSet)", imports={"com.google.crypto.tink.jwt.JwkSetConverter"})
    public static KeysetHandle toKeysetHandle(String jwkSet, KeyAccess keyAccess) throws IOException, GeneralSecurityException {
        return JwkSetConverter.toPublicKeysetHandle(jwkSet);
    }

    private JwkSetConverter() {
    }
}

