/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;

public class DeterministicAeadWrapper
implements PrimitiveWrapper<DeterministicAead, DeterministicAead> {
    private static final DeterministicAeadWrapper WRAPPER = new DeterministicAeadWrapper();

    DeterministicAeadWrapper() {
    }

    @Override
    public DeterministicAead wrap(PrimitiveSet<DeterministicAead> primitives) {
        return new WrappedDeterministicAead(primitives);
    }

    @Override
    public Class<DeterministicAead> getPrimitiveClass() {
        return DeterministicAead.class;
    }

    @Override
    public Class<DeterministicAead> getInputPrimitiveClass() {
        return DeterministicAead.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedDeterministicAead
    implements DeterministicAead {
        private final PrimitiveSet<DeterministicAead> primitives;
        private final MonitoringClient.Logger encLogger;
        private final MonitoringClient.Logger decLogger;

        public WrappedDeterministicAead(PrimitiveSet<DeterministicAead> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.encLogger = client.createLogger(keysetInfo, "daead", "encrypt");
                this.decLogger = client.createLogger(keysetInfo, "daead", "decrypt");
            } else {
                this.encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] encryptDeterministically(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                byte[] output = Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().encryptDeterministically(plaintext, associatedData));
                this.encLogger.log(this.primitives.getPrimary().getKeyId(), plaintext.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }

        @Override
        public byte[] decryptDeterministically(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOf(ciphertext, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                    try {
                        byte[] output = entry.getPrimitive().decryptDeterministically(ciphertextNoPrefix, associatedData);
                        this.decLogger.log(entry.getKeyId(), ciphertextNoPrefix.length);
                        return output;
                    }
                    catch (GeneralSecurityException e) {
                    }
                }
            }
            List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                try {
                    byte[] output = entry.getPrimitive().decryptDeterministically(ciphertext, associatedData);
                    this.decLogger.log(entry.getKeyId(), ciphertext.length);
                    return output;
                }
                catch (GeneralSecurityException e) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

