/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AeadParameters;
import com.google.crypto.tink.aead.AesCtrHmacAeadParameters;
import com.google.crypto.tink.aead.AesEaxParameters;
import com.google.crypto.tink.aead.AesGcmParameters;
import com.google.crypto.tink.aead.AesGcmSivParameters;
import com.google.crypto.tink.aead.ChaCha20Poly1305Parameters;
import com.google.crypto.tink.aead.KmsEnvelopeAead;
import com.google.crypto.tink.aead.LegacyKmsEnvelopeAeadParameters;
import com.google.crypto.tink.aead.LegacyKmsEnvelopeAeadProtoSerialization;
import com.google.crypto.tink.aead.XChaCha20Poly1305Parameters;
import com.google.crypto.tink.internal.KeyTemplateProtoConverter;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKey;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKeyFormat;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;

public class KmsEnvelopeAeadKeyManager
extends KeyTypeManager<KmsEnvelopeAeadKey> {
    private static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey";

    KmsEnvelopeAeadKeyManager() {
        super(KmsEnvelopeAeadKey.class, new PrimitiveFactory<Aead, KmsEnvelopeAeadKey>(Aead.class){

            @Override
            public Aead getPrimitive(KmsEnvelopeAeadKey keyProto) throws GeneralSecurityException {
                String keyUri = keyProto.getParams().getKekUri();
                KmsClient kmsClient = KmsClients.get(keyUri);
                Aead remote = kmsClient.getAead(keyUri);
                return new KmsEnvelopeAead(keyProto.getParams().getDekTemplate(), remote);
            }
        });
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.REMOTE;
    }

    @Override
    public void validateKey(KmsEnvelopeAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (!KmsEnvelopeAead.isSupportedDekKeyType(key.getParams().getDekTemplate().getTypeUrl())) {
            throw new GeneralSecurityException("Unsupported DEK key type: " + key.getParams().getDekTemplate().getTypeUrl() + ". Only Tink AEAD key types are supported.");
        }
    }

    @Override
    public KmsEnvelopeAeadKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsEnvelopeAeadKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<KmsEnvelopeAeadKeyFormat, KmsEnvelopeAeadKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<KmsEnvelopeAeadKeyFormat, KmsEnvelopeAeadKey>(KmsEnvelopeAeadKeyFormat.class){

            @Override
            public void validateKeyFormat(KmsEnvelopeAeadKeyFormat format) throws GeneralSecurityException {
                if (!KmsEnvelopeAead.isSupportedDekKeyType(format.getDekTemplate().getTypeUrl())) {
                    throw new GeneralSecurityException("Unsupported DEK key type: " + format.getDekTemplate().getTypeUrl() + ". Only Tink AEAD key types are supported.");
                }
                if (format.getKekUri().isEmpty() || !format.hasDekTemplate()) {
                    throw new GeneralSecurityException("invalid key format: missing KEK URI or DEK template");
                }
            }

            @Override
            public KmsEnvelopeAeadKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return KmsEnvelopeAeadKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public KmsEnvelopeAeadKey createKey(KmsEnvelopeAeadKeyFormat format) {
                return (KmsEnvelopeAeadKey)KmsEnvelopeAeadKey.newBuilder().setParams(format).setVersion(KmsEnvelopeAeadKeyManager.this.getVersion()).build();
            }
        };
    }

    private static AeadParameters makeRawAesGcm(AesGcmParameters parameters) throws GeneralSecurityException {
        return AesGcmParameters.builder().setIvSizeBytes(parameters.getIvSizeBytes()).setKeySizeBytes(parameters.getKeySizeBytes()).setTagSizeBytes(parameters.getTagSizeBytes()).setVariant(AesGcmParameters.Variant.NO_PREFIX).build();
    }

    private static AeadParameters makeRawChaCha20Poly1305() {
        return ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.NO_PREFIX);
    }

    private static AeadParameters makeRawXChaCha20Poly1305() {
        return XChaCha20Poly1305Parameters.create(XChaCha20Poly1305Parameters.Variant.NO_PREFIX);
    }

    private static AeadParameters makeRawAesCtrHmacAead(AesCtrHmacAeadParameters parameters) throws GeneralSecurityException {
        return AesCtrHmacAeadParameters.builder().setAesKeySizeBytes(parameters.getAesKeySizeBytes()).setHmacKeySizeBytes(parameters.getHmacKeySizeBytes()).setTagSizeBytes(parameters.getTagSizeBytes()).setIvSizeBytes(parameters.getIvSizeBytes()).setHashType(parameters.getHashType()).setVariant(AesCtrHmacAeadParameters.Variant.NO_PREFIX).build();
    }

    private static AeadParameters makeRawAesEax(AesEaxParameters parameters) throws GeneralSecurityException {
        return AesEaxParameters.builder().setIvSizeBytes(parameters.getIvSizeBytes()).setKeySizeBytes(parameters.getKeySizeBytes()).setTagSizeBytes(parameters.getTagSizeBytes()).setVariant(AesEaxParameters.Variant.NO_PREFIX).build();
    }

    private static AeadParameters makeRawAesGcmSiv(AesGcmSivParameters parameters) throws GeneralSecurityException {
        return AesGcmSivParameters.builder().setKeySizeBytes(parameters.getKeySizeBytes()).setVariant(AesGcmSivParameters.Variant.NO_PREFIX).build();
    }

    private static AeadParameters makeRaw(Parameters parameters) throws GeneralSecurityException {
        if (parameters instanceof AesGcmParameters) {
            return KmsEnvelopeAeadKeyManager.makeRawAesGcm((AesGcmParameters)parameters);
        }
        if (parameters instanceof ChaCha20Poly1305Parameters) {
            return KmsEnvelopeAeadKeyManager.makeRawChaCha20Poly1305();
        }
        if (parameters instanceof XChaCha20Poly1305Parameters) {
            return KmsEnvelopeAeadKeyManager.makeRawXChaCha20Poly1305();
        }
        if (parameters instanceof AesCtrHmacAeadParameters) {
            return KmsEnvelopeAeadKeyManager.makeRawAesCtrHmacAead((AesCtrHmacAeadParameters)parameters);
        }
        if (parameters instanceof AesEaxParameters) {
            return KmsEnvelopeAeadKeyManager.makeRawAesEax((AesEaxParameters)parameters);
        }
        if (parameters instanceof AesGcmSivParameters) {
            return KmsEnvelopeAeadKeyManager.makeRawAesGcmSiv((AesGcmSivParameters)parameters);
        }
        throw new IllegalArgumentException("Illegal parameters" + parameters);
    }

    private static LegacyKmsEnvelopeAeadParameters.DekParsingStrategy getRequiredParsingStrategy(AeadParameters parameters) {
        if (parameters instanceof AesGcmParameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_AES_GCM;
        }
        if (parameters instanceof ChaCha20Poly1305Parameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_CHACHA20POLY1305;
        }
        if (parameters instanceof XChaCha20Poly1305Parameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_XCHACHA20POLY1305;
        }
        if (parameters instanceof AesCtrHmacAeadParameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_AES_CTR_HMAC;
        }
        if (parameters instanceof AesEaxParameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_AES_EAX;
        }
        if (parameters instanceof AesGcmSivParameters) {
            return LegacyKmsEnvelopeAeadParameters.DekParsingStrategy.ASSUME_AES_GCM_SIV;
        }
        throw new IllegalArgumentException("Illegal parameters" + parameters);
    }

    @AccessesPartialKey
    public static KeyTemplate createKeyTemplate(String kekUri, KeyTemplate dekTemplate) {
        try {
            Parameters parameters = dekTemplate.toParameters();
            AeadParameters outputPrefixRawParameters = KmsEnvelopeAeadKeyManager.makeRaw(parameters);
            LegacyKmsEnvelopeAeadParameters legacyKmsEnvelopeAeadParameters = LegacyKmsEnvelopeAeadParameters.builder().setKekUri(kekUri).setDekParsingStrategy(KmsEnvelopeAeadKeyManager.getRequiredParsingStrategy(outputPrefixRawParameters)).setDekParametersForNewKeys(outputPrefixRawParameters).build();
            return KeyTemplate.createFrom(legacyKmsEnvelopeAeadParameters);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Cannot create LegacyKmsEnvelopeAeadParameters for template: " + dekTemplate, e);
        }
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new KmsEnvelopeAeadKeyManager(), newKeyAllowed);
        LegacyKmsEnvelopeAeadProtoSerialization.register();
    }

    static KmsEnvelopeAeadKeyFormat createKeyFormat(String kekUri, KeyTemplate dekTemplate) throws GeneralSecurityException, InvalidProtocolBufferException {
        com.google.crypto.tink.proto.KeyTemplate protoDekTemplate = KeyTemplateProtoConverter.toProto(dekTemplate);
        if (!KmsEnvelopeAead.isSupportedDekKeyType(protoDekTemplate.getTypeUrl())) {
            throw new IllegalArgumentException("Unsupported DEK key type: " + protoDekTemplate.getTypeUrl() + ". Only Tink AEAD key types are supported.");
        }
        return (KmsEnvelopeAeadKeyFormat)KmsEnvelopeAeadKeyFormat.newBuilder().setDekTemplate(protoDekTemplate).setKekUri(kekUri).build();
    }
}

