/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;

public final class EcdsaVerifyJce
implements PublicKeyVerify {
    private final ECPublicKey publicKey;
    private final String signatureAlgorithm;

    public EcdsaVerifyJce(ECPublicKey pubKey, String signatureAlgorithm) throws GeneralSecurityException {
        EllipticCurves.checkPublicKey(pubKey);
        this.publicKey = pubKey;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        if (!this.isDerEncoding(signature)) {
            throw new GeneralSecurityException("Invalid signature");
        }
        Signature verifier = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm);
        verifier.initVerify(this.publicKey);
        verifier.update(data);
        boolean verified = false;
        try {
            verified = verifier.verify(signature);
        }
        catch (RuntimeException ex) {
            verified = false;
        }
        if (!verified) {
            throw new GeneralSecurityException("Invalid signature");
        }
    }

    private boolean isDerEncoding(byte[] sig) {
        if (sig.length < 8) {
            return false;
        }
        if (sig[0] != 48) {
            return false;
        }
        int totalLen = sig[1] & 0xFF;
        int totalLenLen = 1;
        if (totalLen == 129) {
            totalLenLen = 2;
            totalLen = sig[2] & 0xFF;
            if (totalLen < 128) {
                return false;
            }
        } else if (totalLen == 128 || totalLen > 129) {
            return false;
        }
        if (totalLen != sig.length - 1 - totalLenLen) {
            return false;
        }
        if (sig[1 + totalLenLen] != 2) {
            return false;
        }
        int rLen = sig[1 + totalLenLen + 1] & 0xFF;
        if (1 + totalLenLen + 1 + 1 + rLen + 1 >= sig.length) {
            return false;
        }
        if (rLen == 0) {
            return false;
        }
        if ((sig[3 + totalLenLen] & 0xFF) >= 128) {
            return false;
        }
        if (rLen > 1 && sig[3 + totalLenLen] == 0 && (sig[4 + totalLenLen] & 0xFF) < 128) {
            return false;
        }
        if (sig[3 + totalLenLen + rLen] != 2) {
            return false;
        }
        int sLen = sig[1 + totalLenLen + 1 + 1 + rLen + 1] & 0xFF;
        if (1 + totalLenLen + 1 + 1 + rLen + 1 + 1 + sLen != sig.length) {
            return false;
        }
        if (sLen == 0) {
            return false;
        }
        if ((sig[5 + totalLenLen + rLen] & 0xFF) >= 128) {
            return false;
        }
        return sLen <= 1 || sig[5 + totalLenLen + rLen] != 0 || (sig[6 + totalLenLen + rLen] & 0xFF) >= 128;
    }
}

