/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;

public final class PublicKeySignFactory {
    public static PublicKeySign getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return PublicKeySignFactory.getPrimitive(keysetHandle, null);
    }

    public static PublicKeySign getPrimitive(KeysetHandle keysetHandle, KeyManager<PublicKeySign> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<PublicKeySign> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        return new PublicKeySign(){

            @Override
            public byte[] sign(byte[] data) throws GeneralSecurityException {
                if (primitives.getPrimary().getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                    byte[] formatVersion = new byte[]{0};
                    return Bytes.concat(primitives.getPrimary().getIdentifier(), ((PublicKeySign)primitives.getPrimary().getPrimitive()).sign(Bytes.concat(data, formatVersion)));
                }
                return Bytes.concat(primitives.getPrimary().getIdentifier(), ((PublicKeySign)primitives.getPrimary().getPrimitive()).sign(data));
            }
        };
    }
}

