/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.streamingaead.StreamingAeadHelper;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

public final class StreamingAeadFactory {
    private static final Logger logger = Logger.getLogger(StreamingAeadFactory.class.getName());

    public static StreamingAead getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return StreamingAeadFactory.getPrimitive(keysetHandle, null);
    }

    public static StreamingAead getPrimitive(KeysetHandle keysetHandle, KeyManager<StreamingAead> keyManager) throws GeneralSecurityException {
        PrimitiveSet<StreamingAead> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        return new StreamingAeadHelper(primitives);
    }
}

