/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaSignatureEncoding;
import com.google.crypto.tink.proto.EllipticCurveType;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;

final class SigUtil {
    static final String INVALID_PARAMS = "Invalid ECDSA parameters";

    SigUtil() {
    }

    public static String toEcdsaAlgo(HashType hash) throws NoSuchAlgorithmException {
        switch (hash) {
            case SHA256: {
                return "SHA256WithECDSA";
            }
            case SHA512: {
                return "SHA512WithECDSA";
            }
        }
        throw new NoSuchAlgorithmException("hash unsupported for signature: " + (Object)((Object)hash));
    }

    public static void validateEcdsaParams(EcdsaParams params) throws GeneralSecurityException {
        EcdsaSignatureEncoding encoding = params.getEncoding();
        HashType hash = params.getHashType();
        EllipticCurveType curve = params.getCurve();
        switch (encoding) {
            case DER: {
                break;
            }
            default: {
                throw new GeneralSecurityException("unsupported signature encoding");
            }
        }
        switch (curve) {
            case NIST_P256: {
                if (hash == HashType.SHA256) break;
                throw new GeneralSecurityException(INVALID_PARAMS);
            }
            case NIST_P384: 
            case NIST_P521: {
                if (hash == HashType.SHA512) break;
                throw new GeneralSecurityException(INVALID_PARAMS);
            }
            default: {
                throw new GeneralSecurityException(INVALID_PARAMS);
            }
        }
    }

    public static EllipticCurves.CurveType toCurveType(EllipticCurveType type) throws GeneralSecurityException {
        switch (type) {
            case NIST_P256: {
                return EllipticCurves.CurveType.NIST_P256;
            }
            case NIST_P384: {
                return EllipticCurves.CurveType.NIST_P384;
            }
            case NIST_P521: {
                return EllipticCurves.CurveType.NIST_P521;
            }
        }
        throw new GeneralSecurityException("unknown curve type: " + (Object)((Object)type));
    }
}

