/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public final class HybridDecryptFactory {
    private static final Logger logger = Logger.getLogger(HybridDecryptFactory.class.getName());

    public static HybridDecrypt getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return HybridDecryptFactory.getPrimitive(keysetHandle, null);
    }

    public static HybridDecrypt getPrimitive(KeysetHandle keysetHandle, KeyManager<HybridDecrypt> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<HybridDecrypt> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        return new HybridDecrypt(){

            @Override
            public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
                if (ciphertext.length > 5) {
                    byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                    byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                    List entries = primitives.getPrimitive(prefix);
                    for (PrimitiveSet.Entry entry : entries) {
                        try {
                            return ((HybridDecrypt)entry.getPrimitive()).decrypt(ciphertextNoPrefix, contextInfo);
                        }
                        catch (GeneralSecurityException e) {
                            logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                        }
                    }
                }
                List entries = primitives.getRawPrimitives();
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        return ((HybridDecrypt)entry.getPrimitive()).decrypt(ciphertext, contextInfo);
                    }
                    catch (GeneralSecurityException e) {
                    }
                }
                throw new GeneralSecurityException("decryption failed");
            }
        };
    }
}

