/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.AesCtrKeyFormat;
import com.google.crypto.tink.proto.AesCtrParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesCtrJceCipher;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesCtrKeyManager
implements KeyManager<IndCpaCipher> {
    private static final int VERSION = 0;
    static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrKey";
    private static final int MIN_IV_SIZE_IN_BYTES = 12;

    AesCtrKeyManager() {
    }

    @Override
    public AesCtrJceCipher getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesCtrKey keyProto = AesCtrKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesCtrKey proto", e);
        }
    }

    @Override
    public AesCtrJceCipher getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesCtrKey)) {
            throw new GeneralSecurityException("expected AesCtrKey proto");
        }
        AesCtrKey keyProto = (AesCtrKey)key;
        this.validate(keyProto);
        return new AesCtrJceCipher(keyProto.getKeyValue().toByteArray(), keyProto.getParams().getIvSize());
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesCtrKeyFormat format = AesCtrKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesCtrKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesCtrKeyFormat)) {
            throw new GeneralSecurityException("expected AesCtrKeyFormat proto");
        }
        AesCtrKeyFormat format = (AesCtrKeyFormat)keyFormat;
        this.validate(format);
        return AesCtrKey.newBuilder().setParams(format.getParams()).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesCtrKey key = (AesCtrKey)this.newKey(serializedKeyFormat);
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesCtrKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
        this.validate(key.getParams());
    }

    private void validate(AesCtrKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
        this.validate(format.getParams());
    }

    private void validate(AesCtrParams params) throws GeneralSecurityException {
        if (params.getIvSize() < 12 || params.getIvSize() > 16) {
            throw new GeneralSecurityException("invalid IV size");
        }
    }
}

