/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.StreamSegmentEncrypter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;

class StreamingAeadEncryptingChannel
implements WritableByteChannel {
    private WritableByteChannel ciphertextChannel;
    private StreamSegmentEncrypter encrypter;
    ByteBuffer ptBuffer;
    ByteBuffer ctBuffer;
    private int plaintextSegmentSize;
    boolean open = true;

    public StreamingAeadEncryptingChannel(StreamSegmentEncrypter encrypter, WritableByteChannel ciphertextChannel, int plaintextSegmentSize, int ciphertextSegmentSize, int ciphertextOffset) throws GeneralSecurityException, IOException {
        this.ciphertextChannel = ciphertextChannel;
        this.encrypter = encrypter;
        this.ptBuffer = ByteBuffer.allocate(plaintextSegmentSize);
        this.plaintextSegmentSize = plaintextSegmentSize;
        this.ptBuffer.limit(plaintextSegmentSize - ciphertextOffset);
        this.ctBuffer = ByteBuffer.allocate(ciphertextSegmentSize);
        this.ctBuffer.put(encrypter.getHeader());
        this.ctBuffer.flip();
        ciphertextChannel.write(this.ctBuffer);
    }

    @Override
    public synchronized int write(ByteBuffer pt) throws IOException {
        if (this.ctBuffer.remaining() > 0) {
            this.ciphertextChannel.write(this.ctBuffer);
        }
        int startPosition = pt.position();
        while (pt.remaining() > this.ptBuffer.remaining()) {
            if (this.ctBuffer.remaining() > 0) {
                return pt.position() - startPosition;
            }
            int sliceSize = this.ptBuffer.remaining();
            ByteBuffer slice = pt.slice();
            slice.limit(sliceSize);
            pt.position(pt.position() + sliceSize);
            try {
                this.ptBuffer.flip();
                this.ctBuffer.clear();
                this.encrypter.encryptSegment(this.ptBuffer, slice, false, this.ctBuffer);
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            this.ctBuffer.flip();
            this.ciphertextChannel.write(this.ctBuffer);
            this.ptBuffer.clear();
            this.ptBuffer.limit(this.plaintextSegmentSize);
        }
        this.ptBuffer.put(pt);
        return pt.position() - startPosition;
    }

    @Override
    public synchronized void close() throws IOException {
        int n;
        while (this.ctBuffer.remaining() > 0) {
            n = this.ciphertextChannel.write(this.ctBuffer);
            if (n > 0) continue;
            throw new IOException("Failed to write ciphertext before closing");
        }
        try {
            this.ctBuffer.clear();
            this.ptBuffer.flip();
            this.encrypter.encryptSegment(this.ptBuffer, true, this.ctBuffer);
        }
        catch (GeneralSecurityException ex) {
            throw new IOException(ex);
        }
        this.ctBuffer.flip();
        while (this.ctBuffer.remaining() > 0) {
            n = this.ciphertextChannel.write(this.ctBuffer);
            if (n > 0) continue;
            throw new IOException("Failed to write ciphertext before closing");
        }
        this.ciphertextChannel.close();
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

