/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.subtle.Curve25519;
import com.google.crypto.tink.subtle.DjbCipher;
import com.google.crypto.tink.subtle.DjbCipherPoly1305;
import com.google.crypto.tink.subtle.ImmutableByteArray;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;

@Alpha
public final class NaClCryptoBox {
    private static final byte[] EMPTY_AAD = new byte[0];

    public static HybridEncrypt hybridEncryptWithXSalsa20Poly1305(byte[] peerPublicKey) {
        return new Curve25519DjbCipherPoly1305HybridEncrypt(peerPublicKey, new XSalsa20Poly1305NaclFactory());
    }

    public static HybridEncrypt hybridEncryptWithChaCha20Poly1305(byte[] peerPublicKey) {
        return new Curve25519DjbCipherPoly1305HybridEncrypt(peerPublicKey, new ChaCha20Poly1305IetfFactory());
    }

    public static HybridEncrypt hybridEncryptWithXChaCha20Poly1305(byte[] peerPublicKey) {
        return new Curve25519DjbCipherPoly1305HybridEncrypt(peerPublicKey, new XChaCha20Poly1305IetfFactory());
    }

    public static HybridDecrypt hybridDecryptWithXSalsa20Poly1305(byte[] privateKey) {
        return new Curve25519DjbCipherPoly1305HybridDecrypt(privateKey, new XSalsa20Poly1305NaclFactory());
    }

    public static HybridDecrypt hybridDecryptWithChaCha20Poly1305(byte[] privateKey) {
        return new Curve25519DjbCipherPoly1305HybridDecrypt(privateKey, new ChaCha20Poly1305IetfFactory());
    }

    public static HybridDecrypt hybridDecryptWithXChaCha20Poly1305(byte[] privateKey) {
        return new Curve25519DjbCipherPoly1305HybridDecrypt(privateKey, new XChaCha20Poly1305IetfFactory());
    }

    public static byte[] generatePrivateKey() {
        return Curve25519.generatePrivateKey();
    }

    public static byte[] getPublicKey(byte[] privateKey) {
        return Curve25519.x25519PublicFromPrivate(privateKey);
    }

    private static class Curve25519DjbCipherPoly1305HybridDecrypt
    implements HybridDecrypt {
        private final ImmutableByteArray privateKey;
        private final Curve25519DjbCipherPoly1305Factory factory;

        private Curve25519DjbCipherPoly1305HybridDecrypt(byte[] privateKey, Curve25519DjbCipherPoly1305Factory factory) {
            this.privateKey = ImmutableByteArray.of(privateKey);
            this.factory = factory;
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
            ByteBuffer ciphertextBuf = ByteBuffer.wrap(ciphertext);
            byte[] peerPublicKey = new byte[32];
            ciphertextBuf.get(peerPublicKey);
            return this.factory.constructWithKem(this.privateKey.getBytes(), peerPublicKey).decrypt(ciphertextBuf, EMPTY_AAD);
        }
    }

    private static class Curve25519DjbCipherPoly1305HybridEncrypt
    implements HybridEncrypt {
        private final ImmutableByteArray ephemeralPublicKey;
        private final DjbCipherPoly1305 djbCipherPoly1305;

        private Curve25519DjbCipherPoly1305HybridEncrypt(byte[] peerPublicKey, Curve25519DjbCipherPoly1305Factory factory) {
            byte[] ephemeralPrivateKey = NaClCryptoBox.generatePrivateKey();
            this.ephemeralPublicKey = ImmutableByteArray.of(NaClCryptoBox.getPublicKey(ephemeralPrivateKey));
            this.djbCipherPoly1305 = factory.constructWithKem(ephemeralPrivateKey, peerPublicKey);
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
            ByteBuffer output = ByteBuffer.allocate(32 + this.djbCipherPoly1305.nonceSizeInBytes() + plaintext.length + 16);
            output.put(this.ephemeralPublicKey.getBytes());
            this.djbCipherPoly1305.encrypt(output, plaintext, EMPTY_AAD);
            return output.array();
        }
    }

    private static class XChaCha20Poly1305IetfFactory
    extends Curve25519DjbCipherPoly1305Factory {
        private XChaCha20Poly1305IetfFactory() {
        }

        @Override
        public DjbCipherPoly1305 constructFromSymmetricKey(byte[] sharedSecret) {
            return DjbCipherPoly1305.constructXChaCha20Poly1305Ietf(DjbCipher.ChaCha20Base.hChaCha20(sharedSecret));
        }
    }

    private static class ChaCha20Poly1305IetfFactory
    extends Curve25519DjbCipherPoly1305Factory {
        private ChaCha20Poly1305IetfFactory() {
        }

        @Override
        public DjbCipherPoly1305 constructFromSymmetricKey(byte[] sharedSecret) {
            return DjbCipherPoly1305.constructChaCha20Poly1305Ietf(DjbCipher.ChaCha20Base.hChaCha20(sharedSecret));
        }
    }

    private static class XSalsa20Poly1305NaclFactory
    extends Curve25519DjbCipherPoly1305Factory {
        private XSalsa20Poly1305NaclFactory() {
        }

        @Override
        public DjbCipherPoly1305 constructFromSymmetricKey(byte[] sharedSecret) {
            return DjbCipherPoly1305.constructXSalsa20Poly1305Nacl(DjbCipher.XSalsa20.hSalsa20(sharedSecret));
        }
    }

    private static abstract class Curve25519DjbCipherPoly1305Factory {
        private Curve25519DjbCipherPoly1305Factory() {
        }

        abstract DjbCipherPoly1305 constructFromSymmetricKey(byte[] var1);

        DjbCipherPoly1305 constructWithKem(byte[] privateKey, byte[] peerPublicKey) {
            return this.constructFromSymmetricKey(Curve25519.x25519(privateKey, peerPublicKey));
        }
    }
}

