/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.errorprone.annotations.Immutable;

@Immutable
public final class ImmutableByteArray {
    private final byte[] data;

    public static ImmutableByteArray of(byte[] data) {
        if (data == null) {
            return null;
        }
        return ImmutableByteArray.of(data, 0, data.length);
    }

    public static ImmutableByteArray of(byte[] data, int start, int len) {
        return new ImmutableByteArray(data, start, len);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.data.length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        return result;
    }

    public int getLength() {
        return this.data.length;
    }

    private ImmutableByteArray(byte[] buf, int start, int len) {
        this.data = new byte[len];
        System.arraycopy(buf, start, this.data, 0, len);
    }
}

