/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.IndCpaCipher;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public final class EncryptThenAuthenticate
implements Aead {
    private final IndCpaCipher cipher;
    private final Mac mac;
    private final int macLength;

    public EncryptThenAuthenticate(IndCpaCipher cipher, Mac mac, int macLength) {
        this.cipher = cipher;
        this.mac = mac;
        this.macLength = macLength;
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] aad) throws GeneralSecurityException {
        byte[] ciphertext = this.cipher.encrypt(plaintext);
        byte[] aadLengthInBits = Arrays.copyOf(ByteBuffer.allocate(8).putLong(8L * (long)aad.length).array(), 8);
        byte[] macValue = this.mac.computeMac(Bytes.concat(aad, ciphertext, aadLengthInBits));
        return Bytes.concat(ciphertext, macValue);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        if (ciphertext.length < this.macLength) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] rawCiphertext = Arrays.copyOfRange(ciphertext, 0, ciphertext.length - this.macLength);
        byte[] macValue = Arrays.copyOfRange(ciphertext, ciphertext.length - this.macLength, ciphertext.length);
        byte[] aadLengthInBits = Arrays.copyOf(ByteBuffer.allocate(8).putLong(8L * (long)aad.length).array(), 8);
        this.mac.verifyMac(macValue, Bytes.concat(aad, rawCiphertext, aadLengthInBits));
        return this.cipher.decrypt(rawCiphertext);
    }
}

