/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Curve25519;
import java.math.BigInteger;
import java.util.Arrays;

public final class Ed25519ConstantsGenerator {
    private static final BigInteger P = BigInteger.valueOf(2L).pow(255).subtract(BigInteger.valueOf(19L));
    private static final BigInteger D = BigInteger.valueOf(-121665L).multiply(BigInteger.valueOf(121666L).modInverse(P)).mod(P);
    private static final BigInteger D2 = BigInteger.valueOf(2L).multiply(D).mod(P);
    private static final BigInteger SQRTM1 = BigInteger.valueOf(2L).modPow(P.subtract(BigInteger.ONE).divide(BigInteger.valueOf(4L)), P);

    private static BigInteger recoverX(BigInteger y) {
        BigInteger xx = y.pow(2).subtract(BigInteger.ONE).multiply(D.multiply(y.pow(2)).add(BigInteger.ONE).modInverse(P));
        BigInteger x = xx.modPow(P.add(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(8L)), P);
        if (!x.pow(2).subtract(xx).mod(P).equals(BigInteger.ZERO)) {
            x = x.multiply(SQRTM1).mod(P);
        }
        if (x.testBit(0)) {
            x = P.subtract(x);
        }
        return x;
    }

    private static Point edwards(Point a, Point b) {
        Point o = new Point();
        o.x = a.x.multiply(b.y).add(b.x.multiply(a.y)).multiply(BigInteger.ONE.add(Ed25519ConstantsGenerator.D.multiply(a.x.multiply(b.x).multiply(a.y).multiply(b.y))).modInverse(Ed25519ConstantsGenerator.P)).mod(Ed25519ConstantsGenerator.P);
        o.y = a.y.multiply(b.y).add(a.x.multiply(b.x)).multiply(BigInteger.ONE.subtract(Ed25519ConstantsGenerator.D.multiply(a.x.multiply(b.x).multiply(a.y).multiply(b.y))).modInverse(Ed25519ConstantsGenerator.P)).mod(Ed25519ConstantsGenerator.P);
        return o;
    }

    private static byte[] toLittleEndian(BigInteger n) {
        byte[] b = new byte[32];
        byte[] nBytes = n.toByteArray();
        System.arraycopy(nBytes, 0, b, 32 - nBytes.length, nBytes.length);
        for (int i = 0; i < b.length / 2; ++i) {
            byte t = b[i];
            b[i] = b[b.length - i - 1];
            b[b.length - i - 1] = t;
        }
        return b;
    }

    private static String replaceBrackets(String array) {
        return array.replace("[", "{").replace("]", "}");
    }

    private static String getCachedXYTStr(Point p) {
        String decl = "new CachedXYT(\n";
        decl = decl + "new long[]" + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(p.y.add(p.x).mod(P))))) + ",\n";
        decl = decl + "new long[]" + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(p.y.subtract(p.x).mod(P))))) + ",\n";
        decl = decl + "new long[]" + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(D2.multiply(p.x).multiply(p.y).mod(P))))) + ")";
        return decl;
    }

    public static void main(String[] args) {
        Point b = new Point();
        b.y = BigInteger.valueOf(4L).multiply(BigInteger.valueOf(5L).modInverse(Ed25519ConstantsGenerator.P)).mod(Ed25519ConstantsGenerator.P);
        b.x = Ed25519ConstantsGenerator.recoverX(b.y);
        String decl = "static final long[]";
        System.out.println("// d = -121665 / 121666 mod 2^255-19");
        System.out.println(decl + " D = " + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(D)))) + ";");
        System.out.println("// 2d");
        System.out.println(decl + " D2 = " + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(D2)))) + ";");
        System.out.println("// 2^((p-1)/4) mod p where p = 2^255-19");
        System.out.println(decl + " SQRTM1 = " + Ed25519ConstantsGenerator.replaceBrackets(Arrays.toString(Curve25519.expand(Ed25519ConstantsGenerator.toLittleEndian(SQRTM1)))) + ";");
        Point bi = b;
        System.out.println("static final CachedXYT[][] B_TABLE = new CachedXYT[][]{");
        for (int i = 0; i < 32; ++i) {
            int j;
            System.out.println("{");
            Point bij = bi;
            for (j = 0; j < 8; ++j) {
                System.out.println(Ed25519ConstantsGenerator.getCachedXYTStr(bij) + ",");
                bij = Ed25519ConstantsGenerator.edwards(bij, bi);
            }
            System.out.println("},");
            for (j = 0; j < 8; ++j) {
                bi = Ed25519ConstantsGenerator.edwards(bi, bi);
            }
        }
        System.out.println("};");
        bi = b;
        Point b2 = Ed25519ConstantsGenerator.edwards(b, b);
        System.out.println("static final CachedXYT[] B2 = new CachedXYT[]{");
        for (int i = 0; i < 8; ++i) {
            System.out.println(Ed25519ConstantsGenerator.getCachedXYTStr(bi) + ",");
            bi = Ed25519ConstantsGenerator.edwards(bi, b2);
        }
        System.out.println("};");
    }

    private static class Point {
        private BigInteger x;
        private BigInteger y;

        private Point() {
        }
    }
}

