/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Ed25519;

class Ed25519Constants {
    static final long[] D = new long[]{56195235L, 13857412L, 51736253L, 6949390L, 114729L, 24766616L, 60832955L, 30306712L, 48412415L, 21499315L};
    static final long[] D2 = new long[]{45281625L, 27714825L, 36363642L, 0xD4141DL, 229458L, 15978800L, 54557047L, 27058993L, 29715967L, 9444199L};
    static final long[] SQRTM1 = new long[]{34513072L, 25610706L, 9377949L, 3500415L, 12389472L, 33281959L, 41962654L, 31548777L, 326685L, 11406482L};
    static final Ed25519.CachedXYT[][] B_TABLE = new Ed25519.CachedXYT[][]{{new Ed25519.CachedXYT(new long[]{25967493L, 19198397L, 29566455L, 3660896L, 54414519L, 4014786L, 27544626L, 21800161L, 61029707L, 2047604L}, new long[]{54563134L, 934261L, 64385954L, 3049989L, 66381436L, 9406985L, 12720692L, 5043384L, 19500929L, 18085054L}, new long[]{58370664L, 4489569L, 9688441L, 18769238L, 10184608L, 21191052L, 29287918L, 11864899L, 42594502L, 29115885L}), new Ed25519.CachedXYT(new long[]{54292951L, 20578084L, 45527620L, 11784319L, 41753206L, 30803714L, 55390960L, 29739860L, 66750418L, 23343128L}, new long[]{45405608L, 6903824L, 27185491L, 6451973L, 37531140L, 24000426L, 51492312L, 11189267L, 40279186L, 28235350L}, new long[]{26966623L, 11152617L, 32442495L, 15396054L, 14353839L, 20802097L, 63980037L, 24013313L, 51636816L, 29387734L}), new Ed25519.CachedXYT(new long[]{15636272L, 23865875L, 24204772L, 25642034L, 616976L, 16869170L, 27787599L, 18782243L, 28944399L, 32004408L}, new long[]{16568933L, 4717097L, 55552716L, 32452109L, 15682895L, 21747389L, 16354576L, 21778470L, 7689661L, 11199574L}, new long[]{30464137L, 27578307L, 55329429L, 17883566L, 23220364L, 15915852L, 7512774L, 10017326L, 49359771L, 23634074L}), new Ed25519.CachedXYT(new long[]{50071967L, 13921891L, 10945806L, 27521001L, 27105051L, 17470053L, 38182653L, 15006022L, 3284568L, 27277892L}, new long[]{23599295L, 25248385L, 55915199L, 25867015L, 13236773L, 10506355L, 7464579L, 9656445L, 13059162L, 10374397L}, new long[]{7798537L, 16710257L, 3033922L, 2874086L, 28997861L, 2835604L, 32406664L, 29715387L, 66467155L, 33453106L}), new Ed25519.CachedXYT(new long[]{10861363L, 11473154L, 27284546L, 1981175L, 37044515L, 12577860L, 32867885L, 14515107L, 51670560L, 10819379L}, new long[]{4708026L, 6336745L, 20377586L, 9066809L, 55836755L, 6594695L, 41455196L, 12483687L, 54440373L, 5581305L}, new long[]{19563141L, 16186464L, 37722007L, 4097518L, 10237984L, 29206317L, 28542349L, 13850243L, 43430843L, 17738489L}), new Ed25519.CachedXYT(new long[]{51736881L, 20691677L, 32573249L, 4720197L, 40672342L, 5875510L, 47920237L, 18329612L, 57289923L, 21468654L}, new long[]{58559652L, 109982L, 15149363L, 2178705L, 22900618L, 4543417L, 3044240L, 17864545L, 1762327L, 14866737L}, new long[]{48909169L, 17603008L, 56635573L, 1707277L, 49922944L, 3916100L, 38872452L, 3959420L, 27914454L, 4383652L}), new Ed25519.CachedXYT(new long[]{5153727L, 9909285L, 1723747L, 30776558L, 30523604L, 5516873L, 19480852L, 5230134L, 43156425L, 18378665L}, new long[]{36839857L, 30090922L, 7665485L, 0x99DDD1L, 28475525L, 1649722L, 20654025L, 16520125L, 30598449L, 0x75BB75L}, new long[]{28881826L, 14381568L, 9657904L, 3680757L, 46927229L, 7843315L, 35708204L, 1370707L, 29794553L, 32145132L}), new Ed25519.CachedXYT(new long[]{14499471L, 30824833L, 33917750L, 29299779L, 28494861L, 14271267L, 30290735L, 10876454L, 33954766L, 2381725L}, new long[]{59913433L, 30899068L, 52378708L, 462250L, 39384538L, 3941371L, 60872247L, 3696004L, 34808032L, 15351954L}, new long[]{27431194L, 8222322L, 16448760L, 29646437L, 48401861L, 11938354L, 34147463L, 30583916L, 29551812L, 10109425L})}, {new Ed25519.CachedXYT(new long[]{53451805L, 20399000L, 35825113L, 11777097L, 21447386L, 6519384L, 64730580L, 31926875L, 10092782L, 28790261L}, new long[]{27939166L, 14210322L, 4677035L, 16277044L, 44144402L, 21156292L, 34600109L, 12005537L, 49298737L, 12803509L}, new long[]{17228999L, 17892808L, 65875336L, 300139L, 65883994L, 21839654L, 30364212L, 24516238L, 18016356L, 4397660L}), new Ed25519.CachedXYT(new long[]{56150021L, 25864224L, 4776340L, 18600194L, 27850027L, 17952220L, 40489757L, 14544524L, 49631360L, 982638L}, new long[]{29253598L, 15796703L, 64244882L, 23645547L, 10057022L, 3163536L, 7332899L, 29434304L, 46061167L, 9934962L}, new long[]{5793284L, 16271923L, 42977250L, 23438027L, 29188559L, 1206517L, 52360934L, 4559894L, 36984942L, 22656481L}), new Ed25519.CachedXYT(new long[]{39464912L, 22061425L, 16282656L, 22517939L, 28414020L, 18542168L, 24191033L, 4541697L, 53770555L, 5500567L}, new long[]{12650548L, 32057319L, 9052870L, 11355358L, 49428827L, 25154267L, 49678271L, 12264342L, 10874051L, 13524335L}, new long[]{25556948L, 30508442L, 714650L, 2510400L, 23394682L, 23139102L, 33119037L, 5080568L, 44580805L, 5376627L}), new Ed25519.CachedXYT(new long[]{41020600L, 29543379L, 50095164L, 30016803L, 60382070L, 1920896L, 44787559L, 24106988L, 4535767L, 1569007L}, new long[]{64853442L, 14606629L, 45416424L, 25514613L, 28430648L, 8775819L, 36614302L, 3044289L, 31848280L, 12543772L}, new long[]{45080285L, 2943892L, 35251351L, 6777305L, 13784462L, 29262229L, 39731668L, 31491700L, 7718481L, 0xDCDD9DL}), new Ed25519.CachedXYT(new long[]{2385296L, 2454213L, 44477544L, 46602L, 62670929L, 17874016L, 656964L, 26317767L, 24316167L, 28300865L}, new long[]{13741529L, 10911568L, 33875447L, 24950694L, 46931033L, 32521134L, 33040650L, 20129900L, 46379407L, 8321685L}, new long[]{21060490L, 31341688L, 15712756L, 29218333L, 1639039L, 10656336L, 23845965L, 21679594L, 57124405L, 608371L}), new Ed25519.CachedXYT(new long[]{53436132L, 18466845L, 56219170L, 25997372L, 61071954L, 11305546L, 1123968L, 26773855L, 27229398L, 23887L}, new long[]{43864724L, 33260226L, 55364135L, 14712570L, 37643165L, 31524814L, 12797023L, 27114124L, 65475458L, 16678953L}, new long[]{37608244L, 4770661L, 51054477L, 14001337L, 7830047L, 9564805L, 65600720L, 28759386L, 49939598L, 4904952L}), new Ed25519.CachedXYT(new long[]{24059538L, 14617003L, 19037157L, 18514524L, 19766092L, 18648003L, 5169210L, 16191880L, 2128236L, 29227599L}, new long[]{50127693L, 4124965L, 58568254L, 22900634L, 30336521L, 19449185L, 37302527L, 916032L, 60226322L, 30567899L}, new long[]{44477957L, 12419371L, 59974635L, 26081060L, 50629959L, 0xFF6B66L, 285431L, 2763829L, 15736322L, 4143876L}), new Ed25519.CachedXYT(new long[]{2379333L, 11839345L, 62998462L, 27565766L, 11274297L, 794957L, 212801L, 18959769L, 23527083L, 17096164L}, new long[]{33431108L, 22423954L, 49269897L, 17927531L, 8909498L, 8376530L, 34483524L, 4087880L, 51919953L, 19138217L}, new long[]{1767664L, 7197987L, 53903638L, 31531796L, 54017513L, 448825L, 5799055L, 4357868L, 62334673L, 17231393L})}, {new Ed25519.CachedXYT(new long[]{6721966L, 13833823L, 43585476L, 32003117L, 26354292L, 21691111L, 23365146L, 29604700L, 7390889L, 2759800L}, new long[]{4409022L, 2052381L, 23373853L, 10530217L, 7676779L, 20668478L, 21302352L, 29290375L, 1244379L, 20634787L}, new long[]{62687625L, 7169618L, 4982368L, 30596842L, 30256824L, 30776892L, 14086412L, 9208236L, 15886429L, 16489664L}), new Ed25519.CachedXYT(new long[]{1996056L, 10375649L, 14346367L, 13311202L, 60234729L, 17116020L, 53415665L, 398368L, 36502409L, 32841498L}, new long[]{41801399L, 9795879L, 64331450L, 14878808L, 33577029L, 14780362L, 13348553L, 12076947L, 36272402L, 5113181L}, new long[]{49338080L, 11797795L, 31950843L, 13929123L, 41220562L, 12288343L, 36767763L, 26218045L, 13847710L, 5387222L}), new Ed25519.CachedXYT(new long[]{48526701L, 30138214L, 17824842L, 31213466L, 22744342L, 23111821L, 8763060L, 3617786L, 47508202L, 10370990L}, new long[]{20246567L, 19185054L, 22358228L, 33010720L, 18507282L, 23140436L, 14554436L, 24808340L, 32232923L, 16763880L}, new long[]{0x933966L, 10094563L, 26416693L, 14745928L, 36734546L, 27081810L, 11094160L, 15689506L, 3140038L, 17044340L}), new Ed25519.CachedXYT(new long[]{50948792L, 5472694L, 31895588L, 4744994L, 8823515L, 10365685L, 39884064L, 9448612L, 38334410L, 366294L}, new long[]{19153450L, 11523972L, 56012374L, 27051289L, 42461232L, 5420646L, 28344573L, 8041113L, 719605L, 11671788L}, new long[]{8678006L, 2694440L, 60300850L, 2517371L, 4964326L, 11152271L, 51675948L, 18287915L, 27000812L, 23358879L}), new Ed25519.CachedXYT(new long[]{51950941L, 7134311L, 8639287L, 30739555L, 59873175L, 10421741L, 564065L, 5336097L, 6750977L, 19033406L}, new long[]{11836410L, 29574944L, 26297893L, 0xF55F9FL, 23455045L, 15735944L, 1695823L, 24735310L, 8169719L, 16220347L}, new long[]{48993007L, 8653646L, 17578566L, 27461813L, 59083086L, 17541668L, 55964556L, 30926767L, 61118155L, 19388398L}), new Ed25519.CachedXYT(new long[]{43800366L, 22586119L, 15213227L, 23473218L, 36255258L, 22504427L, 27884328L, 2847284L, 2655861L, 1738395L}, new long[]{39571412L, 19301410L, 41772562L, 25551651L, 57738101L, 8129820L, 21651608L, 30315096L, 48021414L, 22549153L}, new long[]{1533110L, 3437855L, 23735889L, 459276L, 29970501L, 11335377L, 26030092L, 5821408L, 10478196L, 8544890L}), new Ed25519.CachedXYT(new long[]{32173102L, 17425121L, 24896206L, 3921497L, 22579056L, 30143578L, 19270448L, 12217473L, 17789017L, 30158437L}, new long[]{36555903L, 31326030L, 51530034L, 23407230L, 13243888L, 517024L, 15479401L, 29701199L, 30460519L, 1052596L}, new long[]{55493970L, 13323617L, 32618793L, 8175907L, 51878691L, 12596686L, 27491595L, 28942073L, 0x308303L, 24075541L}), new Ed25519.CachedXYT(new long[]{31947050L, 19187781L, 62468280L, 18214510L, 51982886L, 27514722L, 52352086L, 17142691L, 19072639L, 24043372L}, new long[]{11685058L, 11822410L, 3158003L, 19601838L, 33402193L, 29389366L, 5977895L, 28339415L, 473098L, 5040608L}, new long[]{46817982L, 8198641L, 39698732L, 11602122L, 1290375L, 30754672L, 28326861L, 1721092L, 47550222L, 30422825L})}, {new Ed25519.CachedXYT(new long[]{7881532L, 10687937L, 7578723L, 7738378L, 48157852L, 31000479L, 21820785L, 8076149L, 39240368L, 11538388L}, new long[]{47173198L, 3899860L, 18283497L, 26752864L, 51380203L, 22305220L, 8754524L, 7446702L, 61432810L, 5797015L}, new long[]{55813245L, 29760862L, 51326753L, 25589858L, 12708868L, 25098233L, 2014098L, 24503858L, 64739691L, 27677090L}), new Ed25519.CachedXYT(new long[]{44636488L, 21985690L, 39426843L, 1146374L, 18956691L, 16640559L, 1192730L, 29840233L, 15123618L, 10811505L}, new long[]{14352079L, 30134717L, 48166819L, 10822654L, 32750596L, 4699007L, 67038501L, 15776355L, 38222085L, 21579878L}, new long[]{38867681L, 25481956L, 62129901L, 28239114L, 29416930L, 0x1C3111L, 46454691L, 17069576L, 4714546L, 23953777L}), new Ed25519.CachedXYT(new long[]{15200332L, 8368572L, 19679101L, 15970074L, 35236190L, 1959450L, 24611599L, 29010600L, 55362987L, 12340219L}, new long[]{12876937L, 23074376L, 33134380L, 6590940L, 60801088L, 14872439L, 9613953L, 8241152L, 15370987L, 9608631L}, new long[]{62965568L, 21540023L, 8446280L, 33162829L, 4407737L, 13629032L, 59383996L, 15866073L, 38898243L, 24740332L}), new Ed25519.CachedXYT(new long[]{26660628L, 17876777L, 8393733L, 358047L, 59707573L, 992987L, 43204631L, 858696L, 20571223L, 8420556L}, new long[]{14620696L, 13067227L, 51661590L, 8264466L, 14106269L, 15080814L, 33531827L, 12516406L, 45534429L, 21077682L}, new long[]{236881L, 10476226L, 57258L, 18877408L, 6472997L, 2466984L, 17258519L, 7256740L, 8791136L, 15069930L}), new Ed25519.CachedXYT(new long[]{1276391L, 24182514L, 22949634L, 17231625L, 43615824L, 27852245L, 14711874L, 4874229L, 36445724L, 31223040L}, new long[]{5855666L, 4990204L, 53397016L, 7294283L, 59304582L, 1924646L, 65685689L, 25642053L, 34039526L, 9234252L}, new long[]{20590503L, 24535444L, 31529743L, 26201766L, 64402029L, 10650547L, 31559055L, 21944845L, 18979185L, 13396066L}), new Ed25519.CachedXYT(new long[]{24474287L, 4968103L, 22267082L, 4407354L, 24063882L, 25229252L, 48291976L, 13594781L, 33514650L, 7021958L}, new long[]{55541958L, 26988926L, 45743778L, 15928891L, 40950559L, 4315420L, 41160136L, 29637754L, 45628383L, 12868081L}, new long[]{38473832L, 13504660L, 19988037L, 31421671L, 21078224L, 6443208L, 45662757L, 2244499L, 54653067L, 25465048L}), new Ed25519.CachedXYT(new long[]{36513336L, 13793478L, 61256044L, 319135L, 41385692L, 27290532L, 33086545L, 8957937L, 51875216L, 5540520L}, new long[]{55478669L, 22050529L, 58989363L, 25911358L, 2620055L, 1022908L, 43398120L, 31985447L, 50980335L, 18591624L}, new long[]{23152952L, 775386L, 27395463L, 14006635L, 57407746L, 4649511L, 1689819L, 892185L, 55595587L, 18348483L}), new Ed25519.CachedXYT(new long[]{9770129L, 9586738L, 26496094L, 4324120L, 1556511L, 30004408L, 27453818L, 4763127L, 47929250L, 5867133L}, new long[]{34343820L, 1927589L, 31726409L, 28801137L, 23962433L, 17534932L, 27846558L, 5931263L, 37359161L, 17445976L}, new long[]{27461885L, 30576896L, 22380809L, 1815854L, 44075111L, 30522493L, 7283489L, 18406359L, 47582163L, 7734628L})}, {new Ed25519.CachedXYT(new long[]{59098600L, 23963614L, 55988460L, 6196037L, 29344158L, 20123547L, 7585294L, 30377806L, 18549496L, 15302069L}, new long[]{34450527L, 27383209L, 59436070L, 22502750L, 6258877L, 13504381L, 10458790L, 27135971L, 58236621L, 8424745L}, new long[]{24687186L, 8613276L, 36441818L, 30320886L, 1863891L, 31723888L, 19206233L, 7134917L, 55824382L, 32725512L}), new Ed25519.CachedXYT(new long[]{11334899L, 24336410L, 8025292L, 12707519L, 17523892L, 23078361L, 10243737L, 18868971L, 62042829L, 16498836L}, new long[]{8911542L, 6887158L, 57524604L, 26595841L, 0xAA11A8L, 24010752L, 17303924L, 19430194L, 6536640L, 10543906L}, new long[]{38162480L, 15479762L, 49642029L, 568875L, 65611181L, 11223453L, 64439674L, 16928857L, 39873154L, 8876770L}), new Ed25519.CachedXYT(new long[]{41365946L, 20987567L, 0x3113351L, 32707824L, 34082177L, 32758143L, 33627041L, 15824473L, 66504438L, 24514614L}, new long[]{10330056L, 70051L, 7957388L, 24551765L, 9764901L, 15609756L, 27698697L, 28664395L, 1657393L, 3084098L}, new long[]{10477963L, 26084172L, 12119565L, 20303627L, 29016246L, 28188843L, 31280318L, 14396151L, 36875289L, 15272408L}), new Ed25519.CachedXYT(new long[]{54820555L, 3169462L, 28813183L, 16658753L, 25116432L, 27923966L, 41934906L, 20918293L, 42094106L, 1950503L}, new long[]{40928506L, 9489186L, 11053416L, 18808271L, 36055143L, 5825629L, 58724558L, 24786899L, 15341278L, 8373727L}, new long[]{28685821L, 7759505L, 52730348L, 21551571L, 35137043L, 4079241L, 298136L, 23321830L, 64230656L, 15190419L}), new Ed25519.CachedXYT(new long[]{34175969L, 13806335L, 52771379L, 17760000L, 43104243L, 10940927L, 8669718L, 2742393L, 41075551L, 26679428L}, new long[]{65528476L, 21825014L, 41129205L, 22109408L, 49696989L, 22641577L, 9291593L, 17306653L, 54954121L, 6048604L}, new long[]{36803549L, 14843443L, 1539301L, 11864366L, 20201677L, 1900163L, 13934231L, 5128323L, 11213262L, 9168384L}), new Ed25519.CachedXYT(new long[]{40828332L, 11007846L, 19408960L, 32613674L, 48515898L, 29225851L, 62020803L, 22449281L, 20470156L, 17155731L}, new long[]{43972811L, 9282191L, 14855179L, 18164354L, 59746048L, 19145871L, 44324911L, 14461607L, 14042978L, 5230683L}, new long[]{29969548L, 30812838L, 50396996L, 25001989L, 9175485L, 31085458L, 21556950L, 3506042L, 61174973L, 21104723L}), new Ed25519.CachedXYT(new long[]{63964118L, 8744660L, 19704003L, 4581278L, 46678178L, 6830682L, 45824694L, 8971512L, 38569675L, 15326562L}, new long[]{47644235L, 10110287L, 49846336L, 30050539L, 43608476L, 1355668L, 51585814L, 15300987L, 46594746L, 9168259L}, new long[]{61755510L, 4488612L, 43305616L, 16314346L, 7780487L, 17915493L, 38160505L, 9601604L, 33087103L, 24543045L}), new Ed25519.CachedXYT(new long[]{47665694L, 18041531L, 46311396L, 21109108L, 37284416L, 10229460L, 39664535L, 18553900L, 61111993L, 15664671L}, new long[]{23294591L, 16921819L, 44458082L, 25083453L, 27844203L, 11461195L, 13099750L, 31094076L, 18151675L, 13417686L}, new long[]{42385932L, 29377914L, 35958184L, 5988918L, 40250079L, 6685064L, 1661597L, 21002991L, 15271675L, 18101767L})}, {new Ed25519.CachedXYT(new long[]{11433023L, 20325767L, 8239630L, 28274915L, 65123427L, 32828713L, 48410099L, 2167543L, 60187563L, 20114249L}, new long[]{35672693L, 15575145L, 30436815L, 12192228L, 44645511L, 9395378L, 57191156L, 24915434L, 12215109L, 12028277L}, new long[]{14098381L, 6555944L, 23007258L, 5757252L, 51681032L, 20603929L, 30123439L, 4617780L, 50208775L, 32898803L}), new Ed25519.CachedXYT(new long[]{63082644L, 0x117717CL, 11893167L, 13718664L, 52299402L, 1847384L, 51288865L, 10154008L, 23973261L, 20869958L}, new long[]{40577025L, 29858441L, 65199965L, 2534300L, 35238307L, 17004076L, 18341389L, 22134481L, 32013173L, 23450893L}, new long[]{41629544L, 10876442L, 55337778L, 18929291L, 54739296L, 1838103L, 21911214L, 6354752L, 4425632L, 32716610L}), new Ed25519.CachedXYT(new long[]{56675475L, 18941465L, 22229857L, 30463385L, 53917697L, 776728L, 49693489L, 21533969L, 4725004L, 14044970L}, new long[]{19268631L, 26250011L, 1555348L, 8692754L, 45634805L, 23643767L, 6347389L, 32142648L, 47586572L, 17444675L}, new long[]{42244775L, 12986007L, 56209986L, 27995847L, 55796492L, 33405905L, 19541417L, 8180106L, 9282262L, 10282508L}), new Ed25519.CachedXYT(new long[]{40903763L, 4428546L, 58447668L, 20360168L, 4098401L, 19389175L, 15522534L, 0x7FBFF7L, 5542595L, 22851749L}, new long[]{56546323L, 14895632L, 26814552L, 16880582L, 49628109L, 31065071L, 64326972L, 6993760L, 49014979L, 10114654L}, new long[]{47001790L, 32625013L, 31422703L, 10427861L, 59998115L, 6150668L, 38017109L, 22025285L, 25953724L, 33448274L}), new Ed25519.CachedXYT(new long[]{62874467L, 25515139L, 57989738L, 3045999L, 2101609L, 20947138L, 19390019L, 6094296L, 63793585L, 12831124L}, new long[]{51110167L, 7578151L, 5310217L, 14408357L, 33560244L, 33329692L, 31575953L, 6326196L, 7381791L, 31132593L}, new long[]{46206085L, 3296810L, 24736065L, 17226043L, 18374253L, 7318640L, 6295303L, 8082724L, 51746375L, 12339663L}), new Ed25519.CachedXYT(new long[]{27724736L, 2291157L, 6088201L, 19369634L, 1792726L, 5857634L, 13848414L, 15768922L, 25091167L, 14856294L}, new long[]{48242193L, 8331042L, 24373479L, 8541013L, 66406866L, 24284974L, 12927299L, 20858939L, 44926390L, 24541532L}, new long[]{55685435L, 28132841L, 11632844L, 3405020L, 30536730L, 21880393L, 39848098L, 13866389L, 30146206L, 9142070L}), new Ed25519.CachedXYT(new long[]{3924129L, 18246916L, 53291741L, 23499471L, 0xBB8EEBL, 32886066L, 39406089L, 9326383L, 58871006L, 4171293L}, new long[]{51186905L, 16037936L, 6713787L, 16606682L, 45496729L, 2790943L, 26396185L, 3731949L, 345228L, 28091483L}, new long[]{45781307L, 13448258L, 25284571L, 1143661L, 20614966L, 24705045L, 2031538L, 21163201L, 50855680L, 19972348L}), new Ed25519.CachedXYT(new long[]{31016192L, 16832003L, 26371391L, 19103199L, 62081514L, 14854136L, 17477601L, 3842657L, 28012650L, 17149012L}, new long[]{62033029L, 9368965L, 58546785L, 28953529L, 51858910L, 6970559L, 57918991L, 16292056L, 58241707L, 3507939L}, new long[]{29439664L, 3537914L, 23333589L, 6997794L, 49553303L, 22536363L, 51899661L, 18503164L, 57943934L, 6580395L})}, {new Ed25519.CachedXYT(new long[]{54923003L, 25874643L, 16438268L, 10826160L, 58412047L, 27318820L, 17860443L, 24280586L, 65013061L, 9304566L}, new long[]{20714545L, 29217521L, 29088194L, 7406487L, 11426967L, 28458727L, 14792666L, 0x1211717L, 5289420L, 33077305L}, new long[]{50443312L, 22903641L, 60948518L, 20248671L, 9192019L, 31751970L, 17271489L, 12349094L, 26939669L, 29802138L}), new Ed25519.CachedXYT(new long[]{54218966L, 9373457L, 31595848L, 16374215L, 21471720L, 13221525L, 39825369L, 21205872L, 63410057L, 117886L}, new long[]{22263325L, 26994382L, 3984569L, 22379786L, 51994855L, 32987646L, 28311252L, 5358056L, 43789084L, 541963L}, new long[]{16259200L, 3261970L, 2309254L, 18019958L, 50223152L, 28972515L, 24134069L, 16848603L, 53771797L, 20002236L}), new Ed25519.CachedXYT(new long[]{9378160L, 20414246L, 44262881L, 20809167L, 28198280L, 26310334L, 64709179L, 32837080L, 690425L, 14876244L}, new long[]{24977353L, 33240048L, 58884894L, 20089345L, 28432342L, 32378079L, 54040059L, 21257083L, 44727879L, 6618998L}, new long[]{65570671L, 11685645L, 12944378L, 13682314L, 42719353L, 19141238L, 8044828L, 19737104L, 32239828L, 27901670L}), new Ed25519.CachedXYT(new long[]{48505798L, 4762989L, 66182614L, 8885303L, 38696384L, 30367116L, 9781646L, 23204373L, 32779358L, 5095274L}, new long[]{34100715L, 28339925L, 34843976L, 29869215L, 9460460L, 24227009L, 42507207L, 14506723L, 21639561L, 30924196L}, new long[]{50707921L, 20442216L, 25239337L, 15531969L, 3987758L, 29055114L, 65819361L, 26690896L, 17874573L, 558605L}), new Ed25519.CachedXYT(new long[]{53508735L, 10240080L, 9171883L, 16131053L, 46239610L, 9599699L, 33499487L, 5080151L, 2085892L, 5119761L}, new long[]{44903700L, 31034903L, 50727262L, 414690L, 42089314L, 2170429L, 30634760L, 25190818L, 35108870L, 27794547L}, new long[]{60263160L, 15791201L, 8550074L, 32241778L, 29928808L, 21462176L, 27534429L, 26362287L, 44757485L, 12961481L}), new Ed25519.CachedXYT(new long[]{42616785L, 23983660L, 10368193L, 11582341L, 43711571L, 31309144L, 16533929L, 8206996L, 0x2334424L, 28394793L}, new long[]{55987368L, 30172197L, 0x233525L, 6362031L, 66973409L, 8868176L, 50273234L, 7031274L, 7589640L, 8945490L}, new long[]{34956097L, 8917966L, 6661220L, 21876816L, 65916803L, 17761038L, 7251488L, 22372252L, 24099108L, 19098262L}), new Ed25519.CachedXYT(new long[]{5019539L, 25646962L, 4244126L, 18840076L, 40175591L, 6453164L, 47990682L, 20265406L, 60876967L, 23273695L}, new long[]{10853575L, 10721687L, 26480089L, 5861829L, 44113045L, 1972174L, 65242217L, 22996533L, 63745412L, 27113307L}, new long[]{50106456L, 5906789L, 221599L, 26991285L, 7828207L, 20305514L, 24362660L, 31546264L, 53242455L, 7421391L}), new Ed25519.CachedXYT(new long[]{8139908L, 27007935L, 32257645L, 27663886L, 30375718L, 1886181L, 45933756L, 15441251L, 28826358L, 29431403L}, new long[]{6267067L, 9695052L, 7709135L, 16950835L, 34239795L, 31668296L, 14795159L, 25714308L, 13746020L, 31812384L}, new long[]{28584883L, 7787108L, 60375922L, 18503702L, 22846040L, 25983196L, 63926927L, 33190907L, 4771361L, 25134474L})}, {new Ed25519.CachedXYT(new long[]{24949256L, 6376279L, 39642383L, 25379823L, 48462709L, 23623825L, 33543568L, 21412737L, 3569626L, 11342593L}, new long[]{26514970L, 4740088L, 27912651L, 3697550L, 19331575L, 22082093L, 6809885L, 4608608L, 7325975L, 18753361L}, new long[]{55490446L, 19000001L, 42787651L, 7655127L, 65739590L, 5214311L, 39708324L, 10258389L, 49462170L, 25367739L}), new Ed25519.CachedXYT(new long[]{11431185L, 15823007L, 26570245L, 14329124L, 18029990L, 4796082L, 35662685L, 15580663L, 9280358L, 29580745L}, new long[]{66948081L, 23228174L, 44253547L, 29249434L, 46247496L, 19933429L, 34297962L, 22372809L, 51563772L, 4387440L}, new long[]{46309467L, 12194511L, 3937617L, 27748540L, 39954043L, 9340369L, 42594872L, 8548136L, 20617071L, 26072431L}), new Ed25519.CachedXYT(new long[]{66170039L, 29623845L, 58394552L, 16124717L, 24603125L, 27329039L, 53333511L, 21678609L, 24345682L, 10325460L}, new long[]{47253587L, 31985546L, 44906155L, 8714033L, 14007766L, 6928528L, 16318175L, 32543743L, 4766742L, 3552007L}, new long[]{45357481L, 16823515L, 1351762L, 32751011L, 63099193L, 3950934L, 3217514L, 14481909L, 10988822L, 29559670L}), new Ed25519.CachedXYT(new long[]{15564307L, 19242862L, 3101242L, 5684148L, 30446780L, 25503076L, 12677126L, 27049089L, 58813011L, 13296004L}, new long[]{57666574L, 6624295L, 36809900L, 21640754L, 62437882L, 31497052L, 31521203L, 9614054L, 37108040L, 12074673L}, new long[]{4771172L, 33419193L, 14290748L, 20464580L, 27992297L, 14998318L, 65694928L, 31997715L, 29832612L, 17163397L}), new Ed25519.CachedXYT(new long[]{7064884L, 26013258L, 47946901L, 28486894L, 48217594L, 30641695L, 25825241L, 5293297L, 39986204L, 13101589L}, new long[]{64810282L, 2439669L, 59642254L, 1719964L, 39841323L, 17225986L, 32512468L, 28236839L, 36752793L, 29363474L}, new long[]{37102324L, 10162315L, 33928688L, 3981722L, 50626726L, 20484387L, 14413973L, 9515896L, 19568978L, 9628812L}), new Ed25519.CachedXYT(new long[]{33053803L, 199357L, 15894591L, 1583059L, 27380243L, 28973997L, 49269969L, 27447592L, 60817077L, 3437739L}, new long[]{48129987L, 3884492L, 19469877L, 12726490L, 15913552L, 13614290L, 44147131L, 70103L, 7463304L, 4176122L}, new long[]{39984863L, 10659916L, 11482427L, 17484051L, 12771466L, 26919315L, 34389459L, 28231680L, 24216881L, 5944158L}), new Ed25519.CachedXYT(new long[]{8894125L, 7450974L, 64444715L, 23788679L, 39028346L, 21165316L, 19345745L, 14680796L, 11632993L, 5847885L}, new long[]{26942781L, 31239115L, 9129563L, 28647825L, 26024104L, 11769399L, 55590027L, 6367193L, 57381634L, 4782139L}, new long[]{19916442L, 28726022L, 44198159L, 22140040L, 25606323L, 27581991L, 33253852L, 8220911L, 6358847L, 31680575L}), new Ed25519.CachedXYT(new long[]{801428L, 31472730L, 16569427L, 11065167L, 29875704L, 96627L, 7908388L, 29073952L, 53570360L, 1387154L}, new long[]{19646058L, 5720633L, 55692158L, 12814208L, 11607948L, 12749789L, 14147075L, 15156355L, 45242033L, 11835259L}, new long[]{19299512L, 1155910L, 28703737L, 14890794L, 2925026L, 7269399L, 26121523L, 15467869L, 40548314L, 5052482L})}, {new Ed25519.CachedXYT(new long[]{64091413L, 0x9979DDL, 1980837L, 3964243L, 22160966L, 12322533L, 60677741L, 20936246L, 12228556L, 26550755L}, new long[]{32944382L, 14922211L, 44263970L, 5188527L, 21913450L, 24834489L, 4001464L, 13238564L, 60994061L, 8653814L}, new long[]{22865569L, 28901697L, 27603667L, 21009037L, 14348957L, 8234005L, 24808405L, 5719875L, 28483275L, 2841751L}), new Ed25519.CachedXYT(new long[]{50687877L, 32441126L, 66781144L, 21446575L, 21886281L, 18001658L, 65220897L, 33238773L, 19932057L, 20815229L}, new long[]{55452759L, 10087520L, 58243976L, 28018288L, 47830290L, 30498519L, 3999227L, 13239134L, 62331395L, 19644223L}, new long[]{1382174L, 21859713L, 17266789L, 9194690L, 53784508L, 9720080L, 20403944L, 11284705L, 53095046L, 3093229L}), new Ed25519.CachedXYT(new long[]{16650902L, 22516500L, 66044685L, 1570628L, 58779118L, 7352752L, 66806440L, 16271224L, 43059443L, 26862581L}, new long[]{45197768L, 27626490L, 62497547L, 27994275L, 35364760L, 22769138L, 24123613L, 15193618L, 45456747L, 16815042L}, new long[]{57172930L, 29264984L, 41829040L, 4372841L, 2087473L, 10399484L, 31870908L, 14690798L, 17361620L, 11864968L}), new Ed25519.CachedXYT(new long[]{55801235L, 6210371L, 13206574L, 5806320L, 38091172L, 19587231L, 54777658L, 26067830L, 41530403L, 17313742L}, new long[]{14668443L, 21284197L, 26039038L, 15305210L, 25515617L, 4542480L, 10453892L, 6577524L, 9145645L, 27110552L}, new long[]{5974855L, 3053895L, 57675815L, 23169240L, 35243739L, 3225008L, 59136222L, 3936127L, 61456591L, 30504127L}), new Ed25519.CachedXYT(new long[]{30625386L, 28825032L, 41552902L, 20761565L, 46624288L, 7695098L, 17097188L, 17250936L, 39109084L, 1803631L}, new long[]{63555773L, 9865098L, 61880298L, 4272700L, 61435032L, 16864731L, 14911343L, 12196514L, 45703375L, 7047411L}, new long[]{20093258L, 9920966L, 55970670L, 28210574L, 13161586L, 12044805L, 34252013L, 4124600L, 34765036L, 23296865L}), new Ed25519.CachedXYT(new long[]{46320040L, 14084653L, 53577151L, 7842146L, 19119038L, 19731827L, 4752376L, 24839792L, 45429205L, 2288037L}, new long[]{40289628L, 30270716L, 29965058L, 3039786L, 52635099L, 2540456L, 29457502L, 14625692L, 42289247L, 12570231L}, new long[]{66045306L, 22002608L, 16920317L, 12494842L, 1278292L, 27685323L, 45948920L, 30055751L, 55134159L, 4724942L}), new Ed25519.CachedXYT(new long[]{17960970L, 21778898L, 62967895L, 23851901L, 58232301L, 32143814L, 54201480L, 24894499L, 37532563L, 1903855L}, new long[]{23134274L, 19275300L, 56426866L, 31942495L, 20684484L, 15770816L, 54119114L, 3190295L, 26955097L, 14109738L}, new long[]{15308788L, 5320727L, 36995055L, 19235554L, 22902007L, 7767164L, 29425325L, 22276870L, 31960941L, 11934971L}), new Ed25519.CachedXYT(new long[]{39713153L, 8435795L, 4109644L, 12222639L, 42480996L, 14818668L, 20638173L, 4875028L, 10491392L, 1379718L}, new long[]{53949449L, 9197840L, 3875503L, 24618324L, 65725151L, 27674630L, 33518458L, 16176658L, 21432314L, 12180697L}, new long[]{55321537L, 11500837L, 13787581L, 19721842L, 44678184L, 10140204L, 1465425L, 12689540L, 56807545L, 19681548L})}, {new Ed25519.CachedXYT(new long[]{5414091L, 18168391L, 46101199L, 9643569L, 12834970L, 1186149L, 64485948L, 32212200L, 26128230L, 6032912L}, new long[]{40771450L, 19788269L, 32496024L, 19900513L, 17847800L, 20885276L, 3604024L, 0x7EE7DEL, 41233830L, 23117073L}, new long[]{3296484L, 6223048L, 24680646L, 21307972L, 44056843L, 5903204L, 58246567L, 28915267L, 12376616L, 3188849L}), new Ed25519.CachedXYT(new long[]{29190469L, 18895386L, 27549112L, 32370916L, 3520065L, 22857131L, 32049514L, 26245319L, 50999629L, 23702124L}, new long[]{52364359L, 24245275L, 735817L, 32955454L, 46701176L, 28496527L, 25246077L, 17758763L, 18640740L, 32593455L}, new long[]{60180029L, 17123636L, 10361373L, 5642961L, 4910474L, 12345252L, 35470478L, 33060001L, 10530746L, 1053335L}), new Ed25519.CachedXYT(new long[]{37842897L, 19367626L, 53570647L, 21437058L, 47651804L, 22899047L, 35646494L, 30605446L, 24018830L, 15026644L}, new long[]{44516310L, 30409154L, 64819587L, 5953842L, 53668675L, 9425630L, 25310643L, 13003497L, 64794073L, 18408815L}, new long[]{39688860L, 32951110L, 59064879L, 31885314L, 41016598L, 13987818L, 39811242L, 187898L, 43942445L, 31022696L}), new Ed25519.CachedXYT(new long[]{45364466L, 19743956L, 1844839L, 5021428L, 56674465L, 17642958L, 9716666L, 16266922L, 62038647L, 726098L}, new long[]{29370903L, 27500434L, 7334070L, 18212173L, 9385286L, 2247707L, 53446902L, 28714970L, 30007387L, 17731091L}, new long[]{66172485L, 16086690L, 23751945L, 33011114L, 65941325L, 28365395L, 9137108L, 730663L, 9835848L, 4555336L}), new Ed25519.CachedXYT(new long[]{43732429L, 1410445L, 44855111L, 20654817L, 30867634L, 15826977L, 17693930L, 544696L, 55123566L, 12422645L}, new long[]{31117226L, 21338698L, 53606025L, 6561946L, 57231997L, 20796761L, 61990178L, 29457725L, 29120152L, 13924425L}, new long[]{49707966L, 19321222L, 19675798L, 30819676L, 56101901L, 27695611L, 57724924L, 22236731L, 7240930L, 33317044L}), new Ed25519.CachedXYT(new long[]{35747106L, 22207651L, 52101416L, 27698213L, 44655523L, 21401660L, 1222335L, 4389483L, 3293637L, 18002689L}, new long[]{50424044L, 19110186L, 11038543L, 11054958L, 53307689L, 30215898L, 42789283L, 7733546L, 12796905L, 27218610L}, new long[]{58349431L, 22736595L, 41689999L, 10783768L, 36493307L, 23807620L, 38855524L, 3647835L, 3222231L, 22393970L}), new Ed25519.CachedXYT(new long[]{18606113L, 1693100L, 41660478L, 18384159L, 4112352L, 10045021L, 23603893L, 31506198L, 59558087L, 2484984L}, new long[]{9255298L, 30423235L, 54952701L, 32550175L, 13098012L, 24339566L, 16377219L, 31451620L, 47306788L, 0x1D1B1B1L}, new long[]{44379556L, 7496159L, 61366665L, 11329248L, 19991973L, 30206930L, 35390715L, 9936965L, 37011176L, 22935634L}), new Ed25519.CachedXYT(new long[]{21878571L, 28553135L, 4338335L, 13643897L, 64071999L, 13160959L, 19708896L, 5415497L, 59748361L, 29445138L}, new long[]{27736842L, 10103576L, 12500508L, 8502413L, 63695848L, 23920873L, 10436917L, 32004156L, 43449720L, 25422331L}, new long[]{19492550L, 21450067L, 37426887L, 32701801L, 63900692L, 12403436L, 30066266L, 8367329L, 13243957L, 8709688L})}, {new Ed25519.CachedXYT(new long[]{12015105L, 2801261L, 28198131L, 10151021L, 24818120L, 28811299L, 55914672L, 27908697L, 5150967L, 7274186L}, new long[]{2831347L, 21062286L, 1478974L, 6122054L, 23825128L, 20820846L, 31097298L, 6083058L, 31021603L, 23760822L}, new long[]{64578913L, 31324785L, 445612L, 10720828L, 53259337L, 22048494L, 43601132L, 16354464L, 15067285L, 19406725L}), new Ed25519.CachedXYT(new long[]{7840923L, 14037873L, 33744001L, 0xF3223FL, 66380651L, 29911725L, 21403987L, 1057586L, 47729402L, 21151211L}, new long[]{915865L, 17085158L, 15608284L, 24765302L, 42751837L, 6060029L, 49737545L, 8410996L, 59888403L, 16527024L}, new long[]{32922597L, 32997445L, 20336073L, 17369864L, 10903704L, 28169945L, 16957573L, 52992L, 23834301L, 6588044L}), new Ed25519.CachedXYT(new long[]{32752011L, 0xAB66B6L, 3381995L, 24839566L, 22652987L, 22810329L, 17159698L, 16689107L, 46794284L, 32248439L}, new long[]{62419196L, 9166775L, 41398568L, 22707125L, 11576751L, 12733943L, 7924251L, 30802151L, 1976122L, 26305405L}, new long[]{21251203L, 16309901L, 64125849L, 26771309L, 30810596L, 12967303L, 156041L, 30183180L, 12331344L, 25317235L}), new Ed25519.CachedXYT(new long[]{8651595L, 29077400L, 51023227L, 28557437L, 13002506L, 2950805L, 29054427L, 28447462L, 10008135L, 28886531L}, new long[]{31486061L, 15114593L, 52847614L, 12951353L, 14369431L, 26166587L, 16347320L, 19892343L, 8684154L, 23021480L}, new long[]{19443825L, 11385320L, 24468943L, 23895364L, 43189605L, 2187568L, 40845657L, 27467510L, 31316347L, 14219878L}), new Ed25519.CachedXYT(new long[]{38514374L, 1193784L, 32245219L, 11392485L, 31092169L, 15722801L, 27146014L, 6992409L, 29126555L, 9207390L}, new long[]{32382916L, 1110093L, 18477781L, 11028262L, 39697101L, 26006320L, 62128346L, 10843781L, 59151264L, 19118701L}, new long[]{2814918L, 7836403L, 27519878L, 25686276L, 46214848L, 22000742L, 45614304L, 8550129L, 28346258L, 1994730L}), new Ed25519.CachedXYT(new long[]{47530565L, 8085544L, 53108345L, 29605809L, 2785837L, 17323125L, 47591912L, 7174893L, 22628102L, 8115180L}, new long[]{36703732L, 955510L, 55975026L, 18476362L, 34661776L, 20276352L, 41457285L, 3317159L, 57165847L, 930271L}, new long[]{51805164L, 26720662L, 28856489L, 1357446L, 23421993L, 1057177L, 24091212L, 32165462L, 44343487L, 22903716L}), new Ed25519.CachedXYT(new long[]{44357633L, 28250434L, 54201256L, 20785565L, 51297352L, 25757378L, 52269845L, 17000211L, 65241845L, 8398969L}, new long[]{35139535L, 0x202422L, 62372504L, 1362500L, 12813763L, 16200670L, 22981545L, 27263159L, 18009407L, 17781660L}, new long[]{49887941L, 24009210L, 39324209L, 14166834L, 29815394L, 7444469L, 29551787L, 29827013L, 19288548L, 1325865L}), new Ed25519.CachedXYT(new long[]{15100138L, 17718680L, 43184885L, 32549333L, 40658671L, 15509407L, 12376730L, 30075286L, 33166106L, 25511682L}, new long[]{20909212L, 13023121L, 57899112L, 16251777L, 61330449L, 25459517L, 12412150L, 10018715L, 2213263L, 19676059L}, new long[]{32529814L, 22479743L, 30361438L, 16864679L, 57972923L, 1513225L, 22922121L, 6382134L, 61341936L, 8371347L})}, {new Ed25519.CachedXYT(new long[]{9923462L, 11271500L, 12616794L, 3544722L, 37110496L, 31832805L, 12891686L, 25361300L, 40665920L, 10486143L}, new long[]{44511638L, 26541766L, 8587002L, 25296571L, 4084308L, 20584370L, 361725L, 2610596L, 43187334L, 22099236L}, new long[]{5408392L, 32417741L, 62139741L, 10561667L, 24145918L, 14240566L, 31319731L, 29318891L, 19985174L, 30118346L}), new Ed25519.CachedXYT(new long[]{53114407L, 16616820L, 14549246L, 3341099L, 32155958L, 13648976L, 49531796L, 8849296L, 65030L, 8370684L}, new long[]{58787919L, 21504805L, 31204562L, 5839400L, 46481576L, 32497154L, 47665921L, 6922163L, 12743482L, 23753914L}, new long[]{64747493L, 12678784L, 28815050L, 4759974L, 43215817L, 4884716L, 23783145L, 11038569L, 18800704L, 255233L}), new Ed25519.CachedXYT(new long[]{61839187L, 31780545L, 13957885L, 7990715L, 23132995L, 728773L, 13393847L, 9066957L, 19258688L, 18800639L}, new long[]{64172210L, 22726896L, 56676774L, 14516792L, 63468078L, 4372540L, 35173943L, 2209389L, 65584811L, 2055793L}, new long[]{580882L, 16705327L, 5468415L, 30871414L, 36182444L, 18858431L, 59905517L, 24560042L, 37087844L, 7394434L}), new Ed25519.CachedXYT(new long[]{23838809L, 1822728L, 51370421L, 15242726L, 8318092L, 29821328L, 45436683L, 30062226L, 62287122L, 14799920L}, new long[]{13345610L, 9759151L, 3371034L, 17416641L, 16353038L, 8577942L, 31129804L, 13496856L, 58052846L, 7402517L}, new long[]{2286874L, 29118501L, 47066405L, 31546095L, 53412636L, 5038121L, 11006906L, 17794080L, 8205060L, 1607563L}), new Ed25519.CachedXYT(new long[]{14414067L, 25552300L, 3331829L, 30346215L, 22249150L, 27960244L, 18364660L, 30647474L, 30019586L, 24525154L}, new long[]{39420813L, 1585952L, 56333811L, 931068L, 37988643L, 22552112L, 52698034L, 12029092L, 9944378L, 8024L}, new long[]{4368715L, 29844802L, 29874199L, 18531449L, 46878477L, 22143727L, 50994269L, 32555346L, 58966475L, 5640029L}), new Ed25519.CachedXYT(new long[]{10299591L, 13746483L, 11661824L, 16234854L, 7630238L, 5998374L, 9809887L, 16859868L, 15219797L, 19226649L}, new long[]{27425505L, 27835351L, 3055005L, 10660664L, 23458024L, 595578L, 51710259L, 32381236L, 48766680L, 9742716L}, new long[]{6744077L, 2427284L, 26042789L, 2720740L, 66260958L, 1118973L, 32324614L, 7406442L, 12420155L, 1994844L}), new Ed25519.CachedXYT(new long[]{14012502L, 28529712L, 48724410L, 23975962L, 40623521L, 29617992L, 54075385L, 22644628L, 24319928L, 27108099L}, new long[]{0xFA6FFFL, 29047065L, 10772640L, 15929391L, 50040076L, 28895810L, 10555944L, 23070383L, 37006495L, 28815383L}, new long[]{22397363L, 25786748L, 57815702L, 20761563L, 17166286L, 23799296L, 39775798L, 6199365L, 21880021L, 21303672L}), new Ed25519.CachedXYT(new long[]{62825557L, 5368522L, 35991846L, 8163388L, 36785801L, 3209127L, 16557151L, 8890729L, 8840445L, 4957760L}, new long[]{51661137L, 709326L, 60189418L, 22684253L, 37330941L, 6522331L, 45388683L, 12130071L, 52312361L, 5005756L}, new long[]{64994094L, 19246303L, 23019041L, 15765735L, 41839181L, 6002751L, 10183197L, 20315106L, 50713577L, 31378319L})}, {new Ed25519.CachedXYT(new long[]{48083108L, 1632004L, 13466291L, 25559332L, 43468412L, 16573536L, 35094956L, 30497327L, 22208661L, 2000468L}, new long[]{3065054L, 32141671L, 41510189L, 33192999L, 49425798L, 27851016L, 58944651L, 11248526L, 63417650L, 26140247L}, new long[]{10379208L, 27508878L, 8877318L, 1473647L, 37817580L, 21046851L, 16690914L, 2553332L, 63976176L, 16400288L}), new Ed25519.CachedXYT(new long[]{15716668L, 1254266L, 48636174L, 7446273L, 58659946L, 6344163L, 45011593L, 26268851L, 26894936L, 9132066L}, new long[]{24158868L, 12938817L, 11085297L, 25376834L, 39045385L, 29097348L, 36532400L, 64451L, 60291780L, 30861549L}, new long[]{13488534L, 7794716L, 22236231L, 5989356L, 25426474L, 20976224L, 2350709L, 30135921L, 62420857L, 2364225L}), new Ed25519.CachedXYT(new long[]{16335033L, 9132434L, 25640582L, 6678888L, 1725628L, 8517937L, 55301840L, 21856974L, 15445874L, 25756331L}, new long[]{29004188L, 25687351L, 28661401L, 32914020L, 54314860L, 25611345L, 31863254L, 29418892L, 66830813L, 17795152L}, new long[]{60986784L, 18687766L, 38493958L, 14569918L, 56250865L, 29962602L, 10343411L, 26578142L, 37280576L, 22738620L}), new Ed25519.CachedXYT(new long[]{27081650L, 3463984L, 14099042L, 0x1BB111CL, 1616302L, 27348828L, 29542635L, 15372179L, 17293797L, 960709L}, new long[]{20263915L, 11434237L, 61343429L, 11236809L, 13505955L, 22697330L, 50997518L, 6493121L, 47724353L, 7639713L}, new long[]{64278047L, 18715199L, 25403037L, 25339236L, 58791851L, 17380732L, 18006286L, 17510682L, 29994676L, 17746311L}), new Ed25519.CachedXYT(new long[]{9769828L, 5202651L, 42951466L, 19923039L, 39057860L, 21992807L, 42495722L, 19693649L, 35924288L, 709463L}, new long[]{0xBB79BBL, 13076066L, 45333675L, 32377809L, 42105665L, 4057651L, 35090736L, 24663557L, 16102006L, 13205847L}, new long[]{13733362L, 5599946L, 10557076L, 3195751L, 61550873L, 8536969L, 41568694L, 8525971L, 10151379L, 10394400L}), new Ed25519.CachedXYT(new long[]{4024660L, 17416881L, 22436261L, 12276534L, 58009849L, 30868332L, 19698228L, 11743039L, 33806530L, 8934413L}, new long[]{51229064L, 29029191L, 58528116L, 30620370L, 14634844L, 32856154L, 57659786L, 3137093L, 55571978L, 11721157L}, new long[]{17555920L, 28540494L, 8268605L, 2331751L, 44370049L, 9761012L, 9319229L, 8835153L, 57903375L, 32274386L}), new Ed25519.CachedXYT(new long[]{66647436L, 25724417L, 20614117L, 16688288L, 59594098L, 28747312L, 22300303L, 505429L, 6108462L, 27371017L}, new long[]{62038564L, 12367916L, 36445330L, 3234472L, 32617080L, 25131790L, 29880582L, 20071101L, 40210373L, 25686972L}, new long[]{35133562L, 5726538L, 26934134L, 10237677L, 63935147L, 32949378L, 24199303L, 3795095L, 7592688L, 18562353L}), new Ed25519.CachedXYT(new long[]{21594432L, 18590204L, 17466407L, 29477210L, 32537083L, 2739898L, 6407723L, 12018833L, 38852812L, 4298411L}, new long[]{46458361L, 21592935L, 39872588L, 570497L, 3767144L, 31836892L, 13891941L, 31985238L, 13717173L, 10805743L}, new long[]{52432215L, 17910135L, 15287173L, 11927123L, 24177847L, 25378864L, 66312432L, 14860608L, 40169934L, 27690595L})}, {new Ed25519.CachedXYT(new long[]{12962541L, 5311799L, 57048096L, 11658279L, 18855286L, 25600231L, 13286262L, 20745728L, 62727807L, 9882021L}, new long[]{18512060L, 11319350L, 46985740L, 15090308L, 18818594L, 5271736L, 44380960L, 3666878L, 43141434L, 30255002L}, new long[]{60319844L, 30408388L, 16192428L, 13241070L, 15898607L, 19348318L, 57023983L, 26893321L, 64705764L, 5276064L}), new Ed25519.CachedXYT(new long[]{30169808L, 28236784L, 26306205L, 21803573L, 27814963L, 7069267L, 7152851L, 3684982L, 1449224L, 13082861L}, new long[]{10342807L, 3098505L, 2119311L, 193222L, 25702612L, 12233820L, 23697382L, 15056736L, 46092426L, 25352431L}, new long[]{33958735L, 3261607L, 22745853L, 7948688L, 19370557L, 18376767L, 40936887L, 6482813L, 56808784L, 22494330L}), new Ed25519.CachedXYT(new long[]{32869458L, 28145887L, 25609742L, 15678670L, 56421095L, 18083360L, 26112420L, 2521008L, 44444576L, 6904814L}, new long[]{29506904L, 4457497L, 3377935L, 23757988L, 36598817L, 12935079L, 1561737L, 3841096L, 38105225L, 26896789L}, new long[]{10340844L, 26924055L, 48452231L, 31276001L, 12621150L, 20215377L, 30878496L, 21730062L, 41524312L, 5181965L}), new Ed25519.CachedXYT(new long[]{25940096L, 20896407L, 17324187L, 23247058L, 58437395L, 15029093L, 24396252L, 17103510L, 64786011L, 21165857L}, new long[]{45343161L, 9916822L, 65808455L, 4079497L, 66080518L, 11909558L, 1782390L, 12641087L, 20603771L, 26992690L}, new long[]{48226577L, 21881051L, 24849421L, 11501709L, 13161720L, 28785558L, 1925522L, 11914390L, 4662781L, 7820689L}), new Ed25519.CachedXYT(new long[]{12241050L, 33128450L, 8132690L, 9393934L, 32846760L, 31954812L, 29749455L, 12172924L, 16136752L, 15264020L}, new long[]{56758909L, 18873868L, 58896884L, 2330219L, 49446315L, 19008651L, 10658212L, 6671822L, 19012087L, 3772772L}, new long[]{3753511L, 30133366L, 10617073L, 2028709L, 14841030L, 26832768L, 28718731L, 17791548L, 20527770L, 12988982L}), new Ed25519.CachedXYT(new long[]{52286360L, 27757162L, 63400876L, 12689772L, 66209881L, 22639565L, 42925817L, 22989488L, 3299664L, 21129479L}, new long[]{50331161L, 18301130L, 57466446L, 4978982L, 3308785L, 8755439L, 6943197L, 6461331L, 41525717L, 8991217L}, new long[]{49882601L, 1816361L, 65435576L, 27467992L, 31783887L, 25378441L, 34160718L, 7417949L, 36866577L, 1507264L}), new Ed25519.CachedXYT(new long[]{29692644L, 6829891L, 56610064L, 4334895L, 20945975L, 21647936L, 38221255L, 8209390L, 14606362L, 22907359L}, new long[]{63627275L, 8707080L, 32188102L, 5672294L, 22096700L, 1711240L, 34088169L, 9761486L, 4170404L, 31469107L}, new long[]{55521375L, 14855944L, 62981086L, 32022574L, 40459774L, 15084045L, 22186522L, 16002000L, 52832027L, 25153633L}), new Ed25519.CachedXYT(new long[]{62297408L, 13761028L, 35404987L, 31070512L, 63796392L, 7869046L, 59995292L, 23934339L, 0xCA0A0CL, 10965870L}, new long[]{59366301L, 25297669L, 52340529L, 19898171L, 43876480L, 12387165L, 4498947L, 14147411L, 29514390L, 4302863L}, new long[]{53695440L, 21146572L, 20757301L, 19752600L, 14785142L, 8976368L, 62047588L, 31410058L, 17846987L, 19582505L})}, {new Ed25519.CachedXYT(new long[]{64864412L, 32799703L, 62511833L, 32488122L, 60861691L, 1455298L, 45461136L, 24339642L, 61886162L, 12650266L}, new long[]{57202067L, 17484121L, 21134159L, 12198166L, 40044289L, 708125L, 387813L, 13770293L, 47974538L, 10958662L}, new long[]{22470984L, 12369526L, 23446014L, 28113323L, 45588061L, 23855708L, 55336367L, 21979976L, 42025033L, 4271861L}), new Ed25519.CachedXYT(new long[]{41939299L, 23500789L, 47199531L, 15361594L, 61124506L, 2159191L, 75375L, 29275903L, 34582642L, 8469672L}, new long[]{15854951L, 4148314L, 58214974L, 7259001L, 11666551L, 13824734L, 36577666L, 2697371L, 24154791L, 24093489L}, new long[]{15446137L, 17747788L, 29759746L, 14019369L, 30811221L, 23944241L, 35526855L, 12840103L, 24913809L, 9815020L}), new Ed25519.CachedXYT(new long[]{62399578L, 27940162L, 35267365L, 21265538L, 52665326L, 10799413L, 58005188L, 13438768L, 18735128L, 9466238L}, new long[]{11933045L, 9281483L, 5081055L, 28370608L, 64480701L, 28648802L, 59381042L, 22658328L, 44380208L, 16199063L}, new long[]{14576810L, 379472L, 40322331L, 25237195L, 37682355L, 22741457L, 67006097L, 1876698L, 30801119L, 2164795L}), new Ed25519.CachedXYT(new long[]{15995086L, 3199873L, 13672555L, 13712240L, 47730029L, 28906785L, 54027253L, 18058162L, 53616056L, 1268051L}, new long[]{56818250L, 29895392L, 63822271L, 10948817L, 23037027L, 3794475L, 63638526L, 20954210L, 50053494L, 3565903L}, new long[]{29210069L, 24135095L, 61189071L, 28601646L, 10834810L, 20226706L, 50596761L, 22733718L, 39946641L, 19523900L}), new Ed25519.CachedXYT(new long[]{53946955L, 15508587L, 16663704L, 25398282L, 38758921L, 9019122L, 37925443L, 29785008L, 2244110L, 19552453L}, new long[]{61955989L, 29753495L, 57802388L, 27482848L, 16243068L, 14684434L, 41435776L, 17373631L, 13491505L, 4641841L}, new long[]{10813398L, 643330L, 47920349L, 32825515L, 30292061L, 16954354L, 27548446L, 25833190L, 14476988L, 20787001L}), new Ed25519.CachedXYT(new long[]{10292079L, 9984945L, 6481436L, 8279905L, 59857350L, 7032742L, 27282937L, 31910173L, 39196053L, 12651323L}, new long[]{35923332L, 32741048L, 22271203L, 11835308L, 10201545L, 15351028L, 17099662L, 3988035L, 21721536L, 30405492L}, new long[]{10202177L, 27008593L, 35735631L, 23979793L, 34958221L, 25434748L, 54202543L, 3852693L, 13216206L, 14842320L}), new Ed25519.CachedXYT(new long[]{51293224L, 22953365L, 60569911L, 26295436L, 60124204L, 26972653L, 35608016L, 13765823L, 39674467L, 9900183L}, new long[]{14465486L, 19721101L, 34974879L, 18815558L, 39665676L, 12990491L, 33046193L, 15796406L, 60056998L, 25514317L}, new long[]{30924398L, 25274812L, 6359015L, 20738097L, 16508376L, 9071735L, 41620263L, 15413634L, 9524356L, 26535554L}), new Ed25519.CachedXYT(new long[]{12274201L, 20378885L, 32627640L, 31769106L, 6736624L, 13267305L, 5237659L, 28444949L, 15663515L, 4035784L}, new long[]{64157555L, 8903984L, 17349946L, 601635L, 50676049L, 28941875L, 53376124L, 17665097L, 44850385L, 4659090L}, new long[]{50192582L, 28601458L, 36715152L, 18395610L, 20774811L, 15897498L, 5736189L, 15026997L, 64930608L, 20098846L})}, {new Ed25519.CachedXYT(new long[]{58249865L, 31335375L, 28571665L, 23398914L, 66634396L, 23448733L, 63307367L, 278094L, 23440562L, 33264224L}, new long[]{10226222L, 27625730L, 15139955L, 120818L, 52241171L, 5218602L, 32937275L, 11551483L, 50536904L, 26111567L}, new long[]{17932739L, 21117156L, 43069306L, 10749059L, 11316803L, 7535897L, 22503767L, 5561594L, 63462240L, 3898660L}), new Ed25519.CachedXYT(new long[]{7749907L, 32584865L, 50769132L, 33537967L, 42090752L, 15122142L, 65535333L, 7152529L, 21831162L, 0x130031L}, new long[]{26958440L, 18896406L, 4314585L, 8346991L, 61431100L, 11960071L, 34519569L, 32934396L, 36706772L, 16838219L}, new long[]{54942968L, 9166946L, 33491384L, 13673479L, 29787085L, 13096535L, 6280834L, 14587357L, 44770839L, 13987524L}), new Ed25519.CachedXYT(new long[]{42758936L, 7778774L, 21116000L, 15572597L, 62275598L, 28196653L, 62807965L, 28429792L, 59639082L, 30696363L}, new long[]{9681908L, 26817309L, 35157219L, 13591837L, 60225043L, 386949L, 31622781L, 6439245L, 52527852L, 4091396L}, new long[]{58682418L, 1470726L, 38999185L, 31957441L, 3978626L, 28430809L, 47486180L, 12092162L, 29077877L, 18812444L}), new Ed25519.CachedXYT(new long[]{5269168L, 26694706L, 53878652L, 25533716L, 25932562L, 1763552L, 61502754L, 28048550L, 47091016L, 2357888L}, new long[]{32264008L, 18146780L, 61721128L, 32394338L, 65017541L, 29607531L, 23104803L, 20684524L, 5727337L, 189038L}, new long[]{14609104L, 24599962L, 61108297L, 16931650L, 52531476L, 25810533L, 40363694L, 10942114L, 41219933L, 18669734L}), new Ed25519.CachedXYT(new long[]{20513481L, 5557931L, 51504251L, 7829530L, 26413943L, 31535028L, 45729895L, 7471780L, 0xD44E4DL, 28416557L}, new long[]{41534488L, 11967825L, 29233242L, 12948236L, 60354399L, 4713226L, 58167894L, 14059179L, 12878652L, 8511905L}, new long[]{41452044L, 3393630L, 64153449L, 26478905L, 64858154L, 9366907L, 36885446L, 6812973L, 5568676L, 30426776L}), new Ed25519.CachedXYT(new long[]{11630004L, 12144454L, 2116339L, 13606037L, 27378885L, 15676917L, 49700111L, 20050058L, 52713667L, 8070817L}, new long[]{27117677L, 23547054L, 35826092L, 27984343L, 0x113371L, 12772488L, 37262958L, 0x9FF669L, 55556115L, 32525717L}, new long[]{10637467L, 27866368L, 5674780L, 1072708L, 40765276L, 26572129L, 65424888L, 9177852L, 39615702L, 15431202L}), new Ed25519.CachedXYT(new long[]{20525126L, 10892566L, 54366392L, 12779442L, 37615830L, 16150074L, 38868345L, 14943141L, 52052074L, 25618500L}, new long[]{37084402L, 5626925L, 66557297L, 23573344L, 753597L, 11981191L, 25244767L, 30314666L, 63752313L, 9594023L}, new long[]{43356201L, 2636869L, 61944954L, 23450613L, 585133L, 7877383L, 11345683L, 27062142L, 13352334L, 22577348L}), new Ed25519.CachedXYT(new long[]{65177046L, 28146973L, 3304648L, 20669563L, 17015805L, 28677341L, 37325013L, 25801949L, 53893326L, 33235227L}, new long[]{20239939L, 6607058L, 6203985L, 3483793L, 48721888L, 32775202L, 46385121L, 15077869L, 44358105L, 14523816L}, new long[]{27406023L, 27512775L, 27423595L, 29057038L, 4996213L, 10002360L, 38266833L, 29008937L, 36936121L, 28748764L})}, {new Ed25519.CachedXYT(new long[]{11374242L, 12660715L, 17861383L, 21013599L, 10935567L, 1099227L, 53222788L, 24462691L, 39381819L, 11358503L}, new long[]{54378055L, 10311866L, 1510375L, 10778093L, 64989409L, 24408729L, 32676002L, 11149336L, 40985213L, 4985767L}, new long[]{48012542L, 341146L, 60911379L, 33315398L, 15756972L, 24757770L, 66125820L, 13794113L, 47694557L, 17933176L}), new Ed25519.CachedXYT(new long[]{6490062L, 11940286L, 25495923L, 25828072L, 0x8444D4L, 24803116L, 3367602L, 6970005L, 65417799L, 24549641L}, new long[]{1656478L, 13457317L, 15370807L, 0x611EEEL, 13605745L, 8362338L, 47934242L, 28078708L, 50312267L, 28522993L}, new long[]{0x2AC22CAL, 20030007L, 67044178L, 29220208L, 48503227L, 22632463L, 46537798L, 0x1951115L, 67009010L, 23317098L}), new Ed25519.CachedXYT(new long[]{17747446L, 10039260L, 19368299L, 29503841L, 46478228L, 17513145L, 31992682L, 17696456L, 37848500L, 28042460L}, new long[]{31932008L, 28568291L, 47496481L, 16366579L, 22023614L, 88450L, 11371999L, 29810185L, 4882241L, 22927527L}, new long[]{29796488L, 37186L, 19818052L, 10115756L, 55279832L, 3352735L, 18551198L, 3272828L, 61917932L, 29392022L}), new Ed25519.CachedXYT(new long[]{12501267L, 4044383L, 58495907L, 20162046L, 34678811L, 5136598L, 47878486L, 30024734L, 330069L, 29895023L}, new long[]{6384877L, 2899513L, 17807477L, 7663917L, 64749976L, 12363164L, 25366522L, 24980540L, 66837568L, 12071498L}, new long[]{58743349L, 29511910L, 25133447L, 29037077L, 60897836L, 2265926L, 34339246L, 1936674L, 61949167L, 3829362L}), new Ed25519.CachedXYT(new long[]{0x1B1BEEEL, 27718999L, 66531773L, 28857233L, 52891308L, 6870929L, 7921550L, 26986645L, 26333139L, 14267664L}, new long[]{56041645L, 11871230L, 27385719L, 22994888L, 62522949L, 22365119L, 10004785L, 24844944L, 45347639L, 8930323L}, new long[]{45911060L, 17158396L, 25654215L, 31829035L, 12282011L, 11008919L, 1541940L, 4757911L, 40617363L, 17145491L}), new Ed25519.CachedXYT(new long[]{13537262L, 25794942L, 46504023L, 10961926L, 61186044L, 20336366L, 53952279L, 6217253L, 51165165L, 0xD2CCCDL}, new long[]{49686272L, 15157789L, 18705543L, 29619L, 24409717L, 33293956L, 27361680L, 9257833L, 65152338L, 31777517L}, new long[]{42063564L, 23362465L, 15366584L, 15166509L, 54003778L, 0x808883L, 37937324L, 12361134L, 48422886L, 4578289L}), new Ed25519.CachedXYT(new long[]{24579768L, 3711570L, 1342322L, 22374306L, 40103728L, 14124955L, 44564335L, 14074918L, 21964432L, 8235257L}, new long[]{60580251L, 31142934L, 9442965L, 27628844L, 12025639L, 32067012L, 64127349L, 31885225L, 13006805L, 2355433L}, new long[]{50803946L, 19949172L, 60476436L, 28412082L, 16974358L, 22643349L, 27202043L, 1719366L, 1141648L, 20758196L}), new Ed25519.CachedXYT(new long[]{54244920L, 20334445L, 58790597L, 22536340L, 60298718L, 28710537L, 13475065L, 30420460L, 32674894L, 13715045L}, new long[]{11423316L, 28086373L, 32344215L, 8962751L, 24989809L, 9241752L, 53843611L, 16086211L, 38367983L, 0x1115212L}, new long[]{65699196L, 12530727L, 60740138L, 10847386L, 19531186L, 19422272L, 55399715L, 7791793L, 39862921L, 4383346L})}, {new Ed25519.CachedXYT(new long[]{38137966L, 5271446L, 65842855L, 23817442L, 54653627L, 16732598L, 62246457L, 28647982L, 27193556L, 6245191L}, new long[]{51914908L, 5362277L, 65324971L, 0x292299L, 4960227L, 12840725L, 23061898L, 3260492L, 22510453L, 8577507L}, new long[]{54476394L, 11257345L, 34415870L, 13548176L, 66387860L, 10879010L, 31168030L, 13952092L, 37537372L, 29918525L}), new Ed25519.CachedXYT(new long[]{3877321L, 23981693L, 32416691L, 5405324L, 56104457L, 19897796L, 3759768L, 11935320L, 5611860L, 8164018L}, new long[]{50833043L, 14667796L, 15906460L, 0xB9799BL, 44997715L, 24514713L, 32003001L, 24722143L, 5773084L, 25132323L}, new long[]{43320746L, 25300131L, 1950874L, 8937633L, 18686727L, 16459170L, 66203139L, 12376319L, 31632953L, 190926L}), new Ed25519.CachedXYT(new long[]{42515238L, 17415546L, 58684872L, 13378745L, 14162407L, 6901328L, 58820115L, 4508563L, 41767309L, 29926903L}, new long[]{8884438L, 27670423L, 6023973L, 10104341L, 60227295L, 28612898L, 18722940L, 18768427L, 65436375L, 827624L}, new long[]{34388281L, 17265135L, 34605316L, 7101209L, 13354605L, 2659080L, 65308289L, 19446395L, 42230385L, 1541285L}), new Ed25519.CachedXYT(new long[]{2901328L, 32436745L, 3880375L, 23495044L, 49487923L, 29941650L, 45306746L, 29986950L, 20456844L, 31669399L}, new long[]{27019610L, 0xBBACCBL, 53450576L, 31951197L, 54247203L, 28692960L, 47568713L, 28538373L, 29439640L, 15138866L}, new long[]{21536104L, 26928012L, 34661045L, 22864223L, 44700786L, 5175813L, 61688824L, 17193268L, 7779327L, 109896L}), new Ed25519.CachedXYT(new long[]{30279725L, 14648750L, 59063993L, 6425557L, 13639621L, 32810923L, 28698389L, 12180118L, 23177719L, 33000357L}, new long[]{26572828L, 3405927L, 35407164L, 12890904L, 47843196L, 5335865L, 60615096L, 2378491L, 4439158L, 20275085L}, new long[]{44392139L, 3489069L, 57883598L, 33221678L, 18875721L, 32414337L, 14819433L, 20822905L, 49391106L, 28092994L}), new Ed25519.CachedXYT(new long[]{62052362L, 16566550L, 15953661L, 3767752L, 56672365L, 0xEE7333L, 66287910L, 2177224L, 8550082L, 18440267L}, new long[]{48635543L, 16596774L, 66727204L, 15663610L, 22860960L, 15585581L, 39264755L, 29971692L, 43848403L, 25125843L}, new long[]{34628313L, 15707274L, 58902952L, 27902350L, 29464557L, 2713815L, 44383727L, 15860481L, 45206294L, 1494192L}), new Ed25519.CachedXYT(new long[]{47546773L, 19467038L, 41524991L, 24254879L, 13127841L, 759709L, 21923482L, 16529112L, 8742704L, 12967017L}, new long[]{38643965L, 1553204L, 32536856L, 23080703L, 42417258L, 33148257L, 58194238L, 30620535L, 37205105L, 15553882L}, new long[]{21877890L, 3230008L, 9881174L, 10539357L, 62311749L, 2841331L, 11543572L, 14513274L, 19375923L, 20906471L}), new Ed25519.CachedXYT(new long[]{8832269L, 19058947L, 13253510L, 5137575L, 5037871L, 4078777L, 24880818L, 27331716L, 2862652L, 9455043L}, new long[]{29306751L, 5123106L, 20245049L, 19404543L, 9592565L, 8447059L, 65031740L, 30564351L, 15511448L, 4789663L}, new long[]{46429108L, 7004546L, 8824831L, 24119455L, 63063159L, 29803695L, 61354101L, 108892L, 23513200L, 16652362L})}, {new Ed25519.CachedXYT(new long[]{33852691L, 4144781L, 0x3BBB383L, 26975308L, 10770038L, 26398890L, 60458447L, 20618131L, 48789665L, 10212859L}, new long[]{2756062L, 8598110L, 7383731L, 26694540L, 22312758L, 32449420L, 21179800L, 2600940L, 57120566L, 21047965L}, new long[]{42463153L, 13317461L, 36659605L, 17900503L, 21365573L, 22684775L, 11344423L, 864440L, 64609187L, 16844368L}), new Ed25519.CachedXYT(new long[]{40676061L, 6148328L, 49924452L, 19080277L, 18782928L, 33278435L, 44547329L, 211299L, 2719757L, 4940997L}, new long[]{65784982L, 3911312L, 60160120L, 14759764L, 37081714L, 0x77CCC6L, 21690126L, 8518463L, 26699843L, 5276295L}, new long[]{53958991L, 27125364L, 9396248L, 365013L, 24703301L, 23065493L, 1321585L, 149635L, 51656090L, 7159368L}), new Ed25519.CachedXYT(new long[]{9987761L, 30149673L, 17507961L, 9505530L, 9731535L, 31388918L, 22356008L, 8312176L, 22477218L, 25151047L}, new long[]{18155857L, 17049442L, 19744715L, 9006923L, 15154154L, 23015456L, 24256459L, 28689437L, 44560690L, 9334108L}, new long[]{2986088L, 28642539L, 10776627L, 30080588L, 10620589L, 26471229L, 45695018L, 14253544L, 44521715L, 536905L}), new Ed25519.CachedXYT(new long[]{4377737L, 8115836L, 24567078L, 15495314L, 11625074L, 13064599L, 7390551L, 10589625L, 10838060L, 18134008L}, new long[]{47766460L, 867879L, 9277171L, 30335973L, 52677291L, 31567988L, 19295825L, 17757482L, 6378259L, 699185L}, new long[]{7895007L, 4057113L, 60027092L, 20476675L, 49222032L, 33231305L, 66392824L, 15693154L, 62063800L, 20180469L}), new Ed25519.CachedXYT(new long[]{59371282L, 27685029L, 52542544L, 26147512L, 11385653L, 13201616L, 31730678L, 22591592L, 63190227L, 23885106L}, new long[]{10188286L, 17783598L, 59772502L, 13427542L, 22223443L, 14896287L, 30743455L, 7116568L, 45322357L, 5427592L}, new long[]{696102L, 13206899L, 27047647L, 22922350L, 15285304L, 23701253L, 10798489L, 28975712L, 19236242L, 12477404L}), new Ed25519.CachedXYT(new long[]{55879425L, 11243795L, 50054594L, 25513566L, 66320635L, 25386464L, 63211194L, 11180503L, 43939348L, 7733643L}, new long[]{17800790L, 19518253L, 40108434L, 21787760L, 23887826L, 3149671L, 23466177L, 23016261L, 10322026L, 15313801L}, new long[]{26246234L, 11968874L, 32263343L, 28085704L, 6830754L, 20231401L, 51314159L, 33452449L, 42659621L, 10890803L}), new Ed25519.CachedXYT(new long[]{35743198L, 10271362L, 54448239L, 27287163L, 16690206L, 20491888L, 52126651L, 16484930L, 25180797L, 28219548L}, new long[]{66522290L, 10376443L, 34522450L, 22268075L, 19801892L, 10997610L, 2276632L, 9482883L, 316878L, 13820577L}, new long[]{57226037L, 29044064L, 64993357L, 16457135L, 56008783L, 11674995L, 30756178L, 26039378L, 30696929L, 29841583L}), new Ed25519.CachedXYT(new long[]{32988917L, 23951020L, 12499365L, 7910787L, 56491607L, 21622917L, 59766047L, 23569034L, 34759346L, 7392472L}, new long[]{58253184L, 15927860L, 9866406L, 29905021L, 64711949L, 16898650L, 36699387L, 24419436L, 25112946L, 30627788L}, new long[]{64604801L, 33117465L, 25621773L, 27875660L, 15085041L, 28074555L, 42223985L, 20028237L, 5537437L, 19640113L})}, {new Ed25519.CachedXYT(new long[]{55883280L, 2320284L, 57524584L, 10149186L, 33664201L, 5808647L, 52232613L, 31824764L, 31234589L, 6090599L}, new long[]{57475529L, 116425L, 26083934L, 2897444L, 60744427L, 30866345L, 609720L, 15878753L, 60138459L, 24519663L}, new long[]{39351007L, 247743L, 51914090L, 24551880L, 23288160L, 23542496L, 43239268L, 6503645L, 20650474L, 1804084L}), new Ed25519.CachedXYT(new long[]{39519059L, 15456423L, 0x88E8E5L, 8469608L, 15640622L, 4439847L, 3121995L, 23224719L, 27842615L, 33352104L}, new long[]{51801891L, 2839643L, 22530074L, 10026331L, 4602058L, 5048462L, 28248656L, 5031932L, 55733782L, 12714368L}, new long[]{20807691L, 26283607L, 29286140L, 11421711L, 39232341L, 19686201L, 45881388L, 1035545L, 47375635L, 12796919L}), new Ed25519.CachedXYT(new long[]{12076880L, 19253146L, 58323862L, 21705509L, 42096072L, 16400683L, 49517369L, 20654993L, 3480664L, 18371617L}, new long[]{34747315L, 5457596L, 28548107L, 7833186L, 7303070L, 21600887L, 42745799L, 17632556L, 33734809L, 2771024L}, new long[]{45719598L, 421931L, 26597266L, 6860826L, 22486084L, 26817260L, 49971378L, 29344205L, 42556581L, 15673396L}), new Ed25519.CachedXYT(new long[]{46924223L, 2338215L, 19788685L, 23933476L, 63107598L, 24813538L, 46837679L, 4733253L, 3727144L, 20619984L}, new long[]{6120100L, 814863L, 55314462L, 32931715L, 6812204L, 17806661L, 2019593L, 7975683L, 31123697L, 22595451L}, new long[]{30069250L, 22119100L, 30434653L, 2958439L, 18399564L, 32578143L, 12296868L, 9204260L, 50676426L, 9648164L}), new Ed25519.CachedXYT(new long[]{32705413L, 32003455L, 30705657L, 7451065L, 55303258L, 9631812L, 3305266L, 5248604L, 41100532L, 22176930L}, new long[]{17219846L, 2375039L, 35537917L, 27978816L, 47649184L, 9219902L, 294711L, 15298639L, 2662509L, 17257359L}, new long[]{65935918L, 25995736L, 62742093L, 29266687L, 45762450L, 25120105L, 32087528L, 32331655L, 32247247L, 19164571L}), new Ed25519.CachedXYT(new long[]{14312609L, 1221556L, 17395390L, 24854289L, 62163122L, 24869796L, 38911119L, 23916614L, 51081240L, 20175586L}, new long[]{65680039L, 23875441L, 57873182L, 6549686L, 59725795L, 33085767L, 23046501L, 9803137L, 17597934L, 2346211L}, new long[]{18510781L, 15337574L, 26171504L, 981392L, 44867312L, 7827555L, 43617730L, 22231079L, 3059832L, 21771562L}), new Ed25519.CachedXYT(new long[]{10141598L, 6082907L, 17829293L, 31606789L, 9830091L, 13613136L, 41552228L, 28009845L, 33606651L, 3592095L}, new long[]{33114149L, 17665080L, 40583177L, 20211034L, 33076704L, 8716171L, 1151462L, 1521897L, 66126199L, 26716628L}, new long[]{34169699L, 29298616L, 23947180L, 33230254L, 34035889L, 21248794L, 50471177L, 3891703L, 26353178L, 693168L}), new Ed25519.CachedXYT(new long[]{30374239L, 1595580L, 50224825L, 13186930L, 4600344L, 406904L, 9585294L, 33153764L, 31375463L, 14369965L}, new long[]{52738210L, 25781902L, 1510300L, 6434173L, 48324075L, 27291703L, 32732229L, 20445593L, 17901440L, 16011505L}, new long[]{18171223L, 21619806L, 54608461L, 15197121L, 56070717L, 18324396L, 47936623L, 17508055L, 8764034L, 12309598L})}, {new Ed25519.CachedXYT(new long[]{5975889L, 28311244L, 47649501L, 23872684L, 55567586L, 0xD5DD25L, 43443107L, 1228318L, 17544096L, 22960650L}, new long[]{5811932L, 31839139L, 3442886L, 31285122L, 48741515L, 25194890L, 49064820L, 18144304L, 61543482L, 12348899L}, new long[]{35709185L, 11407554L, 25755363L, 6891399L, 63851926L, 14872273L, 42259511L, 8141294L, 56476330L, 32968952L}), new Ed25519.CachedXYT(new long[]{54433560L, 694025L, 62032719L, 13300343L, 14015258L, 19103038L, 57410191L, 22225381L, 30944592L, 1130208L}, new long[]{8247747L, 26843490L, 40546482L, 25845122L, 52706924L, 18905521L, 4652151L, 2488540L, 23550156L, 33283200L}, new long[]{17294297L, 29765994L, 7026747L, 15626851L, 22990044L, 113481L, 2267737L, 27646286L, 66700045L, 33416712L}), new Ed25519.CachedXYT(new long[]{16091066L, 17300506L, 18599251L, 7340678L, 2137637L, 32332775L, 63744702L, 14550935L, 3260525L, 26388161L}, new long[]{62198760L, 20221544L, 18550886L, 10864893L, 50649539L, 26262835L, 44079994L, 20349526L, 54360141L, 2701325L}, new long[]{58534169L, 16099414L, 4629974L, 17213908L, 46322650L, 27548999L, 57090500L, 9276970L, 11329923L, 1862132L}), new Ed25519.CachedXYT(new long[]{14763057L, 17650824L, 36190593L, 3689866L, 3511892L, 10313526L, 45157776L, 12219230L, 58070901L, 32614131L}, new long[]{8894987L, 30108338L, 6150752L, 3013931L, 301220L, 15693451L, 35127648L, 30644714L, 51670695L, 11595569L}, new long[]{15214943L, 3537601L, 40870142L, 19495559L, 4418656L, 18323671L, 13947275L, 10730794L, 53619402L, 29190761L}), new Ed25519.CachedXYT(new long[]{64570558L, 7682792L, 32759013L, 263109L, 37124133L, 25598979L, 44776739L, 23365796L, 977107L, 699994L}, new long[]{54642373L, 4195083L, 57897332L, 550903L, 51543527L, 12917919L, 19118110L, 33114591L, 36574330L, 19216518L}, new long[]{31788442L, 19046775L, 4799988L, 7372237L, 0x866889L, 18806489L, 9408236L, 23502657L, 12493931L, 28145115L}), new Ed25519.CachedXYT(new long[]{41428258L, 5260743L, 47873055L, 27269961L, 63412921L, 16566086L, 27218280L, 2607121L, 29375955L, 6024730L}, new long[]{842132L, 30759739L, 62345482L, 24831616L, 26332017L, 21148791L, 11831879L, 6985184L, 57168503L, 2854095L}, new long[]{62261602L, 25585100L, 2516241L, 27706719L, 9695690L, 26333246L, 16512644L, 960770L, 12121869L, 16648078L}), new Ed25519.CachedXYT(new long[]{51890212L, 14667095L, 53772635L, 2013716L, 30598287L, 33090295L, 35603941L, 25672367L, 20237805L, 2838411L}, new long[]{47820798L, 4453151L, 15298546L, 17376044L, 22115042L, 17581828L, 12544293L, 20083975L, 1068880L, 21054527L}, new long[]{57549981L, 17035596L, 33238497L, 13506958L, 30505848L, 32439836L, 58621956L, 30924378L, 12521377L, 4845654L}), new Ed25519.CachedXYT(new long[]{38910324L, 10744107L, 64150484L, 10199663L, 7759311L, 20465832L, 3409347L, 32681032L, 60626557L, 20668561L}, new long[]{43547042L, 6230155L, 46726851L, 10655313L, 43068279L, 21933259L, 10477733L, 32314216L, 63995636L, 13974497L}, new long[]{12966261L, 15550616L, 35069916L, 31939085L, 21025979L, 32924988L, 5642324L, 7188737L, 18895762L, 12629579L})}, {new Ed25519.CachedXYT(new long[]{14741879L, 18607545L, 22177207L, 21833195L, 1279740L, 8058600L, 11758140L, 789443L, 32195181L, 3895677L}, new long[]{10758205L, 15755439L, 62598914L, 9243697L, 62229442L, 6879878L, 64904289L, 29988312L, 58126794L, 4429646L}, new long[]{64654951L, 15725972L, 46672522L, 23143759L, 61304955L, 22514211L, 59972993L, 21911536L, 18047435L, 18272689L}), new Ed25519.CachedXYT(new long[]{41935844L, 22247266L, 29759955L, 11776784L, 44846481L, 17733976L, 10993113L, 20703595L, 49488162L, 24145963L}, new long[]{21987233L, 700364L, 42603816L, 14972007L, 59334599L, 27836036L, 32155025L, 2581431L, 37149879L, 8773374L}, new long[]{41540495L, 454462L, 53896929L, 16126714L, 25240068L, 8594567L, 20656846L, 12017935L, 59234475L, 19634276L}), new Ed25519.CachedXYT(new long[]{6028163L, 6263078L, 0x226CC22L, 22252721L, 66289944L, 2461771L, 35267690L, 28086389L, 65387075L, 30777706L}, new long[]{54829870L, 16624276L, 987579L, 27631834L, 32908202L, 1248608L, 7719845L, 29387734L, 28408819L, 6816612L}, new long[]{56750770L, 25316602L, 19549650L, 21385210L, 22082622L, 16147817L, 20613181L, 13982702L, 56769294L, 5067942L}), new Ed25519.CachedXYT(new long[]{36602878L, 29732664L, 12074680L, 13582412L, 47230892L, 2443950L, 47389578L, 12746131L, 5331210L, 23448488L}, new long[]{30528792L, 3601899L, 65151774L, 4619784L, 39747042L, 18118043L, 24180792L, 20984038L, 27679907L, 31905504L}, new long[]{9402385L, 19597367L, 32834042L, 10838634L, 40528714L, 20317236L, 26653273L, 24868867L, 22611443L, 20839026L}), new Ed25519.CachedXYT(new long[]{22190590L, 1118029L, 22736441L, 15130463L, 36648172L, 27563110L, 19189624L, 28905490L, 0x4A144AL, 6622139L}, new long[]{58798126L, 30600981L, 58846284L, 30166382L, 56707132L, 33282502L, 13424425L, 29987205L, 26404408L, 13001963L}, new long[]{35867026L, 18138731L, 64114613L, 8939345L, 11562230L, 20713762L, 41044498L, 21932711L, 51703708L, 11020692L}), new Ed25519.CachedXYT(new long[]{1866042L, 25604943L, 59210214L, 23253421L, 12483314L, 13477547L, 3175636L, 21130269L, 28761761L, 1406734L}, new long[]{66660290L, 31776765L, 13018550L, 3194501L, 57528444L, 22392694L, 24760584L, 29207344L, 25577410L, 20175752L}, new long[]{42818486L, 4759344L, 66418211L, 31701615L, 2066746L, 10693769L, 37513074L, 9884935L, 57739938L, 4745409L}), new Ed25519.CachedXYT(new long[]{57967561L, 6049713L, 47577803L, 29213020L, 35848065L, 9944275L, 51646856L, 22242579L, 10931923L, 21622501L}, new long[]{50547351L, 14112679L, 59096219L, 4817317L, 59068400L, 22139825L, 44255434L, 10856640L, 46638094L, 13434653L}, new long[]{22759470L, 23480998L, 50342599L, 31683009L, 13637441L, 23386341L, 1765143L, 20900106L, 28445306L, 28189722L}), new Ed25519.CachedXYT(new long[]{29875063L, 12493613L, 2795536L, 29768102L, 0x1A1A1BL, 15181182L, 56913147L, 24765756L, 9074233L, 1167180L}, new long[]{40903181L, 11014232L, 57266213L, 30918946L, 40200743L, 7532293L, 48391976L, 24018933L, 3843902L, 9367684L}, new long[]{56139269L, 27150720L, 9591133L, 9582310L, 11349256L, 108879L, 16235123L, 8601684L, 66969667L, 4242894L})}, {new Ed25519.CachedXYT(new long[]{22092954L, 20363309L, 65066070L, 21585919L, 32186752L, 22037044L, 60534522L, 2470659L, 39691498L, 16625500L}, new long[]{56051142L, 3042015L, 13770083L, 24296510L, 584235L, 33009577L, 59338006L, 2602724L, 39757248L, 14247412L}, new long[]{6314156L, 23289540L, 34336361L, 15957556L, 56951134L, 168749L, 58490057L, 14290060L, 27108877L, 32373552L}), new Ed25519.CachedXYT(new long[]{58522267L, 26383465L, 13241781L, 10960156L, 34117849L, 19759835L, 33547975L, 22495543L, 39960412L, 981873L}, new long[]{22833421L, 9293594L, 34459416L, 19935764L, 57971897L, 14756818L, 0x2A22225L, 19583651L, 56629059L, 17356469L}, new long[]{59340277L, 3326785L, 38997067L, 10783823L, 19178761L, 14905060L, 22680049L, 13906969L, 51175174L, 3797898L}), new Ed25519.CachedXYT(new long[]{21721337L, 29341686L, 54902740L, 9310181L, 63226625L, 19901321L, 23740223L, 30845200L, 20491982L, 25512280L}, new long[]{9209251L, 18419377L, 53852306L, 27386633L, 66377847L, 15289672L, 25947805L, 15286587L, 30997318L, 26851369L}, new long[]{7392013L, 16618386L, 23946583L, 25514540L, 53843699L, 32020573L, 52911418L, 31232855L, 17649997L, 33304352L}), new Ed25519.CachedXYT(new long[]{57807776L, 19360604L, 30609525L, 30504889L, 41933794L, 32270679L, 51867297L, 24028707L, 64875610L, 7662145L}, new long[]{49550191L, 1763593L, 33994528L, 15908609L, 37067994L, 21380136L, 7335079L, 25082233L, 63934189L, 3440182L}, new long[]{47219164L, 27577423L, 42997570L, 23865561L, 10799742L, 16982475L, 40449L, 29122597L, 4862399L, 1133L}), new Ed25519.CachedXYT(new long[]{34252636L, 25680474L, 61686474L, 14860949L, 50789833L, 7956141L, 7258061L, 311861L, 36513873L, 26175010L}, new long[]{63335436L, 31988495L, 28985339L, 7499440L, 24445838L, 9325937L, 29727763L, 16527196L, 18278453L, 15405622L}, new long[]{62726958L, 8508651L, 47210498L, 29880007L, 61124410L, 15149969L, 53795266L, 843522L, 45233802L, 13626196L}), new Ed25519.CachedXYT(new long[]{2281448L, 20067377L, 56193445L, 30944521L, 1879357L, 16164207L, 56324982L, 3953791L, 13340839L, 15928663L}, new long[]{31727126L, 26374577L, 48671360L, 25270779L, 2875792L, 17164102L, 41838969L, 26539605L, 43656557L, 5964752L}, new long[]{4100401L, 27594980L, 49929526L, 6017713L, 48403027L, 12227140L, 40424029L, 11344143L, 2538215L, 25983677L}), new Ed25519.CachedXYT(new long[]{57675240L, 6123112L, 11159803L, 31397824L, 30016279L, 14966241L, 46633881L, 1485420L, 66479608L, 17595569L}, new long[]{40304287L, 4260918L, 11851389L, 9658551L, 35091757L, 16367491L, 46903439L, 20363143L, 11659921L, 22439314L}, new long[]{26180377L, 10015009L, 36264640L, 24973138L, 5418196L, 9480663L, 2231568L, 23384352L, 33100371L, 32248261L}), new Ed25519.CachedXYT(new long[]{15121094L, 28352561L, 56718958L, 15427820L, 39598927L, 17561924L, 21670946L, 4486675L, 61177054L, 19088051L}, new long[]{16166467L, 24070699L, 56004733L, 6023907L, 35182066L, 32189508L, 2340059L, 17299464L, 56373093L, 23514607L}, new long[]{28042865L, 29997343L, 54982337L, 12259705L, 63391366L, 26608532L, 6766452L, 24864833L, 18036435L, 5803270L})}, {new Ed25519.CachedXYT(new long[]{66291264L, 6763911L, 11803561L, 1585585L, 10958447L, 30883267L, 23855390L, 4598332L, 60949433L, 19436993L}, new long[]{36077558L, 19298237L, 17332028L, 31170912L, 31312681L, 27587249L, 696308L, 50292L, 47013125L, 11763583L}, new long[]{66514282L, 31040148L, 34874710L, 12643979L, 12650761L, 14811489L, 665117L, 20940800L, 47335652L, 22840869L}), new Ed25519.CachedXYT(new long[]{30464590L, 22291560L, 62981387L, 20819953L, 19835326L, 26448819L, 42712688L, 2075772L, 50088707L, 992470L}, new long[]{18357166L, 26559999L, 7766381L, 16342475L, 37783946L, 411173L, 14578841L, 8080033L, 55534529L, 22952821L}, new long[]{19598397L, 10334610L, 12555054L, 2555664L, 18821899L, 23214652L, 21873262L, 16014234L, 26224780L, 16452269L}), new Ed25519.CachedXYT(new long[]{36884939L, 5145195L, 5944548L, 16385966L, 3976735L, 2009897L, 55731060L, 25936245L, 46575034L, 3698649L}, new long[]{14187449L, 3448569L, 56472628L, 22743496L, 44444983L, 30120835L, 7268409L, 22663988L, 27394300L, 12015369L}, new long[]{19695742L, 16087646L, 28032085L, 12999827L, 0x680800L, 11427614L, 20244189L, 32241655L, 53849736L, 30151970L}), new Ed25519.CachedXYT(new long[]{30860084L, 12735208L, 65220619L, 28854697L, 50133957L, 2256939L, 58942851L, 12298311L, 58558340L, 23160969L}, new long[]{61389038L, 22309106L, 65198214L, 15569034L, 26642876L, 25966672L, 61319509L, 18435777L, 62132699L, 12651792L}, new long[]{64260450L, 9953420L, 11531313L, 28271553L, 26895122L, 20857343L, 53990043L, 17036529L, 9768697L, 31021214L}), new Ed25519.CachedXYT(new long[]{42389405L, 1894650L, 66821166L, 28850346L, 0xEA33EEL, 25397902L, 32767512L, 12765450L, 4940095L, 10678226L}, new long[]{18860224L, 15980149L, 48121624L, 31991861L, 40875851L, 22482575L, 59264981L, 13944023L, 42736516L, 16582018L}, new long[]{51604604L, 4970267L, 37215820L, 4175592L, 46115652L, 31354675L, 55404809L, 15444559L, 56105103L, 7989036L}), new Ed25519.CachedXYT(new long[]{31490433L, 5568061L, 64696061L, 2182382L, 34772017L, 4531685L, 35030595L, 6200205L, 47422751L, 18754260L}, new long[]{49800177L, 17674491L, 35586086L, 33551600L, 34221481L, 16375548L, 8680158L, 17182719L, 28550067L, 26697300L}, new long[]{38981977L, 27866340L, 16837844L, 31733974L, 60258182L, 12700015L, 37068883L, 4364037L, 0x11A212L, 5988841L}), new Ed25519.CachedXYT(new long[]{21890435L, 20281525L, 54484852L, 12154348L, 59276991L, 15300495L, 23148983L, 29083951L, 24618406L, 8283181L}, new long[]{33972757L, 23041680L, 9975415L, 6841041L, 35549071L, 16356535L, 3070187L, 26528504L, 1466168L, 10740210L}, new long[]{65599446L, 18066246L, 53605478L, 22898515L, 32799043L, 909394L, 53169961L, 27774712L, 34944214L, 18227391L}), new Ed25519.CachedXYT(new long[]{3960804L, 19286629L, 39082773L, 17636380L, 47704005L, 13146867L, 15567327L, 951507L, 63848543L, 32980496L}, new long[]{24740822L, 5052253L, 37014733L, 8961360L, 25877428L, 6165135L, 42740684L, 14397371L, 59728495L, 27410326L}, new long[]{38220480L, 3510802L, 39005586L, 32395953L, 55870735L, 22922977L, 51667400L, 19101303L, 65483377L, 27059617L})}, {new Ed25519.CachedXYT(new long[]{793280L, 24323954L, 8836301L, 27318725L, 39747955L, 31184838L, 33152842L, 28669181L, 57202663L, 32932579L}, new long[]{5666214L, 525582L, 20782575L, 25516013L, 42570364L, 14657739L, 16099374L, 1468826L, 60937436L, 18367850L}, new long[]{62249590L, 29775088L, 64191105L, 26806412L, 7778749L, 11688288L, 36704511L, 23683193L, 65549940L, 23690785L}), new Ed25519.CachedXYT(new long[]{10896313L, 25834728L, 824274L, 472601L, 47648556L, 3009586L, 25248958L, 14783338L, 36527388L, 17796587L}, new long[]{10566929L, 12612572L, 35164652L, 11118702L, 54475488L, 12362878L, 21752402L, 8822496L, 24003793L, 14264025L}, new long[]{27713843L, 26198459L, 56100623L, 9227529L, 27050101L, 2504721L, 23886875L, 20436907L, 13958494L, 27821979L}), new Ed25519.CachedXYT(new long[]{43627235L, 0x4A4499L, 39861736L, 3900520L, 29838369L, 25342141L, 35219464L, 23512650L, 7340520L, 18144364L}, new long[]{4646495L, 25543308L, 44342840L, 22021777L, 23184552L, 8566613L, 31366726L, 32173371L, 52042079L, 23179239L}, new long[]{49838347L, 12723031L, 50115803L, 14878793L, 21619651L, 27356856L, 27584816L, 3093888L, 58265170L, 3849920L}), new Ed25519.CachedXYT(new long[]{58043933L, 2103171L, 25561640L, 18428694L, 61869039L, 9582957L, 32477045L, 24536477L, 5002293L, 18004173L}, new long[]{55051311L, 22376525L, 21115584L, 20189277L, 8808711L, 21523724L, 16489529L, 13378448L, 41263148L, 12741425L}, new long[]{61162478L, 10645102L, 36197278L, 15390283L, 63821882L, 26435754L, 24306471L, 15852464L, 28834118L, 25908360L}), new Ed25519.CachedXYT(new long[]{49773116L, 24447374L, 42577584L, 9434952L, 58636780L, 32971069L, 54018092L, 455840L, 20461858L, 5491305L}, new long[]{13669229L, 17458950L, 54626889L, 23351392L, 52539093L, 21661233L, 42112877L, 11293806L, 38520660L, 24132599L}, new long[]{28497909L, 6272777L, 34085870L, 14470569L, 8906179L, 32328802L, 18504673L, 19389266L, 29867744L, 24758489L}), new Ed25519.CachedXYT(new long[]{50901822L, 13517195L, 39309234L, 19856633L, 24009063L, 27180541L, 60741263L, 20379039L, 22853428L, 29542421L}, new long[]{24191359L, 16712145L, 53177067L, 15217830L, 14542237L, 1646131L, 18603514L, 22516545L, 12876622L, 31441985L}, new long[]{17902668L, 4518229L, 66697162L, 30725184L, 26878216L, 5258055L, 54248111L, 608396L, 16031844L, 3723494L}), new Ed25519.CachedXYT(new long[]{38476072L, 12763727L, 46662418L, 7577503L, 33001348L, 20536687L, 17558841L, 25681542L, 23896953L, 29240187L}, new long[]{47103464L, 21542479L, 31520463L, 605201L, 2543521L, 5991821L, 64163800L, 7229063L, 57189218L, 24727572L}, new long[]{28816026L, 298879L, 38943848L, 17633493L, 19000927L, 31888542L, 54428030L, 30605106L, 49057085L, 31471516L}), new Ed25519.CachedXYT(new long[]{16000882L, 33209536L, 3493091L, 22107234L, 37604268L, 20394642L, 12577739L, 16041268L, 47393624L, 7847706L}, new long[]{10151868L, 10572098L, 27312476L, 7922682L, 14825339L, 4723128L, 34252933L, 27035413L, 57088296L, 3852847L}, new long[]{55678375L, 15697595L, 45987307L, 29133784L, 5386313L, 15063598L, 0xFBFDBDL, 17622322L, 29330898L, 18478208L})}, {new Ed25519.CachedXYT(new long[]{41609129L, 29175637L, 51885955L, 26653220L, 16615730L, 2051784L, 3303702L, 15490L, 39560068L, 12314390L}, new long[]{15683501L, 27551389L, 18109119L, 23573784L, 15337967L, 27556609L, 50391428L, 15921865L, 16103996L, 29823217L}, new long[]{43939021L, 22773182L, 13588191L, 31925625L, 63310306L, 32479502L, 47835256L, 5402698L, 37293151L, 23713330L}), new Ed25519.CachedXYT(new long[]{23190676L, 2384583L, 34394524L, 3462153L, 37205209L, 32025299L, 55842007L, 8911516L, 41903005L, 2739712L}, new long[]{21374101L, 30000182L, 33584214L, 9874410L, 15377179L, 11831242L, 33578960L, 6134906L, 4931255L, 11987849L}, new long[]{67101132L, 30575573L, 50885377L, 7277596L, 105524L, 33232381L, 35628324L, 13861387L, 37032554L, 10117929L}), new Ed25519.CachedXYT(new long[]{37607694L, 22809559L, 40945095L, 13051538L, 41483300L, 5089642L, 60783361L, 6704078L, 12890019L, 15728940L}, new long[]{45136504L, 21783052L, 66157804L, 29135591L, 14704839L, 2695116L, 903376L, 23126293L, 12885166L, 8311031L}, new long[]{49592363L, 5352193L, 10384213L, 19742774L, 7506450L, 13453191L, 26423267L, 4384730L, 1888765L, 28119028L}), new Ed25519.CachedXYT(new long[]{41291507L, 30447119L, 53614264L, 30371925L, 30896458L, 19632703L, 34857219L, 20846562L, 47644429L, 30214188L}, new long[]{43500868L, 30888657L, 66582772L, 4651135L, 5765089L, 4618330L, 6092245L, 14845197L, 17151279L, 23700316L}, new long[]{42278406L, 20820711L, 51942885L, 10367249L, 37577956L, 33289075L, 22825804L, 26467153L, 50242379L, 16176524L}), new Ed25519.CachedXYT(new long[]{43525589L, 6564960L, 20063689L, 3798228L, 62368686L, 7359224L, 2006182L, 23191006L, 38362610L, 23356922L}, new long[]{56482264L, 29068029L, 53788301L, 28429114L, 3432135L, 27161203L, 23632036L, 31613822L, 32808309L, 1099883L}, new long[]{0xE55AAEL, 5768825L, 39657628L, 30667132L, 60681485L, 18193060L, 51830967L, 26745081L, 2051440L, 18328567L}), new Ed25519.CachedXYT(new long[]{63746541L, 26315059L, 7517889L, 9824992L, 23555850L, 295369L, 0x4E8EEEL, 19400244L, 44422509L, 16633659L}, new long[]{4577067L, 0x1006160L, 13249840L, 18250104L, 19958762L, 19017158L, 18559669L, 22794883L, 8402477L, 23690159L}, new long[]{38702534L, 32502850L, 40318708L, 32646733L, 49896449L, 22523642L, 9453450L, 18574360L, 0x1126621L, 9967138L}), new Ed25519.CachedXYT(new long[]{41346370L, 6524721L, 26585488L, 9969270L, 24709298L, 1220360L, 65430874L, 7806336L, 17507396L, 3651560L}, new long[]{56688388L, 29436320L, 14584638L, 15971087L, 51340543L, 8861009L, 26556809L, 27979875L, 48555541L, 22197296L}, new long[]{2839082L, 14284142L, 4029895L, 3472686L, 14402957L, 12689363L, 40466743L, 8459446L, 61503401L, 25932490L}), new Ed25519.CachedXYT(new long[]{62269556L, 30018987L, 9744960L, 2871048L, 25113978L, 3187018L, 41998051L, 32705365L, 17258083L, 25576693L}, new long[]{18164541L, 22959256L, 49953981L, 32012014L, 19237077L, 23809137L, 23357532L, 18337424L, 26908269L, 12150756L}, new long[]{36843994L, 25906566L, 5112248L, 26517760L, 65609056L, 26580174L, 43167L, 28016731L, 34806789L, 16215818L})}, {new Ed25519.CachedXYT(new long[]{60209940L, 9824393L, 54804085L, 29153342L, 35711722L, 27277596L, 32574488L, 12532905L, 59605792L, 24879084L}, new long[]{39765323L, 17038963L, 39957339L, 22831480L, 946345L, 16291093L, 254968L, 7168080L, 21676107L, 31611404L}, new long[]{21260942L, 25129680L, 50276977L, 21633609L, 43430902L, 3968120L, 63456915L, 27338965L, 63552672L, 25641356L}), new Ed25519.CachedXYT(new long[]{16544735L, 13250366L, 50304436L, 15546241L, 62525861L, 12757257L, 64646556L, 24874095L, 48201831L, 23891632L}, new long[]{64693606L, 17976703L, 18312302L, 4964443L, 51836334L, 20900867L, 26820650L, 16690659L, 25459437L, 28989823L}, new long[]{41964155L, 11425019L, 28423002L, 22533875L, 60963942L, 17728207L, 9142794L, 31162830L, 60676445L, 0x1E6E6EEL}), new Ed25519.CachedXYT(new long[]{44004212L, 6253475L, 16964147L, 29785560L, 41994891L, 21257994L, 39651638L, 17209773L, 6335691L, 7249989L}, new long[]{36775618L, 13979674L, 7503222L, 21186118L, 55152142L, 28932738L, 36836594L, 2682241L, 25993170L, 21075909L}, new long[]{4364628L, 5930691L, 32304656L, 23509878L, 59054082L, 15091130L, 22857016L, 22955477L, 31820367L, 15075278L}), new Ed25519.CachedXYT(new long[]{31879134L, 24635739L, 17258760L, 90626L, 59067028L, 28636722L, 24162787L, 23903546L, 49138625L, 12833044L}, new long[]{19073683L, 14851414L, 42705695L, 21694263L, 7625277L, 11091125L, 47489674L, 2074448L, 57694925L, 14905376L}, new long[]{24483648L, 21618865L, 64589997L, 22007013L, 65555733L, 15355505L, 41826784L, 9253128L, 27628530L, 25998952L}), new Ed25519.CachedXYT(new long[]{17597607L, 8340603L, 19355617L, 552187L, 26198470L, 30377849L, 4593323L, 24396850L, 52997988L, 15297015L}, new long[]{510886L, 14337390L, 35323607L, 16638631L, 6328095L, 2713355L, 46891447L, 21690211L, 8683220L, 2921426L}, new long[]{18606791L, 11874196L, 27155355L, 28272950L, 43077121L, 6265445L, 41930624L, 32275507L, 4674689L, 0xD3F3DDL}), new Ed25519.CachedXYT(new long[]{13609624L, 13069022L, 39736503L, 20498523L, 24360585L, 9592974L, 14977157L, 9835105L, 4389687L, 288396L}, new long[]{9922506L, 33035038L, 13613106L, 5883594L, 48350519L, 33120168L, 0x3444141L, 8317627L, 23388070L, 16052080L}, new long[]{12719997L, 11937594L, 35138804L, 28525742L, 26900119L, 8561328L, 46953177L, 21921452L, 52354592L, 22741539L}), new Ed25519.CachedXYT(new long[]{15961858L, 14150409L, 26716931L, 32888600L, 44314535L, 13603568L, 11829573L, 7467844L, 38286736L, 929274L}, new long[]{11038231L, 0x14F4444L, 39798381L, 26237869L, 56610336L, 17246600L, 43629330L, 24182562L, 45715720L, 2465073L}, new long[]{20017144L, 29231206L, 27915241L, 1529148L, 12396362L, 15675764L, 13817261L, 23896366L, 2463390L, 28932292L}), new Ed25519.CachedXYT(new long[]{50749986L, 20890520L, 55043680L, 4996453L, 65852442L, 1073571L, 9583558L, 12851107L, 4003896L, 12673717L}, new long[]{65377275L, 18398561L, 63845933L, 16143081L, 19294135L, 13385325L, 14741514L, 24450706L, 7903885L, 2348101L}, new long[]{24536016L, 17039225L, 12715591L, 29692277L, 1511292L, 10047386L, 63266518L, 26425272L, 38731325L, 10048126L})}, {new Ed25519.CachedXYT(new long[]{54486638L, 27349611L, 30718824L, 2591312L, 56491836L, 12192839L, 18873298L, 26257342L, 34811107L, 15221631L}, new long[]{40630742L, 22450567L, 11546243L, 31701949L, 9180879L, 7656409L, 45764914L, 2095754L, 29769758L, 6593415L}, new long[]{35114656L, 30646970L, 4176911L, 3264766L, 12538965L, 32686321L, 26312344L, 27435754L, 30958053L, 8292160L}), new Ed25519.CachedXYT(new long[]{31429803L, 19595316L, 29173531L, 15632448L, 12174511L, 30794338L, 32808830L, 3977186L, 26143136L, 30405556L}, new long[]{22648882L, 1402143L, 44308880L, 13746058L, 7936347L, 365344L, 58440231L, 31879998L, 63350620L, 31249806L}, new long[]{51616947L, 8012312L, 64594134L, 20851969L, 43143017L, 23300402L, 65496150L, 32018862L, 50444388L, 8194477L}), new Ed25519.CachedXYT(new long[]{27338066L, 26047012L, 59694639L, 10140404L, 48082437L, 26964542L, 27277190L, 8855376L, 28572286L, 3005164L}, new long[]{26287105L, 4821776L, 25476601L, 29408529L, 63344350L, 17765447L, 49100281L, 1182478L, 41014043L, 20474836L}, new long[]{59937691L, 3178079L, 23970071L, 6201893L, 49913287L, 29065239L, 45232588L, 19571804L, 32208682L, 32356184L}), new Ed25519.CachedXYT(new long[]{50451143L, 2817642L, 56822502L, 14811297L, 6024667L, 13349505L, 39793360L, 23056589L, 39436278L, 22014573L}, new long[]{15941010L, 24148500L, 45741813L, 8062054L, 31876073L, 33315803L, 51830470L, 32110002L, 15397330L, 29424239L}, new long[]{0x885455L, 20068965L, 43822466L, 20131190L, 34662773L, 14047985L, 31170398L, 32113411L, 39603297L, 15087183L}), new Ed25519.CachedXYT(new long[]{48751602L, 31397940L, 24524912L, 16876564L, 15520426L, 27193656L, 51606457L, 11461895L, 16788528L, 27685490L}, new long[]{65161459L, 16013772L, 21750665L, 3714552L, 49707082L, 17498998L, 63338576L, 23231111L, 31322513L, 21938797L}, new long[]{21426636L, 27904214L, 53460576L, 28206894L, 38296674L, 28633461L, 48833472L, 18933017L, 13040861L, 21441484L}), new Ed25519.CachedXYT(new long[]{11293895L, 12478086L, 39972463L, 15083749L, 37801443L, 14748871L, 14555558L, 20137329L, 1613710L, 4896935L}, new long[]{41213962L, 15323293L, 58619073L, 25496531L, 25967125L, 20128972L, 2825959L, 28657387L, 43137087L, 22287016L}, new long[]{51184079L, 28324551L, 49665331L, 6410663L, 3622847L, 10243618L, 20615400L, 12405433L, 43355834L, 25118015L}), new Ed25519.CachedXYT(new long[]{60017550L, 12556207L, 46917512L, 9025186L, 50036385L, 4333800L, 4378436L, 2432030L, 23097949L, 32988414L}, new long[]{4565804L, 17528778L, 20084411L, 25711615L, 1724998L, 189254L, 24767264L, 10103221L, 48596551L, 2424777L}, new long[]{366633L, 21577626L, 8173089L, 26664313L, 30788633L, 5745705L, 59940186L, 1344108L, 63466311L, 12412658L}), new Ed25519.CachedXYT(new long[]{43107073L, 7690285L, 14929416L, 33386175L, 34898028L, 20141445L, 24162696L, 18227928L, 63967362L, 11179384L}, new long[]{18289503L, 18829478L, 8056944L, 16430056L, 45379140L, 7842513L, 61107423L, 32067534L, 48424218L, 22110928L}, new long[]{476239L, 6601091L, 60956074L, 23831056L, 17503544L, 28690532L, 27672958L, 13403813L, 11052904L, 5219329L})}, {new Ed25519.CachedXYT(new long[]{20678527L, 25178694L, 34436965L, 8849122L, 62099106L, 14574751L, 31186971L, 29580702L, 9014761L, 24975376L}, new long[]{53464795L, 23204192L, 51146355L, 5075807L, 65594203L, 22019831L, 34006363L, 9160279L, 8473550L, 30297594L}, new long[]{24900749L, 14435722L, 17209120L, 18261891L, 44516588L, 9878982L, 59419555L, 17218610L, 42540382L, 11788947L}), new Ed25519.CachedXYT(new long[]{63990690L, 22159237L, 53306774L, 14797440L, 9652448L, 26708528L, 47071426L, 10410732L, 42540394L, 32095740L}, new long[]{51449703L, 16736705L, 44641714L, 10215877L, 58011687L, 7563910L, 11871841L, 21049238L, 48595538L, 8464117L}, new long[]{43708233L, 8348506L, 52522913L, 32692717L, 63158658L, 27181012L, 14325288L, 8628612L, 33313881L, 25183915L}), new Ed25519.CachedXYT(new long[]{46921872L, 28586496L, 22367355L, 5271547L, 66011747L, 28765593L, 42303196L, 23317577L, 58168128L, 27736162L}, new long[]{60160060L, 31759219L, 34483180L, 17533252L, 32635413L, 26180187L, 15989196L, 20716244L, 28358191L, 29300528L}, new long[]{43547083L, 30755372L, 34757181L, 31892468L, 57961144L, 10429266L, 50471180L, 4072015L, 61757200L, 5596588L}), new Ed25519.CachedXYT(new long[]{38872266L, 30164383L, 12312895L, 6213178L, 3117142L, 16078565L, 29266239L, 2557221L, 1768301L, 15373193L}, new long[]{59865506L, 30307471L, 62515396L, 26001078L, 66980936L, 32642186L, 66017961L, 29049440L, 42448372L, 3442909L}, new long[]{36898293L, 5124042L, 14181784L, 8197961L, 18964734L, 21615339L, 22597930L, 7176455L, 48523386L, 13365929L}), new Ed25519.CachedXYT(new long[]{59231455L, 32054473L, 8324672L, 4690079L, 6261860L, 890446L, 24538107L, 24984246L, 57419264L, 30522764L}, new long[]{25008885L, 22782833L, 62803832L, 23916421L, 16265035L, 15721635L, 683793L, 21730648L, 15723478L, 18390951L}, new long[]{57448220L, 12374378L, 40101865L, 26528283L, 59384749L, 21239917L, 11879681L, 5400171L, 519526L, 32318556L}), new Ed25519.CachedXYT(new long[]{22258397L, 17222199L, 59239046L, 14613015L, 44588609L, 30603508L, 46754982L, 7315966L, 16648397L, 7605640L}, new long[]{59027556L, 25089834L, 58885552L, 9719709L, 19259459L, 18206220L, 23994941L, 28272877L, 57640015L, 4763277L}, new long[]{45409620L, 9220968L, 51378240L, 1084136L, 41632757L, 30702041L, 31088446L, 25789909L, 55752334L, 728111L}), new Ed25519.CachedXYT(new long[]{26047201L, 21802961L, 60208540L, 17032633L, 24092067L, 9158119L, 62835319L, 20998873L, 37743427L, 28056159L}, new long[]{17510331L, 33231575L, 5854288L, 8403524L, 17133918L, 30441820L, 38997856L, 12327944L, 10750447L, 10014012L}, new long[]{56796096L, 3936951L, 9156313L, 24656749L, 16498691L, 32559785L, 39627812L, 32887699L, 3424690L, 7540221L}), new Ed25519.CachedXYT(new long[]{30322361L, 26590322L, 11361004L, 29411115L, 7433303L, 4989748L, 60037442L, 17237212L, 57864598L, 15258045L}, new long[]{13054543L, 30774935L, 19155473L, 469045L, 54626067L, 4566041L, 5631406L, 2711395L, 1062915L, 28418087L}, new long[]{47868616L, 22299832L, 37599834L, 26054466L, 61273100L, 13005410L, 61042375L, 12194496L, 32960380L, 1459310L})}, {new Ed25519.CachedXYT(new long[]{19852015L, 7027924L, 23669353L, 10020366L, 8586503L, 26896525L, 394196L, 27452547L, 18638002L, 22379495L}, new long[]{31395515L, 15098109L, 26581030L, 8030562L, 50580950L, 28547297L, 9012485L, 25970078L, 60465776L, 28111795L}, new long[]{57916680L, 31207054L, 65111764L, 4529533L, 25766844L, 607986L, 67095642L, 9677542L, 34813975L, 27098423L}), new Ed25519.CachedXYT(new long[]{64664349L, 33404494L, 29348901L, 8186665L, 1873760L, 12489863L, 36174285L, 25714739L, 59256019L, 25416002L}, new long[]{51872508L, 18120922L, 7766469L, 746860L, 26346930L, 23332670L, 39775412L, 10754587L, 57677388L, 5203575L}, new long[]{31834314L, 14135496L, 66338857L, 5159117L, 20917671L, 16786336L, 59640890L, 26216907L, 31809242L, 7347066L}), new Ed25519.CachedXYT(new long[]{57502122L, 21680191L, 20414458L, 13033986L, 13716524L, 21862551L, 19797969L, 21343177L, 15192875L, 31466942L}, new long[]{54445282L, 31372712L, 1168161L, 29749623L, 26747876L, 19416341L, 10609329L, 12694420L, 33473243L, 20172328L}, new long[]{33184999L, 11180355L, 15832085L, 22169002L, 65475192L, 225883L, 15089336L, 22530529L, 60973201L, 14480052L}), new Ed25519.CachedXYT(new long[]{31308717L, 27934434L, 31030839L, 31657333L, 15674546L, 26971549L, 5496207L, 13685227L, 27595050L, 8737275L}, new long[]{46790012L, 18404192L, 10933842L, 17376410L, 0x7F2FF7L, 26008410L, 36100512L, 20943827L, 26498113L, 66511L}, new long[]{22644435L, 24792703L, 50437087L, 4884561L, 64003250L, 19995065L, 30540765L, 29267685L, 53781076L, 26039336L}), new Ed25519.CachedXYT(new long[]{39091017L, 9834844L, 18617207L, 30873120L, 63706907L, 20246925L, 8205539L, 13585437L, 49981399L, 15115438L}, new long[]{23711543L, 32881517L, 31206560L, 25191721L, 6164646L, 23844445L, 33572981L, 32128335L, 8236920L, 16492939L}, new long[]{43198286L, 20038905L, 40809380L, 29050590L, 25005589L, 25867162L, 19574901L, 10071562L, 6708380L, 27332008L}), new Ed25519.CachedXYT(new long[]{2101372L, 28624378L, 19702730L, 2367575L, 51681697L, 1047674L, 5301017L, 9328700L, 29955601L, 21876122L}, new long[]{3096359L, 9271816L, 45488000L, 18032587L, 52260867L, 25961494L, 41216721L, 20918836L, 57191288L, 6216607L}, new long[]{34493015L, 338662L, 41913253L, 2510421L, 37895298L, 19734218L, 24822829L, 27407865L, 40341383L, 7525078L}), new Ed25519.CachedXYT(new long[]{44042215L, 19568808L, 16133486L, 25658254L, 63719298L, 778787L, 66198528L, 30771936L, 47722230L, 11994100L}, new long[]{21691500L, 19929806L, 66467532L, 19187410L, 3285880L, 30070836L, 42044197L, 9718257L, 59631427L, 13381417L}, new long[]{18445390L, 29352196L, 14979845L, 11622458L, 65381754L, 29971451L, 23111647L, 27179185L, 28535281L, 15779576L}), new Ed25519.CachedXYT(new long[]{30098034L, 3089662L, 57874477L, 16662134L, 45801924L, 11308410L, 53040410L, 12021729L, 9955285L, 17251076L}, new long[]{9734894L, 18977602L, 59635230L, 24415696L, 2060391L, 11313496L, 48682835L, 9924398L, 20194861L, 13380996L}, new long[]{40730762L, 25589224L, 44941042L, 15789296L, 49053522L, 27385639L, 65123949L, 15707770L, 26342023L, 10146099L})}, {new Ed25519.CachedXYT(new long[]{41091971L, 33334488L, 21339190L, 33513044L, 19745255L, 30675732L, 37471583L, 2227039L, 21612326L, 33008704L}, new long[]{54031477L, 1184227L, 23562814L, 27583990L, 46757619L, 27205717L, 25764460L, 12243797L, 46252298L, 11649657L}, new long[]{57077370L, 11262625L, 27384172L, 2271902L, 26947504L, 17556661L, 39943L, 6114064L, 33514190L, 2333242L}), new Ed25519.CachedXYT(new long[]{45675257L, 21132610L, 8119781L, 7219913L, 45278342L, 24538297L, 60429113L, 20883793L, 24350577L, 20104431L}, new long[]{62992557L, 22282898L, 43222677L, 4843614L, 37020525L, 690622L, 35572776L, 23147595L, 8317859L, 12352766L}, new long[]{18200138L, 19078521L, 34021104L, 30857812L, 43406342L, 24451920L, 43556767L, 31266881L, 20712162L, 6719373L}), new Ed25519.CachedXYT(new long[]{26656189L, 6075253L, 59250308L, 0x1CC777L, 38764821L, 4262325L, 11117530L, 29791222L, 26224234L, 30256974L}, new long[]{49939907L, 18700334L, 63713187L, 17184554L, 47154818L, 14050419L, 21728352L, 9493610L, 18620611L, 17125804L}, new long[]{0x334B3B4L, 13325348L, 11432106L, 5964811L, 18609221L, 6062965L, 61839393L, 23828875L, 36407290L, 17074774L}), new Ed25519.CachedXYT(new long[]{43248326L, 22321272L, 26961356L, 1640861L, 34695752L, 16816491L, 12248508L, 28313793L, 13735341L, 1934062L}, new long[]{25089769L, 6742589L, 17081145L, 20148166L, 21909292L, 17486451L, 51972569L, 29789085L, 45830866L, 5473615L}, new long[]{31883658L, 25593331L, 1083431L, 21982029L, 22828470L, 13290673L, 59983779L, 12469655L, 29111212L, 28103418L}), new Ed25519.CachedXYT(new long[]{24244947L, 18504025L, 40845887L, 2791539L, 52111265L, 16666677L, 24367466L, 6388839L, 56813277L, 452382L}, new long[]{41468082L, 30136590L, 5217915L, 16224624L, 19987036L, 29472163L, 42872612L, 27639183L, 15766061L, 8407814L}, new long[]{46701865L, 13990230L, 15495425L, 16395525L, 5377168L, 15166495L, 58191841L, 29165478L, 59040954L, 2276717L}), new Ed25519.CachedXYT(new long[]{30157899L, 12924066L, 49396814L, 9245752L, 19895028L, 3368142L, 43281277L, 5096218L, 22740376L, 26251015L}, new long[]{2041139L, 19298082L, 7783686L, 13876377L, 41161879L, 20201972L, 24051123L, 13742383L, 51471265L, 13295221L}, new long[]{33338218L, 25048699L, 12532112L, 7977527L, 9106186L, 31839181L, 49388668L, 28941459L, 62657506L, 18884987L}), new Ed25519.CachedXYT(new long[]{47063583L, 5454096L, 52762316L, 6447145L, 28862071L, 1883651L, 64639598L, 29412551L, 7770568L, 9620597L}, new long[]{23208049L, 7979712L, 33071466L, 8149229L, 1758231L, 22719437L, 30945527L, 31860109L, 33606523L, 18786461L}, new long[]{1439939L, 17283952L, 66028874L, 32760649L, 4625401L, 10647766L, 62065063L, 1220117L, 30494170L, 22113633L}), new Ed25519.CachedXYT(new long[]{62071265L, 20526136L, 64138304L, 30492664L, 15640973L, 26852766L, 40369837L, 926049L, 65424525L, 20220784L}, new long[]{13908495L, 30005160L, 30919927L, 27280607L, 45587000L, 7989038L, 9021034L, 9078865L, 3353509L, 4033511L}, new long[]{37445433L, 18440821L, 32259990L, 33209950L, 24295848L, 20642309L, 23161162L, 8839127L, 27485041L, 7356032L})}, {new Ed25519.CachedXYT(new long[]{9661008L, 705443L, 11980065L, 28184278L, 65480320L, 14661172L, 60762722L, 2625014L, 28431036L, 16782598L}, new long[]{43269631L, 25243016L, 41163352L, 7480957L, 49427195L, 25200248L, 44562891L, 14150564L, 15970762L, 4099461L}, new long[]{29262576L, 16756590L, 26350592L, 24760869L, 8529670L, 22346382L, 0xCFC88CL, 23617289L, 11465738L, 8317062L}), new Ed25519.CachedXYT(new long[]{41615764L, 26591503L, 32500199L, 24135381L, 44070139L, 31252209L, 14898636L, 3848455L, 20969334L, 28396916L}, new long[]{46724414L, 19206718L, 48772458L, 0xD3DD31L, 34069410L, 2842113L, 45498038L, 29904543L, 11177094L, 14989547L}, new long[]{42612143L, 21838415L, 16959895L, 2278463L, 12066309L, 10137771L, 13515641L, 2581286L, 38621356L, 9930239L}), new Ed25519.CachedXYT(new long[]{49357223L, 31456605L, 16544299L, 20545132L, 51194056L, 18605350L, 18345766L, 20150679L, 16291480L, 28240394L}, new long[]{33879670L, 2553287L, 32678213L, 9875984L, 8534129L, 6889387L, 57432090L, 6957616L, 4368891L, 9788741L}, new long[]{16660737L, 7281060L, 56278106L, 12911819L, 20108584L, 25452756L, 45386327L, 24941283L, 16250551L, 22443329L}), new Ed25519.CachedXYT(new long[]{47343357L, 2390525L, 50557833L, 14161979L, 1905286L, 6414907L, 4689584L, 10604807L, 36918461L, 4782746L}, new long[]{65754325L, 14736940L, 59741422L, 20261545L, 7710541L, 19398842L, 57127292L, 4383044L, 22546403L, 437323L}, new long[]{31665558L, 21373968L, 50922033L, 1491338L, 48740239L, 3294681L, 27343084L, 2786261L, 36475274L, 19457415L}), new Ed25519.CachedXYT(new long[]{52641566L, 32870716L, 33734756L, 7448551L, 19294360L, 14334329L, 47418233L, 2355318L, 47824193L, 27440058L}, new long[]{15121312L, 17758270L, 6377019L, 27523071L, 56310752L, 20596586L, 18952176L, 15496498L, 37728731L, 11754227L}, new long[]{64471568L, 20071356L, 8488726L, 19250536L, 12728760L, 31931939L, 7141595L, 11724556L, 22761615L, 23420291L}), new Ed25519.CachedXYT(new long[]{16918416L, 11729663L, 49025285L, 3022986L, 36093132L, 20214772L, 38367678L, 21327038L, 32851221L, 11717399L}, new long[]{11166615L, 7338049L, 60386341L, 4531519L, 37640192L, 26252376L, 31474878L, 3483633L, 65915689L, 29523600L}, new long[]{66923210L, 9921304L, 31456609L, 20017994L, 55095045L, 13348922L, 33142652L, 6546660L, 47123585L, 29606055L}), new Ed25519.CachedXYT(new long[]{34648249L, 11266711L, 55911757L, 25655328L, 31703693L, 3855903L, 58571733L, 20721383L, 36336829L, 18068118L}, new long[]{49102387L, 12709067L, 3991746L, 27075244L, 45617340L, 23004006L, 35973516L, 17504552L, 10928916L, 3011958L}, new long[]{60151107L, 17960094L, 31696058L, 334240L, 29576716L, 14796075L, 36277808L, 20749251L, 18008030L, 10258577L}), new Ed25519.CachedXYT(new long[]{44660220L, 15655568L, 7018479L, 29144429L, 36794597L, 32352840L, 65255398L, 1367119L, 25127874L, 6671743L}, new long[]{29701166L, 19180498L, 56230743L, 9279287L, 67091296L, 13127209L, 21382910L, 11042292L, 25838796L, 4642684L}, new long[]{46678630L, 14955536L, 42982517L, 8124618L, 61739576L, 27563961L, 30468146L, 19653792L, 18423288L, 4177476L})}};
    static final Ed25519.CachedXYT[] B2 = new Ed25519.CachedXYT[]{new Ed25519.CachedXYT(new long[]{25967493L, 19198397L, 29566455L, 3660896L, 54414519L, 4014786L, 27544626L, 21800161L, 61029707L, 2047604L}, new long[]{54563134L, 934261L, 64385954L, 3049989L, 66381436L, 9406985L, 12720692L, 5043384L, 19500929L, 18085054L}, new long[]{58370664L, 4489569L, 9688441L, 18769238L, 10184608L, 21191052L, 29287918L, 11864899L, 42594502L, 29115885L}), new Ed25519.CachedXYT(new long[]{15636272L, 23865875L, 24204772L, 25642034L, 616976L, 16869170L, 27787599L, 18782243L, 28944399L, 32004408L}, new long[]{16568933L, 4717097L, 55552716L, 32452109L, 15682895L, 21747389L, 16354576L, 21778470L, 7689661L, 11199574L}, new long[]{30464137L, 27578307L, 55329429L, 17883566L, 23220364L, 15915852L, 7512774L, 10017326L, 49359771L, 23634074L}), new Ed25519.CachedXYT(new long[]{10861363L, 11473154L, 27284546L, 1981175L, 37044515L, 12577860L, 32867885L, 14515107L, 51670560L, 10819379L}, new long[]{4708026L, 6336745L, 20377586L, 9066809L, 55836755L, 6594695L, 41455196L, 12483687L, 54440373L, 5581305L}, new long[]{19563141L, 16186464L, 37722007L, 4097518L, 10237984L, 29206317L, 28542349L, 13850243L, 43430843L, 17738489L}), new Ed25519.CachedXYT(new long[]{5153727L, 9909285L, 1723747L, 30776558L, 30523604L, 5516873L, 19480852L, 5230134L, 43156425L, 18378665L}, new long[]{36839857L, 30090922L, 7665485L, 0x99DDD1L, 28475525L, 1649722L, 20654025L, 16520125L, 30598449L, 0x75BB75L}, new long[]{28881826L, 14381568L, 9657904L, 3680757L, 46927229L, 7843315L, 35708204L, 1370707L, 29794553L, 32145132L}), new Ed25519.CachedXYT(new long[]{44589871L, 26862249L, 14201701L, 24808930L, 43598457L, 8844725L, 18474211L, 32192982L, 54046167L, 13821876L}, new long[]{60653668L, 25714560L, 3374701L, 28813570L, 40010246L, 22982724L, 31655027L, 26342105L, 18853321L, 19333481L}, new long[]{4566811L, 20590564L, 38133974L, 21313742L, 59506191L, 30723862L, 58594505L, 23123294L, 2207752L, 30344648L}), new Ed25519.CachedXYT(new long[]{41954014L, 29368610L, 29681143L, 0x781181L, 60254203L, 24130566L, 54671499L, 32891431L, 35997400L, 17421995L}, new long[]{25576264L, 30851218L, 7349803L, 21739588L, 16472781L, 9300885L, 3844789L, 15725684L, 171356L, 6466918L}, new long[]{23103977L, 13316479L, 9739013L, 17404951L, 817874L, 18515490L, 8965338L, 19466374L, 36393951L, 16193876L}), new Ed25519.CachedXYT(new long[]{33587053L, 3180712L, 64714734L, 14003686L, 50205390L, 17283591L, 17238397L, 4729455L, 49034351L, 9256799L}, new long[]{41926547L, 29380300L, 32336397L, 5036987L, 45872047L, 11360616L, 0x1591955L, 9761698L, 47281666L, 630304L}, new long[]{53388152L, 2639452L, 42871404L, 26147950L, 9494426L, 27780403L, 60554312L, 17593437L, 64659607L, 19263131L}), new Ed25519.CachedXYT(new long[]{63957664L, 28508356L, 9282713L, 6866145L, 35201802L, 32691408L, 48168288L, 15033783L, 25105118L, 25659556L}, new long[]{42782475L, 15950225L, 35307649L, 18961608L, 55446126L, 28463506L, 1573891L, 30928545L, 2198789L, 17749813L}, new long[]{64009494L, 10324966L, 64867251L, 7453182L, 61661885L, 30818928L, 53296841L, 17317989L, 34647629L, 21263748L})};

    Ed25519Constants() {
    }
}

