/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.crypto.tink.subtle.ImmutableByteArray;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import javax.crypto.KeyAgreement;

public final class EciesHkdfSenderKem {
    private ECPublicKey recipientPublicKey;

    public EciesHkdfSenderKem(ECPublicKey recipientPublicKey) {
        this.recipientPublicKey = recipientPublicKey;
    }

    public KemKey generateKey(String hmacAlgo, byte[] hkdfSalt, byte[] hkdfInfo, int keySizeInBytes, EllipticCurves.PointFormatType pointFormat) throws GeneralSecurityException {
        KeyPair ephemeralKeyPair = this.generateEphemeralKey();
        ECPublicKey ephemeralPublicKey = (ECPublicKey)ephemeralKeyPair.getPublic();
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)ephemeralKeyPair.getPrivate();
        byte[] sharedSecret = this.getSharedSecret(ephemeralPrivateKey);
        byte[] kemBytes = EllipticCurves.ecPointEncode(ephemeralPublicKey.getParams().getCurve(), pointFormat, ephemeralPublicKey.getW());
        byte[] symmetricKey = Hkdf.computeEciesHkdfSymmetricKey(kemBytes, sharedSecret, hmacAlgo, hkdfSalt, hkdfInfo, keySizeInBytes);
        return new KemKey(kemBytes, symmetricKey);
    }

    private KeyPair generateEphemeralKey() throws GeneralSecurityException {
        ECParameterSpec spec = this.recipientPublicKey.getParams();
        KeyPairGenerator keyGen = EngineFactory.KEY_PAIR_GENERATOR.getInstance("EC");
        keyGen.initialize(spec);
        return keyGen.generateKeyPair();
    }

    private byte[] getSharedSecret(ECPrivateKey senderPrivateKey) throws GeneralSecurityException {
        ECPoint publicPoint = this.recipientPublicKey.getW();
        ECParameterSpec spec = this.recipientPublicKey.getParams();
        EllipticCurves.checkPointOnCurve(publicPoint, spec.getCurve());
        KeyAgreement ka = EngineFactory.KEY_AGREEMENT.getInstance("ECDH");
        ka.init(senderPrivateKey);
        ka.doPhase(this.recipientPublicKey, true);
        return ka.generateSecret();
    }

    @Immutable
    public static final class KemKey {
        private final ImmutableByteArray kemBytes;
        private final ImmutableByteArray symmetricKey;

        public KemKey(byte[] kemBytes, byte[] symmetricKey) {
            this.kemBytes = ImmutableByteArray.of(kemBytes);
            this.symmetricKey = ImmutableByteArray.of(symmetricKey);
        }

        public byte[] getKemBytes() {
            if (this.kemBytes == null) {
                return null;
            }
            return this.kemBytes.getBytes();
        }

        public byte[] getSymmetricKey() {
            if (this.symmetricKey == null) {
                return null;
            }
            return this.symmetricKey.getBytes();
        }
    }
}

