/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Hkdf;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import javax.crypto.KeyAgreement;

public final class EciesHkdfRecipientKem {
    private ECPrivateKey recipientPrivateKey;

    public EciesHkdfRecipientKem(ECPrivateKey recipientPrivateKey) {
        this.recipientPrivateKey = recipientPrivateKey;
    }

    public byte[] generateKey(byte[] kemBytes, String hmacAlgo, byte[] hkdfSalt, byte[] hkdfInfo, int keySizeInBytes, EllipticCurves.PointFormatType pointFormat) throws GeneralSecurityException {
        ECParameterSpec spec = this.recipientPrivateKey.getParams();
        ECPoint ephemeralPublicPoint = EllipticCurves.ecPointDecode(spec.getCurve(), pointFormat, kemBytes);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(ephemeralPublicPoint, spec);
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("EC");
        ECPublicKey ephemeralPublicKey = (ECPublicKey)kf.generatePublic(publicKeySpec);
        byte[] sharedSecret = this.getSharedSecret(ephemeralPublicKey);
        return Hkdf.computeEciesHkdfSymmetricKey(kemBytes, sharedSecret, hmacAlgo, hkdfSalt, hkdfInfo, keySizeInBytes);
    }

    private byte[] getSharedSecret(ECPublicKey publicKey) throws GeneralSecurityException {
        ECParameterSpec spec = this.recipientPrivateKey.getParams();
        EllipticCurves.checkPointOnCurve(publicKey.getW(), spec.getCurve());
        KeyAgreement ka = EngineFactory.KEY_AGREEMENT.getInstance("ECDH");
        ka.init(this.recipientPrivateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret();
    }
}

