/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;

public final class EcdsaVerifyJce
implements PublicKeyVerify {
    private final ECPublicKey publicKey;
    private final String signatureAlgorithm;

    public EcdsaVerifyJce(ECPublicKey pubKey, String signatureAlgorithm) throws GeneralSecurityException {
        EllipticCurves.checkPublicKey(pubKey);
        this.publicKey = pubKey;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        Signature verifier = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm);
        verifier.initVerify(this.publicKey);
        verifier.update(data);
        boolean verified = false;
        try {
            verified = verifier.verify(signature);
        }
        catch (RuntimeException ex) {
            verified = false;
        }
        if (!verified) {
            throw new GeneralSecurityException("Invalid signature");
        }
    }
}

