/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.subtle.DjbCipher;
import com.google.crypto.tink.subtle.Poly1305;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;

@Alpha
public abstract class DjbCipherPoly1305
implements Aead {
    private final DjbCipher djbCipher;

    private DjbCipherPoly1305(DjbCipher djbCipher) {
        this.djbCipher = djbCipher;
    }

    public static DjbCipherPoly1305 constructChaCha20Poly1305Ietf(byte[] key) {
        return new DjbCipherPoly1305Ietf(DjbCipher.chaCha20(key));
    }

    public static DjbCipherPoly1305 constructXSalsa20Poly1305Nacl(byte[] key) {
        return new DjbCipherPoly1305Nacl(DjbCipher.xSalsa20(key));
    }

    public static DjbCipherPoly1305 constructXChaCha20Poly1305Ietf(byte[] key) {
        return new DjbCipherPoly1305Ietf(DjbCipher.xChaCha20(key));
    }

    private static int blockSizeMultipleCeil(int x) {
        return (x + 16 - 1) / 16 * 16;
    }

    abstract byte[] macData(byte[] var1, ByteBuffer var2);

    public int nonceSizeInBytes() {
        return this.djbCipher.nonceSizeInBytes();
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] additionalData) throws GeneralSecurityException {
        ByteBuffer ciphertext = ByteBuffer.allocate(this.nonceSizeInBytes() + plaintext.length + 16);
        this.encrypt(ciphertext, plaintext, additionalData);
        return ciphertext.array();
    }

    void encrypt(ByteBuffer output, byte[] plaintext, byte[] additionalData) throws GeneralSecurityException {
        if (output.remaining() < plaintext.length + this.nonceSizeInBytes() + 16) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        int firstPosition = output.position();
        this.djbCipher.encrypt(output, plaintext);
        output.position(firstPosition);
        byte[] nonce = new byte[this.djbCipher.nonceSizeInBytes()];
        output.get(nonce);
        output.limit(output.limit() - 16);
        byte[] tag = Poly1305.computeMac(this.djbCipher.getAuthenticatorKey(nonce), this.macData(additionalData, output));
        output.limit(output.limit() + 16);
        output.put(tag);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] additionalData) throws GeneralSecurityException {
        return this.decrypt(ByteBuffer.wrap(ciphertext), additionalData);
    }

    byte[] decrypt(ByteBuffer ciphertext, byte[] additionalData) throws GeneralSecurityException {
        if (ciphertext.remaining() < this.djbCipher.nonceSizeInBytes() + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        int firstPosition = ciphertext.position();
        byte[] tag = new byte[16];
        ciphertext.position(ciphertext.limit() - 16);
        ciphertext.get(tag);
        ciphertext.position(firstPosition);
        ciphertext.limit(ciphertext.limit() - 16);
        byte[] nonce = new byte[this.djbCipher.nonceSizeInBytes()];
        ciphertext.get(nonce);
        Poly1305.verifyMac(this.djbCipher.getAuthenticatorKey(nonce), this.macData(additionalData, ciphertext), tag);
        ciphertext.position(firstPosition);
        return this.djbCipher.decrypt(ciphertext);
    }

    private static class DjbCipherPoly1305Nacl
    extends DjbCipherPoly1305 {
        private DjbCipherPoly1305Nacl(DjbCipher djbCipher) {
            super(djbCipher);
        }

        @Override
        byte[] macData(byte[] aad, ByteBuffer ciphertext) {
            byte[] macData = new byte[ciphertext.remaining()];
            ciphertext.get(macData);
            return macData;
        }
    }

    private static class DjbCipherPoly1305Ietf
    extends DjbCipherPoly1305 {
        private DjbCipherPoly1305Ietf(DjbCipher djbCipher) {
            super(djbCipher);
        }

        @Override
        byte[] macData(byte[] aad, ByteBuffer ciphertext) {
            int aadCeilLen = DjbCipherPoly1305.blockSizeMultipleCeil(aad.length);
            int ciphertextLen = ciphertext.remaining();
            int ciphertextCeilLen = DjbCipherPoly1305.blockSizeMultipleCeil(ciphertextLen);
            ByteBuffer macData = ByteBuffer.allocate(aadCeilLen + ciphertextCeilLen + 16).order(ByteOrder.LITTLE_ENDIAN);
            macData.put(aad);
            macData.position(aadCeilLen);
            macData.put(ciphertext);
            macData.position(aadCeilLen + ciphertextCeilLen);
            macData.putLong(aad.length);
            macData.putLong(ciphertextLen);
            return macData.array();
        }
    }
}

