/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.subtle.Random;
import java.util.Arrays;

@Alpha
public final class Curve25519 {
    static final int FIELD_LEN = 32;
    static final int LIMB_CNT = 10;
    private static final long TWO_TO_25 = 0x2000000L;
    private static final long TWO_TO_26 = 0x4000000L;
    private static final int[] EXPAND_START = new int[]{0, 3, 6, 9, 12, 16, 19, 22, 25, 28};
    private static final int[] EXPAND_SHIFT = new int[]{0, 2, 3, 5, 6, 0, 1, 3, 4, 6};
    private static final int[] MASK = new int[]{0x3FFFFFF, 0x1FFFFFF};
    private static final int[] SHIFT = new int[]{26, 25};

    static void sum(long[] output, long[] in1, long[] in2) {
        for (int i = 0; i < 10; ++i) {
            output[i] = in1[i] + in2[i];
        }
    }

    private static void sum(long[] output, long[] in) {
        Curve25519.sum(output, output, in);
    }

    static void sub(long[] output, long[] in1, long[] in2) {
        for (int i = 0; i < 10; ++i) {
            output[i] = in1[i] - in2[i];
        }
    }

    private static void sub(long[] output, long[] in) {
        Curve25519.sub(output, in, output);
    }

    private static void scalarProduct(long[] output, long[] in, long scalar) {
        for (int i = 0; i < 10; ++i) {
            output[i] = in[i] * scalar;
        }
    }

    private static void product(long[] out, long[] in2, long[] in) {
        out[0] = in2[0] * in[0];
        out[1] = in2[0] * in[1] + in2[1] * in[0];
        out[2] = 2L * in2[1] * in[1] + in2[0] * in[2] + in2[2] * in[0];
        out[3] = in2[1] * in[2] + in2[2] * in[1] + in2[0] * in[3] + in2[3] * in[0];
        out[4] = in2[2] * in[2] + 2L * (in2[1] * in[3] + in2[3] * in[1]) + in2[0] * in[4] + in2[4] * in[0];
        out[5] = in2[2] * in[3] + in2[3] * in[2] + in2[1] * in[4] + in2[4] * in[1] + in2[0] * in[5] + in2[5] * in[0];
        out[6] = 2L * (in2[3] * in[3] + in2[1] * in[5] + in2[5] * in[1]) + in2[2] * in[4] + in2[4] * in[2] + in2[0] * in[6] + in2[6] * in[0];
        out[7] = in2[3] * in[4] + in2[4] * in[3] + in2[2] * in[5] + in2[5] * in[2] + in2[1] * in[6] + in2[6] * in[1] + in2[0] * in[7] + in2[7] * in[0];
        out[8] = in2[4] * in[4] + 2L * (in2[3] * in[5] + in2[5] * in[3] + in2[1] * in[7] + in2[7] * in[1]) + in2[2] * in[6] + in2[6] * in[2] + in2[0] * in[8] + in2[8] * in[0];
        out[9] = in2[4] * in[5] + in2[5] * in[4] + in2[3] * in[6] + in2[6] * in[3] + in2[2] * in[7] + in2[7] * in[2] + in2[1] * in[8] + in2[8] * in[1] + in2[0] * in[9] + in2[9] * in[0];
        out[10] = 2L * (in2[5] * in[5] + in2[3] * in[7] + in2[7] * in[3] + in2[1] * in[9] + in2[9] * in[1]) + in2[4] * in[6] + in2[6] * in[4] + in2[2] * in[8] + in2[8] * in[2];
        out[11] = in2[5] * in[6] + in2[6] * in[5] + in2[4] * in[7] + in2[7] * in[4] + in2[3] * in[8] + in2[8] * in[3] + in2[2] * in[9] + in2[9] * in[2];
        out[12] = in2[6] * in[6] + 2L * (in2[5] * in[7] + in2[7] * in[5] + in2[3] * in[9] + in2[9] * in[3]) + in2[4] * in[8] + in2[8] * in[4];
        out[13] = in2[6] * in[7] + in2[7] * in[6] + in2[5] * in[8] + in2[8] * in[5] + in2[4] * in[9] + in2[9] * in[4];
        out[14] = 2L * (in2[7] * in[7] + in2[5] * in[9] + in2[9] * in[5]) + in2[6] * in[8] + in2[8] * in[6];
        out[15] = in2[7] * in[8] + in2[8] * in[7] + in2[6] * in[9] + in2[9] * in[6];
        out[16] = in2[8] * in[8] + 2L * (in2[7] * in[9] + in2[9] * in[7]);
        out[17] = in2[8] * in[9] + in2[9] * in[8];
        out[18] = 2L * in2[9] * in[9];
    }

    private static void reduceDegree(long[] output) {
        output[8] = output[8] + (output[18] << 4);
        output[8] = output[8] + (output[18] << 1);
        output[8] = output[8] + output[18];
        output[7] = output[7] + (output[17] << 4);
        output[7] = output[7] + (output[17] << 1);
        output[7] = output[7] + output[17];
        output[6] = output[6] + (output[16] << 4);
        output[6] = output[6] + (output[16] << 1);
        output[6] = output[6] + output[16];
        output[5] = output[5] + (output[15] << 4);
        output[5] = output[5] + (output[15] << 1);
        output[5] = output[5] + output[15];
        output[4] = output[4] + (output[14] << 4);
        output[4] = output[4] + (output[14] << 1);
        output[4] = output[4] + output[14];
        output[3] = output[3] + (output[13] << 4);
        output[3] = output[3] + (output[13] << 1);
        output[3] = output[3] + output[13];
        output[2] = output[2] + (output[12] << 4);
        output[2] = output[2] + (output[12] << 1);
        output[2] = output[2] + output[12];
        output[1] = output[1] + (output[11] << 4);
        output[1] = output[1] + (output[11] << 1);
        output[1] = output[1] + output[11];
        output[0] = output[0] + (output[10] << 4);
        output[0] = output[0] + (output[10] << 1);
        output[0] = output[0] + output[10];
    }

    private static void reduceCoefficients(long[] output) {
        output[10] = 0L;
        for (int i = 0; i < 10; i += 2) {
            long over = output[i] / 0x4000000L;
            int n = i;
            output[n] = output[n] - (over << 26);
            int n2 = i + 1;
            output[n2] = output[n2] + over;
            over = output[i + 1] / 0x2000000L;
            int n3 = i + 1;
            output[n3] = output[n3] - (over << 25);
            int n4 = i + 2;
            output[n4] = output[n4] + over;
        }
        output[0] = output[0] + (output[10] << 4);
        output[0] = output[0] + (output[10] << 1);
        output[0] = output[0] + output[10];
        output[10] = 0L;
        long over = output[0] / 0x4000000L;
        output[0] = output[0] - (over << 26);
        output[1] = output[1] + over;
    }

    static void mult(long[] output, long[] in, long[] in2) {
        long[] t = new long[19];
        Curve25519.product(t, in, in2);
        Curve25519.reduceDegree(t);
        Curve25519.reduceCoefficients(t);
        System.arraycopy(t, 0, output, 0, 10);
    }

    private static void squareInner(long[] out, long[] in) {
        out[0] = in[0] * in[0];
        out[1] = 2L * in[0] * in[1];
        out[2] = 2L * (in[1] * in[1] + in[0] * in[2]);
        out[3] = 2L * (in[1] * in[2] + in[0] * in[3]);
        out[4] = in[2] * in[2] + 4L * in[1] * in[3] + 2L * in[0] * in[4];
        out[5] = 2L * (in[2] * in[3] + in[1] * in[4] + in[0] * in[5]);
        out[6] = 2L * (in[3] * in[3] + in[2] * in[4] + in[0] * in[6] + 2L * in[1] * in[5]);
        out[7] = 2L * (in[3] * in[4] + in[2] * in[5] + in[1] * in[6] + in[0] * in[7]);
        out[8] = in[4] * in[4] + 2L * (in[2] * in[6] + in[0] * in[8] + 2L * (in[1] * in[7] + in[3] * in[5]));
        out[9] = 2L * (in[4] * in[5] + in[3] * in[6] + in[2] * in[7] + in[1] * in[8] + in[0] * in[9]);
        out[10] = 2L * (in[5] * in[5] + in[4] * in[6] + in[2] * in[8] + 2L * (in[3] * in[7] + in[1] * in[9]));
        out[11] = 2L * (in[5] * in[6] + in[4] * in[7] + in[3] * in[8] + in[2] * in[9]);
        out[12] = in[6] * in[6] + 2L * (in[4] * in[8] + 2L * (in[5] * in[7] + in[3] * in[9]));
        out[13] = 2L * (in[6] * in[7] + in[5] * in[8] + in[4] * in[9]);
        out[14] = 2L * (in[7] * in[7] + in[6] * in[8] + 2L * in[5] * in[9]);
        out[15] = 2L * (in[7] * in[8] + in[6] * in[9]);
        out[16] = in[8] * in[8] + 4L * in[7] * in[9];
        out[17] = 2L * in[8] * in[9];
        out[18] = 2L * in[9] * in[9];
    }

    static void square(long[] output, long[] in) {
        long[] t = new long[19];
        Curve25519.squareInner(t, in);
        Curve25519.reduceDegree(t);
        Curve25519.reduceCoefficients(t);
        System.arraycopy(t, 0, output, 0, 10);
    }

    static long[] expand(byte[] input) {
        long[] output = new long[10];
        for (int i = 0; i < 10; ++i) {
            output[i] = ((long)(input[EXPAND_START[i]] & 0xFF) | (long)(input[EXPAND_START[i] + 1] & 0xFF) << 8 | (long)(input[EXPAND_START[i] + 2] & 0xFF) << 16 | (long)(input[EXPAND_START[i] + 3] & 0xFF) << 24) >> EXPAND_SHIFT[i] & (long)MASK[i & 1];
        }
        return output;
    }

    private static int eq(int a, int b) {
        a = ~(a ^ b);
        a &= a << 16;
        a &= a << 8;
        a &= a << 4;
        a &= a << 2;
        a &= a << 1;
        return a >> 31;
    }

    private static int gte(int a, int b) {
        return ~((a -= b) >> 31);
    }

    static byte[] contract(long[] inputLimbs) {
        int carry;
        int i;
        int j;
        long[] input = Arrays.copyOf(inputLimbs, 10);
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 9; ++i) {
                carry = -((int)((input[i] & input[i] >> 31) >> SHIFT[i & 1]));
                input[i] = input[i] + (long)(carry << SHIFT[i & 1]);
                int n = i + 1;
                input[n] = input[n] - (long)carry;
            }
            int carry2 = -((int)((input[9] & input[9] >> 31) >> 25));
            input[9] = input[9] + (long)(carry2 << 25);
            input[0] = input[0] - (long)(carry2 * 19);
        }
        int carry3 = -((int)((input[0] & input[0] >> 31) >> 26));
        input[0] = input[0] + (long)(carry3 << 26);
        input[1] = input[1] - (long)carry3;
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 9; ++i) {
                carry = (int)(input[i] >> SHIFT[i & 1]);
                int n = i;
                input[n] = input[n] & (long)MASK[i & 1];
                int n2 = i + 1;
                input[n2] = input[n2] + (long)carry;
            }
        }
        carry3 = (int)(input[9] >> 25);
        input[9] = input[9] & 0x1FFFFFFL;
        input[0] = input[0] + (long)(19 * carry3);
        int mask = Curve25519.gte((int)input[0], 67108845);
        for (i = 1; i < 10; ++i) {
            mask &= Curve25519.eq((int)input[i], MASK[i & 1]);
        }
        input[0] = input[0] - (long)(mask & 0x3FFFFED);
        input[1] = input[1] - (long)(mask & 0x1FFFFFF);
        for (i = 2; i < 10; i += 2) {
            int n = i;
            input[n] = input[n] - (long)(mask & 0x3FFFFFF);
            int n3 = i + 1;
            input[n3] = input[n3] - (long)(mask & 0x1FFFFFF);
        }
        for (i = 0; i < 10; ++i) {
            int n = i;
            input[n] = input[n] << EXPAND_SHIFT[i];
        }
        byte[] output = new byte[32];
        for (int i2 = 0; i2 < 10; ++i2) {
            int n = EXPAND_START[i2];
            output[n] = (byte)((long)output[n] | input[i2] & 0xFFL);
            int n4 = EXPAND_START[i2] + 1;
            output[n4] = (byte)((long)output[n4] | input[i2] >> 8 & 0xFFL);
            int n5 = EXPAND_START[i2] + 2;
            output[n5] = (byte)((long)output[n5] | input[i2] >> 16 & 0xFFL);
            int n6 = EXPAND_START[i2] + 3;
            output[n6] = (byte)((long)output[n6] | input[i2] >> 24 & 0xFFL);
        }
        return output;
    }

    private static void monty(long[] x2, long[] z2, long[] x3, long[] z3, long[] x, long[] z, long[] xprime, long[] zprime, long[] qmqp) {
        long[] origx = Arrays.copyOf(x, 10);
        long[] zzz = new long[19];
        long[] xx = new long[19];
        long[] zz = new long[19];
        long[] xxprime = new long[19];
        long[] zzprime = new long[19];
        long[] zzzprime = new long[19];
        long[] xxxprime = new long[19];
        Curve25519.sum(x, z);
        Curve25519.sub(z, origx);
        long[] origxprime = Arrays.copyOf(xprime, 10);
        Curve25519.sum(xprime, zprime);
        Curve25519.sub(zprime, origxprime);
        Curve25519.product(xxprime, xprime, z);
        Curve25519.product(zzprime, x, zprime);
        Curve25519.reduceDegree(xxprime);
        Curve25519.reduceCoefficients(xxprime);
        Curve25519.reduceDegree(zzprime);
        Curve25519.reduceCoefficients(zzprime);
        System.arraycopy(xxprime, 0, origxprime, 0, 10);
        Curve25519.sum(xxprime, zzprime);
        Curve25519.sub(zzprime, origxprime);
        Curve25519.square(xxxprime, xxprime);
        Curve25519.square(zzzprime, zzprime);
        Curve25519.product(zzprime, zzzprime, qmqp);
        Curve25519.reduceDegree(zzprime);
        Curve25519.reduceCoefficients(zzprime);
        System.arraycopy(xxxprime, 0, x3, 0, 10);
        System.arraycopy(zzprime, 0, z3, 0, 10);
        Curve25519.square(xx, x);
        Curve25519.square(zz, z);
        Curve25519.product(x2, xx, zz);
        Curve25519.reduceDegree(x2);
        Curve25519.reduceCoefficients(x2);
        Curve25519.sub(zz, xx);
        Arrays.fill(zzz, 10, zzz.length - 1, 0L);
        Curve25519.scalarProduct(zzz, zz, 121665L);
        Curve25519.reduceCoefficients(zzz);
        Curve25519.sum(zzz, xx);
        Curve25519.product(z2, zz, zzz);
        Curve25519.reduceDegree(z2);
        Curve25519.reduceCoefficients(z2);
    }

    static void swapConditional(long[] a, long[] b, int iswap) {
        int swap = -iswap;
        for (int i = 0; i < 10; ++i) {
            int x = swap & ((int)a[i] ^ (int)b[i]);
            a[i] = (int)a[i] ^ x;
            b[i] = (int)b[i] ^ x;
        }
    }

    static void copyConditional(long[] a, long[] b, int icopy) {
        int copy = -icopy;
        for (int i = 0; i < 10; ++i) {
            int x = copy & ((int)a[i] ^ (int)b[i]);
            a[i] = (int)a[i] ^ x;
        }
    }

    private static void curveMult(long[] resultx, long[] resultz, byte[] n, long[] q) {
        long[] nqpqx = new long[19];
        long[] nqpqz = new long[19];
        nqpqz[0] = 1L;
        long[] nqx = new long[19];
        nqx[0] = 1L;
        long[] nqz = new long[19];
        long[] nqpqx2 = new long[19];
        long[] nqpqz2 = new long[19];
        nqpqz2[0] = 1L;
        long[] nqx2 = new long[19];
        long[] nqz2 = new long[19];
        nqz2[0] = 1L;
        long[] t = null;
        System.arraycopy(q, 0, nqpqx, 0, 10);
        for (int i = 0; i < 32; ++i) {
            int b = n[32 - i - 1] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                int bit = b >> 7 - j & 1;
                Curve25519.swapConditional(nqx, nqpqx, bit);
                Curve25519.swapConditional(nqz, nqpqz, bit);
                Curve25519.monty(nqx2, nqz2, nqpqx2, nqpqz2, nqx, nqz, nqpqx, nqpqz, q);
                Curve25519.swapConditional(nqx2, nqpqx2, bit);
                Curve25519.swapConditional(nqz2, nqpqz2, bit);
                t = nqx;
                nqx = nqx2;
                nqx2 = t;
                t = nqz;
                nqz = nqz2;
                nqz2 = t;
                t = nqpqx;
                nqpqx = nqpqx2;
                nqpqx2 = t;
                t = nqpqz;
                nqpqz = nqpqz2;
                nqpqz2 = t;
            }
        }
        System.arraycopy(nqx, 0, resultx, 0, 10);
        System.arraycopy(nqz, 0, resultz, 0, 10);
    }

    static void curveRecip(long[] out, long[] z) {
        int i;
        long[] z2 = new long[10];
        long[] z9 = new long[10];
        long[] z11 = new long[10];
        long[] z2To5Minus1 = new long[10];
        long[] z2To10Minus1 = new long[10];
        long[] z2To20Minus1 = new long[10];
        long[] z2To50Minus1 = new long[10];
        long[] z2To100Minus1 = new long[10];
        long[] t0 = new long[10];
        long[] t1 = new long[10];
        Curve25519.square(z2, z);
        Curve25519.square(t1, z2);
        Curve25519.square(t0, t1);
        Curve25519.mult(z9, t0, z);
        Curve25519.mult(z11, z9, z2);
        Curve25519.square(t0, z11);
        Curve25519.mult(z2To5Minus1, t0, z9);
        Curve25519.square(t0, z2To5Minus1);
        Curve25519.square(t1, t0);
        Curve25519.square(t0, t1);
        Curve25519.square(t1, t0);
        Curve25519.square(t0, t1);
        Curve25519.mult(z2To10Minus1, t0, z2To5Minus1);
        Curve25519.square(t0, z2To10Minus1);
        Curve25519.square(t1, t0);
        for (i = 2; i < 10; i += 2) {
            Curve25519.square(t0, t1);
            Curve25519.square(t1, t0);
        }
        Curve25519.mult(z2To20Minus1, t1, z2To10Minus1);
        Curve25519.square(t0, z2To20Minus1);
        Curve25519.square(t1, t0);
        for (i = 2; i < 20; i += 2) {
            Curve25519.square(t0, t1);
            Curve25519.square(t1, t0);
        }
        Curve25519.mult(t0, t1, z2To20Minus1);
        Curve25519.square(t1, t0);
        Curve25519.square(t0, t1);
        for (i = 2; i < 10; i += 2) {
            Curve25519.square(t1, t0);
            Curve25519.square(t0, t1);
        }
        Curve25519.mult(z2To50Minus1, t0, z2To10Minus1);
        Curve25519.square(t0, z2To50Minus1);
        Curve25519.square(t1, t0);
        for (i = 2; i < 50; i += 2) {
            Curve25519.square(t0, t1);
            Curve25519.square(t1, t0);
        }
        Curve25519.mult(z2To100Minus1, t1, z2To50Minus1);
        Curve25519.square(t1, z2To100Minus1);
        Curve25519.square(t0, t1);
        for (i = 2; i < 100; i += 2) {
            Curve25519.square(t1, t0);
            Curve25519.square(t0, t1);
        }
        Curve25519.mult(t1, t0, z2To100Minus1);
        Curve25519.square(t0, t1);
        Curve25519.square(t1, t0);
        for (i = 2; i < 50; i += 2) {
            Curve25519.square(t0, t1);
            Curve25519.square(t1, t0);
        }
        Curve25519.mult(t0, t1, z2To50Minus1);
        Curve25519.square(t1, t0);
        Curve25519.square(t0, t1);
        Curve25519.square(t1, t0);
        Curve25519.square(t0, t1);
        Curve25519.square(t1, t0);
        Curve25519.mult(out, t1, z11);
    }

    public static byte[] generatePrivateKey() {
        byte[] privateKey = Random.randBytes(32);
        privateKey[0] = (byte)(privateKey[0] | 7);
        privateKey[31] = (byte)(privateKey[31] & 0x3F);
        privateKey[31] = (byte)(privateKey[31] | 0x80);
        return privateKey;
    }

    public static byte[] x25519(byte[] privateKey, byte[] peersPublicValue) {
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Private key must have 32 bytes.");
        }
        if (peersPublicValue.length != 32) {
            throw new IllegalArgumentException("Peer's public key must have 32 bytes.");
        }
        long[] x = new long[10];
        long[] z = new long[11];
        long[] zmone = new long[10];
        byte[] e = Arrays.copyOf(privateKey, 32);
        e[0] = (byte)(e[0] & 0xF8);
        e[31] = (byte)(e[31] & 0x7F);
        e[31] = (byte)(e[31] | 0x40);
        long[] bp = Curve25519.expand(peersPublicValue);
        Curve25519.curveMult(x, z, e, bp);
        Curve25519.curveRecip(zmone, z);
        Curve25519.mult(z, x, zmone);
        return Curve25519.contract(z);
    }

    public static byte[] x25519PublicFromPrivate(byte[] privateKey) {
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Private key must have 32 bytes.");
        }
        byte[] base = new byte[32];
        base[0] = 9;
        return Curve25519.x25519(privateKey, base);
    }
}

