/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.security.GeneralSecurityException;

public final class Bytes {
    public static final boolean equal(byte[] x, byte[] y) {
        if (x == null || y == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < x.length; ++i) {
            res |= x[i] ^ y[i];
        }
        return res == 0;
    }

    public static byte[] concat(byte[] ... chunks) throws GeneralSecurityException {
        int length = 0;
        for (byte[] chunk : chunks) {
            if (length > Integer.MAX_VALUE - chunk.length) {
                throw new GeneralSecurityException("exceeded size limit");
            }
            length += chunk.length;
        }
        byte[] res = new byte[length];
        int pos = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, res, pos, chunk.length);
            pos += chunk.length;
        }
        return res;
    }

    public static byte[] intToByteArray(int capacity, int value) {
        byte[] result = new byte[capacity];
        for (int i = 0; i < capacity; ++i) {
            result[i] = (byte)(value >> 8 * i & 0xFF);
        }
        return result;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return Bytes.byteArrayToInt(bytes, bytes.length);
    }

    public static int byteArrayToInt(byte[] bytes, int length) {
        return Bytes.byteArrayToInt(bytes, 0, length);
    }

    public static int byteArrayToInt(byte[] bytes, int offset, int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value += (bytes[i + offset] & 0xFF) << i * 8;
        }
        return value;
    }
}

