/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.StreamSegmentDecrypter;
import com.google.crypto.tink.subtle.StreamSegmentEncrypter;
import com.google.crypto.tink.subtle.StreamingAeadDecryptingChannel;
import com.google.crypto.tink.subtle.StreamingAeadEncryptingChannel;
import com.google.crypto.tink.subtle.StreamingAeadSeekableDecryptingChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@Alpha
public final class AesGcmHkdfStreaming
implements StreamingAead {
    private static final int NONCE_SIZE_IN_BYTES = 12;
    private static final int NONCE_PREFIX_IN_BYTES = 7;
    private static final int TAG_SIZE_IN_BYTES = 16;
    private static final String MAC_ALGORITHM = "HMACSHA256";
    private int keySizeInBits;
    private int ciphertextSegmentSize;
    private int plaintextSegmentSize;
    private int firstSegmentOffset;
    private byte[] ikm;

    public AesGcmHkdfStreaming(byte[] ikm, int keySizeInBits, int ciphertextSegmentSize, int firstSegmentOffset) throws InvalidAlgorithmParameterException {
        boolean isValidKeySize;
        if (ikm.length < 16) {
            throw new InvalidAlgorithmParameterException("ikm to short");
        }
        boolean bl = isValidKeySize = keySizeInBits == 128 || keySizeInBits == 192 || keySizeInBits == 256;
        if (!isValidKeySize) {
            throw new InvalidAlgorithmParameterException("Invalid key size");
        }
        if (ciphertextSegmentSize <= firstSegmentOffset + this.headerLength() + 16) {
            throw new InvalidAlgorithmParameterException("ciphertextSegmentSize too small");
        }
        this.ikm = Arrays.copyOf(ikm, ikm.length);
        this.keySizeInBits = keySizeInBits;
        this.ciphertextSegmentSize = ciphertextSegmentSize;
        this.firstSegmentOffset = firstSegmentOffset;
        this.plaintextSegmentSize = ciphertextSegmentSize - 16;
    }

    public int getFirstSegmentOffset() {
        return this.firstSegmentOffset;
    }

    private int headerLength() {
        return 1 + this.keySizeInBits / 8 + 7;
    }

    private int ciphertextOffset() {
        return this.headerLength() + this.firstSegmentOffset;
    }

    private int ciphertextOverhead() {
        return 16;
    }

    public long expectedCiphertextSize(long plaintextSize) {
        long offset = this.ciphertextOffset();
        long fullSegments = (plaintextSize + offset) / (long)this.plaintextSegmentSize;
        long ciphertextSize = fullSegments * (long)this.ciphertextSegmentSize;
        long lastSegmentSize = (plaintextSize + offset) % (long)this.plaintextSegmentSize;
        if (lastSegmentSize > 0L) {
            ciphertextSize += lastSegmentSize + 16L;
        }
        return ciphertextSize;
    }

    private static Cipher cipherInstance() throws GeneralSecurityException {
        return EngineFactory.CIPHER.getInstance("AES/GCM/NoPadding");
    }

    private byte[] randomSalt() {
        return Random.randBytes(this.keySizeInBits / 8);
    }

    public int getCiphertextSegmentSize() {
        return this.ciphertextSegmentSize;
    }

    private GCMParameterSpec paramsForSegment(byte[] prefix, int segmentNr, boolean last) {
        ByteBuffer nonce = ByteBuffer.allocate(12);
        nonce.order(ByteOrder.BIG_ENDIAN);
        nonce.put(prefix);
        nonce.putInt(segmentNr);
        nonce.put((byte)(last ? 1 : 0));
        return new GCMParameterSpec(128, nonce.array());
    }

    private byte[] randomNonce() {
        return Random.randBytes(7);
    }

    private SecretKeySpec deriveKeySpec(byte[] salt, byte[] aad) throws GeneralSecurityException {
        byte[] key = Hkdf.computeHkdf(MAC_ALGORITHM, this.ikm, salt, aad, this.keySizeInBits / 8);
        return new SecretKeySpec(key, "AES");
    }

    @Override
    public WritableByteChannel newEncryptingChannel(WritableByteChannel ciphertextChannel, byte[] associatedData) throws GeneralSecurityException, IOException {
        AesGcmHkdfStreamEncrypter encrypter = new AesGcmHkdfStreamEncrypter(associatedData);
        return new StreamingAeadEncryptingChannel(encrypter, ciphertextChannel, this.plaintextSegmentSize, this.ciphertextSegmentSize, this.ciphertextOffset());
    }

    @Override
    public ReadableByteChannel newDecryptingChannel(ReadableByteChannel ciphertextChannel, byte[] associatedData) throws GeneralSecurityException, IOException {
        return new StreamingAeadDecryptingChannel(new AesGcmHkdfStreamDecrypter(), ciphertextChannel, associatedData, this.plaintextSegmentSize, this.ciphertextSegmentSize, this.ciphertextOffset(), this.headerLength());
    }

    @Override
    public SeekableByteChannel newSeekableDecryptingChannel(SeekableByteChannel ciphertextSource, byte[] associatedData) throws GeneralSecurityException, IOException {
        return new StreamingAeadSeekableDecryptingChannel(new AesGcmHkdfStreamDecrypter(), ciphertextSource, associatedData, this.plaintextSegmentSize, this.ciphertextSegmentSize, this.ciphertextOffset(), this.ciphertextOverhead(), this.headerLength());
    }

    class AesGcmHkdfStreamDecrypter
    implements StreamSegmentDecrypter {
        private SecretKeySpec keySpec;
        private Cipher cipher;
        private byte[] noncePrefix;

        AesGcmHkdfStreamDecrypter() {
        }

        @Override
        public synchronized void init(ByteBuffer header, byte[] aad) throws GeneralSecurityException {
            if (header.remaining() != AesGcmHkdfStreaming.this.headerLength()) {
                throw new InvalidAlgorithmParameterException("Invalid header length");
            }
            byte firstByte = header.get();
            if (firstByte != AesGcmHkdfStreaming.this.headerLength()) {
                throw new GeneralSecurityException("Invalid ciphertext");
            }
            this.noncePrefix = new byte[7];
            byte[] salt = new byte[AesGcmHkdfStreaming.this.keySizeInBits / 8];
            header.get(salt);
            header.get(this.noncePrefix);
            this.keySpec = AesGcmHkdfStreaming.this.deriveKeySpec(salt, aad);
            this.cipher = AesGcmHkdfStreaming.cipherInstance();
        }

        @Override
        public synchronized void decryptSegment(ByteBuffer ciphertext, int segmentNr, boolean isLastSegment, ByteBuffer plaintext) throws GeneralSecurityException {
            GCMParameterSpec params = AesGcmHkdfStreaming.this.paramsForSegment(this.noncePrefix, segmentNr, isLastSegment);
            this.cipher.init(2, (Key)this.keySpec, params);
            this.cipher.doFinal(ciphertext, plaintext);
        }
    }

    class AesGcmHkdfStreamEncrypter
    implements StreamSegmentEncrypter {
        private final SecretKeySpec keySpec;
        private final Cipher cipher = AesGcmHkdfStreaming.access$000();
        private final byte[] noncePrefix;
        private ByteBuffer header;
        private int encryptedSegments = 0;

        public AesGcmHkdfStreamEncrypter(byte[] aad) throws GeneralSecurityException {
            byte[] salt = AesGcmHkdfStreaming.this.randomSalt();
            this.noncePrefix = AesGcmHkdfStreaming.this.randomNonce();
            this.header = ByteBuffer.allocate(AesGcmHkdfStreaming.this.headerLength());
            this.header.put((byte)AesGcmHkdfStreaming.this.headerLength());
            this.header.put(salt);
            this.header.put(this.noncePrefix);
            this.header.flip();
            this.keySpec = AesGcmHkdfStreaming.this.deriveKeySpec(salt, aad);
        }

        @Override
        public ByteBuffer getHeader() {
            return this.header.asReadOnlyBuffer();
        }

        @Override
        public synchronized void encryptSegment(ByteBuffer plaintext, boolean isLastSegment, ByteBuffer ciphertext) throws GeneralSecurityException {
            this.cipher.init(1, (Key)this.keySpec, AesGcmHkdfStreaming.this.paramsForSegment(this.noncePrefix, this.encryptedSegments, isLastSegment));
            ++this.encryptedSegments;
            this.cipher.doFinal(plaintext, ciphertext);
        }

        @Override
        public synchronized void encryptSegment(ByteBuffer part1, ByteBuffer part2, boolean isLastSegment, ByteBuffer ciphertext) throws GeneralSecurityException {
            this.cipher.init(1, (Key)this.keySpec, AesGcmHkdfStreaming.this.paramsForSegment(this.noncePrefix, this.encryptedSegments, isLastSegment));
            ++this.encryptedSegments;
            this.cipher.update(part1, ciphertext);
            this.cipher.doFinal(part2, ciphertext);
        }

        @Override
        public int getEncryptedSegments() {
            return this.encryptedSegments;
        }
    }
}

