/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKey;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKeyFormat;
import com.google.crypto.tink.proto.AesCtrHmacStreamingParams;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesCtrHmacStreaming;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesCtrHmacStreamingKeyManager
implements KeyManager<StreamingAead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrHmacStreamingKey";

    AesCtrHmacStreamingKeyManager() {
    }

    @Override
    public StreamingAead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesCtrHmacStreamingKey keyProto = AesCtrHmacStreamingKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected AesCtrHmacStreamingKey proto", e);
        }
    }

    @Override
    public StreamingAead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesCtrHmacStreamingKey)) {
            throw new GeneralSecurityException("expected AesCtrHmacStreamingKey proto");
        }
        AesCtrHmacStreamingKey keyProto = (AesCtrHmacStreamingKey)key;
        this.validate(keyProto);
        return new AesCtrHmacStreaming(keyProto.getKeyValue().toByteArray(), keyProto.getParams().getDerivedKeySize(), keyProto.getParams().getHmacParams().getTagSize(), keyProto.getParams().getCiphertextSegmentSize(), 0);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesCtrHmacStreamingKeyFormat format = AesCtrHmacStreamingKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesCtrHmacStreamingKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesCtrHmacStreamingKeyFormat)) {
            throw new GeneralSecurityException("expected AesCtrHmacStreamingKeyFormat proto");
        }
        AesCtrHmacStreamingKeyFormat format = (AesCtrHmacStreamingKeyFormat)keyFormat;
        this.validate(format);
        return AesCtrHmacStreamingKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesCtrHmacStreamingKey key = (AesCtrHmacStreamingKey)this.newKey(serializedKeyFormat);
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesCtrHmacStreamingKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key_value must have at least 16 bytes");
        }
        if (key.getKeyValue().size() < key.getParams().getDerivedKeySize()) {
            throw new GeneralSecurityException("key_value must have at least as many bits as derived keys");
        }
        this.validate(key.getParams());
    }

    private void validate(AesCtrHmacStreamingKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key_size must be at least 16 bytes");
        }
        this.validate(format.getParams());
    }

    private void validate(AesCtrHmacStreamingParams params) throws GeneralSecurityException {
        Validators.validateAesKeySize(params.getDerivedKeySize());
        if (params.getHkdfHashType() != HashType.SHA256) {
            throw new GeneralSecurityException("Only hkdf_hash_type equal to SHA256 is supported");
        }
        if (params.getHmacParams().getHash() != HashType.SHA256) {
            throw new GeneralSecurityException("Only hmac_params.hash equal to SHA256 is supported");
        }
        if (params.getCiphertextSegmentSize() < params.getDerivedKeySize() + params.getHmacParams().getTagSize() + 8) {
            throw new GeneralSecurityException("ciphertext_segment_size must be at least (derived_key_size + tag_size + 8)");
        }
    }
}

