/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.proto.EcdsaKeyFormat;
import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaSignatureEncoding;
import com.google.crypto.tink.proto.EllipticCurveType;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyTemplate;

public final class SignatureKeyTemplates {
    public static final KeyTemplate ECDSA_P256 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA256, EllipticCurveType.NIST_P256, EcdsaSignatureEncoding.DER);
    public static final KeyTemplate ECDSA_P384 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P384, EcdsaSignatureEncoding.DER);
    public static final KeyTemplate ECDSA_P521 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P521, EcdsaSignatureEncoding.DER);
    @Alpha
    public static final KeyTemplate ED25519 = (KeyTemplate)KeyTemplate.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.Ed25519PrivateKey").build();

    public static KeyTemplate createEcdsaKeyTemplate(HashType hashType, EllipticCurveType curve, EcdsaSignatureEncoding encoding) {
        EcdsaParams params = (EcdsaParams)EcdsaParams.newBuilder().setHashType(hashType).setCurve(curve).setEncoding(encoding).build();
        EcdsaKeyFormat format = (EcdsaKeyFormat)EcdsaKeyFormat.newBuilder().setParams(params).build();
        return (KeyTemplate)KeyTemplate.newBuilder().setValue(format.toByteString()).setTypeUrl("type.googleapis.com/google.crypto.tink.EcdsaPrivateKey").build();
    }
}

