/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.Config;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.proto.RegistryConfig;
import com.google.crypto.tink.signature.SignatureCatalogue;
import java.security.GeneralSecurityException;

public final class SignatureConfig {
    public static final String ECDSA_PUBLIC_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPublicKey";
    public static final String ECDSA_PRIVATE_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPrivateKey";
    @Alpha
    public static final String ED25519_PUBLIC_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PublicKey";
    @Alpha
    public static final String ED25519_PRIVATE_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey";
    private static final String CATALOGUE_NAME = "TinkSignature";
    public static final RegistryConfig TINK_1_0_0 = (RegistryConfig)RegistryConfig.newBuilder().setConfigName("TINK_SIGNATURE_SIGN_1_0_0").addEntry(Config.getTinkKeyTypeEntry("TinkSignature", "PublicKeySign", "EcdsaPrivateKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkSignature", "PublicKeySign", "Ed25519PrivateKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkSignature", "PublicKeyVerify", "EcdsaPublicKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkSignature", "PublicKeyVerify", "Ed25519PublicKey", 0, true)).build();

    public static void init() throws GeneralSecurityException {
        Registry.addCatalogue(CATALOGUE_NAME, new SignatureCatalogue());
    }

    static {
        try {
            SignatureConfig.init();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

