/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.signature.EcdsaSignKeyManager;
import com.google.crypto.tink.signature.EcdsaVerifyKeyManager;
import com.google.crypto.tink.signature.Ed25519PrivateKeyManager;
import com.google.crypto.tink.signature.Ed25519PublicKeyManager;
import java.security.GeneralSecurityException;

class SignatureCatalogue
implements Catalogue {
    @Override
    public KeyManager getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<Object> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "publickeysign": {
                keyManager = this.publicKeySignKeyManager(typeUrl);
                break;
            }
            case "publickeyverify": {
                keyManager = this.publicKeyVerifyKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<PublicKeySign> publicKeySignKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EcdsaPrivateKey": {
                return new EcdsaSignKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey": {
                return new Ed25519PrivateKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'PublicKeySign' with key type '%s'.", typeUrl));
    }

    private KeyManager<PublicKeyVerify> publicKeyVerifyKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EcdsaPublicKey": {
                return new EcdsaVerifyKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.Ed25519PublicKey": {
                return new Ed25519PublicKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'PublicKeyVerify' with key type '%s'.", typeUrl));
    }
}

