/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.proto.Ed25519PrivateKey;
import com.google.crypto.tink.proto.Ed25519PublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class Ed25519PrivateKeyManager
implements PrivateKeyManager<PublicKeySign> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey";
    private static final int VERSION = 0;

    Ed25519PrivateKeyManager() {
    }

    @Override
    public PublicKeySign getPrimitive(ByteString serialized) throws GeneralSecurityException {
        try {
            Ed25519PrivateKey keyProto = Ed25519PrivateKey.parseFrom(serialized);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid Ed25519 private key", e);
        }
    }

    @Override
    public PublicKeySign getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof Ed25519PrivateKey)) {
            throw new GeneralSecurityException("expected Ed25519PrivateKey proto");
        }
        Ed25519PrivateKey keyProto = (Ed25519PrivateKey)key;
        this.validateKey(keyProto);
        return new Ed25519Sign(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public MessageLite newKey(ByteString unused) throws GeneralSecurityException {
        return this.newKey();
    }

    @Override
    public MessageLite newKey(MessageLite unused) throws GeneralSecurityException {
        return this.newKey();
    }

    @Override
    public KeyData newKeyData(ByteString unused) throws GeneralSecurityException {
        Ed25519PrivateKey key = this.newKey();
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            Ed25519PrivateKey privKeyProto = Ed25519PrivateKey.parseFrom(serializedKey);
            return (KeyData)KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.Ed25519PublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized Ed25519PrivateKey proto", e);
        }
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private Ed25519PrivateKey newKey() throws GeneralSecurityException {
        Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPair();
        Ed25519PublicKey publicKey = (Ed25519PublicKey)Ed25519PublicKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPublicKey())).build();
        return (Ed25519PrivateKey)Ed25519PrivateKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPrivateKey())).setPublicKey(publicKey).build();
    }

    private void validateKey(Ed25519PrivateKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 private key: incorrect key length");
        }
    }
}

