/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.proto.EcdsaPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.SigUtil;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;

class EcdsaVerifyKeyManager
implements KeyManager<PublicKeyVerify> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPublicKey";
    private static final int VERSION = 0;

    EcdsaVerifyKeyManager() {
    }

    @Override
    public PublicKeyVerify getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EcdsaPublicKey pubKey = EcdsaPublicKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)pubKey);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EcdsaPublicKey proto", e);
        }
    }

    @Override
    public PublicKeyVerify getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof EcdsaPublicKey)) {
            throw new GeneralSecurityException("expected EcdsaPublicKey proto");
        }
        EcdsaPublicKey keyProto = (EcdsaPublicKey)key;
        this.validateKey(keyProto);
        ECPublicKey publicKey = EllipticCurves.getEcPublicKey(SigUtil.toCurveType(keyProto.getParams().getCurve()), keyProto.getX().toByteArray(), keyProto.getY().toByteArray());
        return new EcdsaVerifyJce(publicKey, SigUtil.toEcdsaAlgo(keyProto.getParams().getHashType()));
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public KeyData newKeyData(ByteString serialized) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validateKey(EcdsaPublicKey pubKey) throws GeneralSecurityException {
        Validators.validateVersion(pubKey.getVersion(), 0);
        SigUtil.validateEcdsaParams(pubKey.getParams());
    }
}

