/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.mac.HmacKeyManager;
import java.security.GeneralSecurityException;

class MacCatalogue
implements Catalogue {
    @Override
    public KeyManager getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<Mac> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "mac": {
                keyManager = this.macKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<Mac> macKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.HmacKey": {
                return new HmacKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'Mac' with key type '%s'.", typeUrl));
    }
}

