/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Config;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.hybrid.HybridCatalogue;
import com.google.crypto.tink.proto.RegistryConfig;
import java.security.GeneralSecurityException;

public final class HybridConfig {
    public static final String ECIES_AEAD_HKDF_PUBLIC_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";
    public static final String ECIES_AEAD_HKDF_PRIVATE_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey";
    private static final String CATALOGUE_NAME = "TinkHybrid";
    public static final RegistryConfig TINK_1_0_0 = (RegistryConfig)((RegistryConfig.Builder)RegistryConfig.newBuilder().mergeFrom(AeadConfig.TINK_1_0_0)).addEntry(Config.getTinkKeyTypeEntry("TinkHybrid", "HybridDecrypt", "EciesAeadHkdfPrivateKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkHybrid", "HybridEncrypt", "EciesAeadHkdfPublicKey", 0, true)).setConfigName("TINK_HYBRID_1_0_0").build();

    public static void init() throws GeneralSecurityException {
        Registry.addCatalogue(CATALOGUE_NAME, new HybridCatalogue());
        AeadConfig.init();
    }

    static {
        try {
            HybridConfig.init();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

