/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Config;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AeadCatalogue;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.mac.MacConfig;
import com.google.crypto.tink.proto.RegistryConfig;
import java.security.GeneralSecurityException;

public final class AeadConfig {
    public static final String AES_CTR_HMAC_AEAD_TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey";
    public static final String AES_GCM_TYPE_URL = "type.googleapis.com/google.crypto.tink.AesGcmKey";
    public static final String AES_EAX_TYPE_URL = "type.googleapis.com/google.crypto.tink.AesEaxKey";
    public static final String KMS_AEAD_TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsAeadKey";
    public static final String KMS_ENVELOPE_AEAD_TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey";
    @Alpha
    public static final String CHACHA20_POLY1305_TYPE_URL = "type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key";
    private static final String CATALOGUE_NAME = "TinkAead";
    private static final String PRIMITIVE_NAME = "Aead";
    public static final RegistryConfig TINK_1_0_0 = (RegistryConfig)((RegistryConfig.Builder)RegistryConfig.newBuilder().mergeFrom(MacConfig.TINK_1_0_0)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "AesCtrHmacAeadKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "AesEaxKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "AesGcmKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "ChaCha20Poly1305Key", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "KmsAeadKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkAead", "Aead", "KmsEnvelopeAeadKey", 0, true)).setConfigName("TINK_AEAD_1_0_0").build();

    public static void init() throws GeneralSecurityException {
        Registry.addCatalogue(CATALOGUE_NAME, new AeadCatalogue());
        MacConfig.init();
    }

    @Deprecated
    public static void registerStandardKeyTypes() throws GeneralSecurityException {
        Config.register(TINK_1_0_0);
    }

    static {
        try {
            AeadConfig.init();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

