/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import java.security.GeneralSecurityException;

class Util {
    Util() {
    }

    public static KeysetInfo getKeysetInfo(Keyset keyset) {
        KeysetInfo.Builder info = KeysetInfo.newBuilder().setPrimaryKeyId(keyset.getPrimaryKeyId());
        for (Keyset.Key key : keyset.getKeyList()) {
            info.addKeyInfo(Util.getKeyInfo(key));
        }
        return (KeysetInfo)info.build();
    }

    public static KeysetInfo.KeyInfo getKeyInfo(Keyset.Key key) {
        return (KeysetInfo.KeyInfo)KeysetInfo.KeyInfo.newBuilder().setTypeUrl(key.getKeyData().getTypeUrl()).setStatus(key.getStatus()).setOutputPrefixType(key.getOutputPrefixType()).setKeyId(key.getKeyId()).build();
    }

    public static void validateKey(Keyset.Key key) throws GeneralSecurityException {
        if (!key.hasKeyData()) {
            throw new GeneralSecurityException(String.format("key %d has no key data", key.getKeyId()));
        }
        if (key.getOutputPrefixType() == OutputPrefixType.UNKNOWN_PREFIX) {
            throw new GeneralSecurityException(String.format("key %d has unknown prefix", key.getKeyId()));
        }
        if (key.getStatus() == KeyStatusType.UNKNOWN_STATUS) {
            throw new GeneralSecurityException(String.format("key %d has unknown status", key.getKeyId()));
        }
    }

    public static void validateKeyset(Keyset keyset) throws GeneralSecurityException {
        if (keyset.getKeyCount() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
        int primaryKeyId = keyset.getPrimaryKeyId();
        boolean hasPrimaryKey = false;
        boolean containsOnlyPublicKeyMaterial = true;
        for (Keyset.Key key : keyset.getKeyList()) {
            Util.validateKey(key);
            if (key.getStatus() == KeyStatusType.ENABLED && key.getKeyId() == primaryKeyId) {
                if (hasPrimaryKey) {
                    throw new GeneralSecurityException("keyset contains multiple primary keys");
                }
                hasPrimaryKey = true;
            }
            if (key.getKeyData().getKeyMaterialType() == KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC) continue;
            containsOnlyPublicKeyMaterial = false;
        }
        if (!hasPrimaryKey && !containsOnlyPublicKeyMaterial) {
            throw new GeneralSecurityException("keyset doesn't contain a valid primary key");
        }
    }
}

