/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.Util;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.Keyset;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public final class Registry {
    private static final Logger logger = Logger.getLogger(Registry.class.getName());
    private static final ConcurrentMap<String, KeyManager> keyManagerMap = new ConcurrentHashMap<String, KeyManager>();
    private static final ConcurrentMap<String, Boolean> newKeyAllowedMap = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, Catalogue> catalogueMap = new ConcurrentHashMap<String, Catalogue>();

    static synchronized void reset() {
        keyManagerMap.clear();
        newKeyAllowedMap.clear();
        catalogueMap.clear();
    }

    public static synchronized void addCatalogue(String catalogueName, Catalogue catalogue) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        if (catalogue == null) {
            throw new IllegalArgumentException("catalogue must be non-null.");
        }
        if (catalogueMap.containsKey(catalogueName.toLowerCase())) {
            Catalogue existing = (Catalogue)catalogueMap.get(catalogueName.toLowerCase());
            if (!catalogue.getClass().equals(existing.getClass())) {
                logger.warning("Attempted overwrite of a catalogueName catalogue for name " + catalogueName);
                throw new GeneralSecurityException("catalogue for name " + catalogueName + " has been already registered");
            }
        }
        catalogueMap.put(catalogueName.toLowerCase(), catalogue);
    }

    public static Catalogue getCatalogue(String catalogueName) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        Catalogue catalogue = (Catalogue)catalogueMap.get(catalogueName.toLowerCase());
        if (catalogue == null) {
            String error = String.format("no catalogue found for %s. ", catalogueName);
            if (catalogueName.toLowerCase().startsWith("tinkaead")) {
                error = error + "Maybe call AeadConfig.init().";
            } else if (catalogueName.toLowerCase().startsWith("tinkhybrid")) {
                error = error + "Maybe call HybridConfig.init().";
            } else if (catalogueName.toLowerCase().startsWith("tinkmac")) {
                error = error + "Maybe call MacConfig.init().";
            } else if (catalogueName.toLowerCase().startsWith("tinksignature")) {
                error = error + "Maybe call SignatureConfig.init().";
            } else if (catalogueName.toLowerCase().startsWith("tink")) {
                error = error + "Maybe call TinkConfig.init().";
            }
            throw new GeneralSecurityException(error);
        }
        return catalogue;
    }

    public static <P> void registerKeyManager(String typeUrl, KeyManager<P> manager) throws GeneralSecurityException {
        Registry.registerKeyManager(typeUrl, manager, true);
    }

    public static synchronized <P> void registerKeyManager(String typeUrl, KeyManager<P> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (keyManagerMap.containsKey(typeUrl)) {
            KeyManager<P> existingManager = Registry.getKeyManager(typeUrl);
            boolean existingNewKeyAllowed = (Boolean)newKeyAllowedMap.get(typeUrl);
            if (!manager.getClass().equals(existingManager.getClass()) || !existingNewKeyAllowed && newKeyAllowed) {
                logger.warning("Attempted overwrite of a registered key manager for key type " + typeUrl);
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", typeUrl, existingManager.getClass().getName(), manager.getClass().getName()));
            }
        }
        keyManagerMap.put(typeUrl, manager);
        newKeyAllowedMap.put(typeUrl, newKeyAllowed);
    }

    public static <P> KeyManager<P> getKeyManager(String typeUrl) throws GeneralSecurityException {
        KeyManager manager = (KeyManager)keyManagerMap.get(typeUrl);
        if (manager == null) {
            throw new GeneralSecurityException("No key manager found for key type: " + typeUrl + ".  Check the configuration of the registry.");
        }
        return manager;
    }

    public static <P> KeyData newKeyData(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKeyData(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    public static <P> MessageLite newKey(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKey(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    public static <P> MessageLite newKey(String typeUrl, MessageLite format) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(typeUrl);
        if (((Boolean)newKeyAllowedMap.get(typeUrl)).booleanValue()) {
            return manager.newKey(format);
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + typeUrl);
    }

    public static <P> KeyData getPublicKeyData(String typeUrl, ByteString serializedPrivateKey) throws GeneralSecurityException {
        PrivateKeyManager manager = (PrivateKeyManager)Registry.getKeyManager(typeUrl);
        return manager.getPublicKeyData(serializedPrivateKey);
    }

    public static <P> P getPrimitive(String typeUrl, MessageLite key) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(typeUrl);
        return manager.getPrimitive(key);
    }

    public static <P> P getPrimitive(String typeUrl, ByteString serialized) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(typeUrl);
        return manager.getPrimitive(serialized);
    }

    public static <P> P getPrimitive(String typeUrl, byte[] serialized) throws GeneralSecurityException {
        return Registry.getPrimitive(typeUrl, ByteString.copyFrom((byte[])serialized));
    }

    public static <P> P getPrimitive(KeyData keyData) throws GeneralSecurityException {
        return Registry.getPrimitive(keyData.getTypeUrl(), keyData.getValue());
    }

    public static <P> PrimitiveSet<P> getPrimitives(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return Registry.getPrimitives(keysetHandle, null);
    }

    public static <P> PrimitiveSet<P> getPrimitives(KeysetHandle keysetHandle, KeyManager<P> customManager) throws GeneralSecurityException {
        Util.validateKeyset(keysetHandle.getKeyset());
        PrimitiveSet primitives = PrimitiveSet.newPrimitiveSet();
        for (Keyset.Key key : keysetHandle.getKeyset().getKeyList()) {
            if (key.getStatus() != KeyStatusType.ENABLED) continue;
            P primitive = customManager != null && customManager.doesSupport(key.getKeyData().getTypeUrl()) ? customManager.getPrimitive(key.getKeyData().getValue()) : Registry.getPrimitive(key.getKeyData().getTypeUrl(), key.getKeyData().getValue());
            PrimitiveSet.Entry entry = primitives.addPrimitive(primitive, key);
            if (key.getKeyId() != keysetHandle.getKeyset().getPrimaryKeyId()) continue;
            primitives.setPrimary(entry);
        }
        return primitives;
    }
}

