/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.CryptoFormat;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class PrimitiveSet<P> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private ConcurrentMap<String, List<Entry<P>>> primitives = new ConcurrentHashMap<String, List<Entry<P>>>();
    private Entry<P> primary;

    public Entry<P> getPrimary() {
        return this.primary;
    }

    public List<Entry<P>> getRawPrimitives() throws GeneralSecurityException {
        return this.getPrimitive(CryptoFormat.RAW_PREFIX);
    }

    public List<Entry<P>> getPrimitive(byte[] identifier) throws GeneralSecurityException {
        List<Entry<P>> found = (List<Entry<P>>)this.primitives.get(new String(identifier, UTF_8));
        return found != null ? found : Collections.emptyList();
    }

    protected static <P> PrimitiveSet<P> newPrimitiveSet() {
        return new PrimitiveSet<P>();
    }

    protected List<Entry<P>> getPrimitive(Keyset.Key key) throws GeneralSecurityException {
        return this.getPrimitive(CryptoFormat.getOutputPrefix(key));
    }

    protected void setPrimary(Entry<P> primary) {
        this.primary = primary;
    }

    protected Entry<P> addPrimitive(P primitive, Keyset.Key key) throws GeneralSecurityException {
        Entry<P> entry = new Entry<P>(primitive, CryptoFormat.getOutputPrefix(key), key.getStatus(), key.getOutputPrefixType());
        ArrayList<Entry<P>> list = new ArrayList<Entry<P>>();
        list.add(entry);
        String identifier = new String(entry.getIdentifier(), UTF_8);
        List existing = this.primitives.put(identifier, Collections.unmodifiableList(list));
        if (existing != null) {
            ArrayList newList = new ArrayList();
            newList.addAll(existing);
            newList.add(entry);
            this.primitives.put(identifier, Collections.unmodifiableList(newList));
        }
        return entry;
    }

    @Immutable(containerOf={"P"})
    public static final class Entry<P> {
        private final P primitive;
        private final byte[] identifier;
        private final KeyStatusType status;
        private final OutputPrefixType outputPrefixType;

        public Entry(P primitive, byte[] identifier, KeyStatusType status, OutputPrefixType outputPrefixType) {
            this.primitive = primitive;
            this.identifier = Arrays.copyOf(identifier, identifier.length);
            this.status = status;
            this.outputPrefixType = outputPrefixType;
        }

        public P getPrimitive() {
            return this.primitive;
        }

        public KeyStatusType getStatus() {
            return this.status;
        }

        public OutputPrefixType getOutputPrefixType() {
            return this.outputPrefixType;
        }

        public final byte[] getIdentifier() {
            if (this.identifier == null) {
                return null;
            }
            return Arrays.copyOf(this.identifier, this.identifier.length);
        }
    }
}

