/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.annotation.concurrent.GuardedBy;

public final class KeysetManager {
    @GuardedBy(value="this")
    private final Keyset.Builder keysetBuilder;

    private KeysetManager(Keyset.Builder val) {
        this.keysetBuilder = val;
    }

    public static KeysetManager withKeysetHandle(KeysetHandle val) {
        return new KeysetManager((Keyset.Builder)val.getKeyset().toBuilder());
    }

    public static KeysetManager withEmptyKeyset() {
        return new KeysetManager(Keyset.newBuilder());
    }

    @GuardedBy(value="this")
    public synchronized KeysetHandle getKeysetHandle() throws GeneralSecurityException {
        return KeysetHandle.fromKeyset((Keyset)this.keysetBuilder.build());
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager rotate(KeyTemplate keyTemplate) throws GeneralSecurityException {
        Keyset.Key key = this.newKey(keyTemplate);
        this.keysetBuilder.addKey(key).setPrimaryKeyId(key.getKeyId());
        return this;
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager add(KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetBuilder.addKey(this.newKey(keyTemplate));
        return this;
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager promote(int keyId) throws GeneralSecurityException {
        for (int i = 0; i < this.keysetBuilder.getKeyCount(); ++i) {
            Keyset.Key key = this.keysetBuilder.getKey(i);
            if (key.getKeyId() != keyId) continue;
            if (!key.getStatus().equals((Object)KeyStatusType.ENABLED)) {
                throw new GeneralSecurityException("cannot promote key because it's not enabled: " + keyId);
            }
            this.keysetBuilder.setPrimaryKeyId(keyId);
            return this;
        }
        throw new GeneralSecurityException("key not found: " + keyId);
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager enable(int keyId) throws GeneralSecurityException {
        for (int i = 0; i < this.keysetBuilder.getKeyCount(); ++i) {
            Keyset.Key key = this.keysetBuilder.getKey(i);
            if (key.getKeyId() != keyId) continue;
            this.keysetBuilder.setKey(i, (Keyset.Key)((Keyset.Key.Builder)key.toBuilder()).setStatus(KeyStatusType.ENABLED).build());
            return this;
        }
        throw new GeneralSecurityException("key not found: " + keyId);
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager disable(int keyId) throws GeneralSecurityException {
        if (keyId == this.keysetBuilder.getPrimaryKeyId()) {
            throw new GeneralSecurityException("cannot disable the primary key");
        }
        for (int i = 0; i < this.keysetBuilder.getKeyCount(); ++i) {
            Keyset.Key key = this.keysetBuilder.getKey(i);
            if (key.getKeyId() != keyId) continue;
            this.keysetBuilder.setKey(i, (Keyset.Key)((Keyset.Key.Builder)key.toBuilder()).setStatus(KeyStatusType.DISABLED).build());
            return this;
        }
        throw new GeneralSecurityException("key not found: " + keyId);
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager delete(int keyId) throws GeneralSecurityException {
        if (keyId == this.keysetBuilder.getPrimaryKeyId()) {
            throw new GeneralSecurityException("cannot delete the primary key");
        }
        for (int i = 0; i < this.keysetBuilder.getKeyCount(); ++i) {
            Keyset.Key key = this.keysetBuilder.getKey(i);
            if (key.getKeyId() != keyId) continue;
            this.keysetBuilder.removeKey(i);
            return this;
        }
        throw new GeneralSecurityException("key not found: " + keyId);
    }

    @GuardedBy(value="this")
    public synchronized KeysetManager destroy(int keyId) throws GeneralSecurityException {
        if (keyId == this.keysetBuilder.getPrimaryKeyId()) {
            throw new GeneralSecurityException("cannot destroy the primary key");
        }
        for (int i = 0; i < this.keysetBuilder.getKeyCount(); ++i) {
            Keyset.Key key = this.keysetBuilder.getKey(i);
            if (key.getKeyId() != keyId) continue;
            this.keysetBuilder.setKey(i, (Keyset.Key)((Keyset.Key.Builder)key.toBuilder()).setStatus(KeyStatusType.DESTROYED).clearKeyData().build());
            return this;
        }
        throw new GeneralSecurityException("key not found: " + keyId);
    }

    @GuardedBy(value="this")
    private synchronized Keyset.Key newKey(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyData keyData = Registry.newKeyData(keyTemplate);
        int keyId = this.newKeyId();
        OutputPrefixType outputPrefixType = keyTemplate.getOutputPrefixType();
        if (outputPrefixType == OutputPrefixType.UNKNOWN_PREFIX) {
            outputPrefixType = OutputPrefixType.TINK;
        }
        return (Keyset.Key)Keyset.Key.newBuilder().setKeyData(keyData).setKeyId(keyId).setStatus(KeyStatusType.ENABLED).setOutputPrefixType(outputPrefixType).build();
    }

    @GuardedBy(value="this")
    private synchronized int newKeyId() {
        int keyId = KeysetManager.randPositiveInt();
        for (Keyset.Key key : this.keysetBuilder.getKeyList()) {
            if (key.getKeyId() != keyId) continue;
            keyId = KeysetManager.randPositiveInt();
        }
        return keyId;
    }

    private static int randPositiveInt() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] rand = new byte[4];
        int result = 0;
        while (result == 0) {
            secureRandom.nextBytes(rand);
            result = (rand[0] & 0x7F) << 24 | (rand[1] & 0xFF) << 16 | (rand[2] & 0xFF) << 8 | rand[3] & 0xFF;
        }
        return result;
    }
}

