/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Base64;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonKeysetReader
implements KeysetReader {
    private final JSONObject json;
    private boolean urlSafeBase64 = false;

    private JsonKeysetReader(JSONObject input) {
        this.json = input;
    }

    private JsonKeysetReader(String input) {
        try {
            this.json = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static KeysetReader withInputStream(InputStream input) throws IOException {
        return new JsonKeysetReader(JsonKeysetReader.readAll(input));
    }

    public static JsonKeysetReader withJsonObject(JSONObject json) {
        return new JsonKeysetReader(json);
    }

    public static JsonKeysetReader withString(String input) {
        return new JsonKeysetReader(input);
    }

    public static JsonKeysetReader withBytes(byte[] bytes) {
        return new JsonKeysetReader(new String(bytes, StandardCharsets.UTF_8));
    }

    public static JsonKeysetReader withFile(File file) throws IOException {
        return JsonKeysetReader.withPath(file.toPath());
    }

    public static JsonKeysetReader withPath(Path path) throws IOException {
        return new JsonKeysetReader(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
    }

    public JsonKeysetReader withUrlSafeBase64() {
        this.urlSafeBase64 = true;
        return this;
    }

    private static String readAll(InputStream input) throws IOException {
        int count;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((count = input.read(buf)) != -1) {
            result.write(buf, 0, count);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    @Override
    public Keyset read() throws IOException {
        try {
            return this.keysetFromJson(this.json);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        try {
            return this.encryptedKeysetFromJson(this.json);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private Keyset keysetFromJson(JSONObject json) throws JSONException {
        this.validateKeyset(json);
        Keyset.Builder builder = Keyset.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.getInt("primaryKeyId"));
        }
        JSONArray keys = json.getJSONArray("key");
        for (int i = 0; i < keys.length(); ++i) {
            builder.addKey(this.keyFromJson(keys.getJSONObject(i)));
        }
        return (Keyset)builder.build();
    }

    private EncryptedKeyset encryptedKeysetFromJson(JSONObject json) throws JSONException {
        this.validateEncryptedKeyset(json);
        byte[] encryptedKeyset = this.urlSafeBase64 ? Base64.urlSafeDecode(json.getString("encryptedKeyset")) : Base64.decode(json.getString("encryptedKeyset"));
        return (EncryptedKeyset)EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom((byte[])encryptedKeyset)).setKeysetInfo(this.keysetInfoFromJson(json.getJSONObject("keysetInfo"))).build();
    }

    private Keyset.Key keyFromJson(JSONObject json) throws JSONException {
        this.validateKey(json);
        return (Keyset.Key)Keyset.Key.newBuilder().setStatus(this.getStatus(json.getString("status"))).setKeyId(json.getInt("keyId")).setOutputPrefixType(this.getOutputPrefixType(json.getString("outputPrefixType"))).setKeyData(this.keyDataFromJson(json.getJSONObject("keyData"))).build();
    }

    private KeysetInfo keysetInfoFromJson(JSONObject json) throws JSONException {
        KeysetInfo.Builder builder = KeysetInfo.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.getInt("primaryKeyId"));
        }
        if (json.has("keyInfo")) {
            JSONArray keyInfos = json.getJSONArray("keyInfo");
            for (int i = 0; i < keyInfos.length(); ++i) {
                builder.addKeyInfo(this.keyInfoFromJson(keyInfos.getJSONObject(i)));
            }
        }
        return (KeysetInfo)builder.build();
    }

    private KeysetInfo.KeyInfo keyInfoFromJson(JSONObject json) throws JSONException {
        return (KeysetInfo.KeyInfo)KeysetInfo.KeyInfo.newBuilder().setStatus(this.getStatus(json.getString("status"))).setKeyId(json.getInt("keyId")).setOutputPrefixType(this.getOutputPrefixType(json.getString("outputPrefixType"))).setTypeUrl(json.getString("typeUrl")).build();
    }

    private KeyData keyDataFromJson(JSONObject json) throws JSONException {
        this.validateKeyData(json);
        byte[] value = this.urlSafeBase64 ? Base64.urlSafeDecode(json.getString("value")) : Base64.decode(json.getString("value"));
        return (KeyData)KeyData.newBuilder().setTypeUrl(json.getString("typeUrl")).setValue(ByteString.copyFrom((byte[])value)).setKeyMaterialType(this.getKeyMaterialType(json.getString("keyMaterialType"))).build();
    }

    private KeyStatusType getStatus(String status) throws JSONException {
        if (status.equals("ENABLED")) {
            return KeyStatusType.ENABLED;
        }
        if (status.equals("DISABLED")) {
            return KeyStatusType.DISABLED;
        }
        throw new JSONException("unknown status: " + status);
    }

    private OutputPrefixType getOutputPrefixType(String type) throws JSONException {
        if (type.equals("TINK")) {
            return OutputPrefixType.TINK;
        }
        if (type.equals("RAW")) {
            return OutputPrefixType.RAW;
        }
        if (type.equals("LEGACY")) {
            return OutputPrefixType.LEGACY;
        }
        if (type.equals("CRUNCHY")) {
            return OutputPrefixType.CRUNCHY;
        }
        throw new JSONException("unknown output prefix type: " + type);
    }

    private KeyData.KeyMaterialType getKeyMaterialType(String type) throws JSONException {
        if (type.equals("SYMMETRIC")) {
            return KeyData.KeyMaterialType.SYMMETRIC;
        }
        if (type.equals("ASYMMETRIC_PRIVATE")) {
            return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
        }
        if (type.equals("ASYMMETRIC_PUBLIC")) {
            return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
        }
        if (type.equals("REMOTE")) {
            return KeyData.KeyMaterialType.REMOTE;
        }
        throw new JSONException("unknown key material type: " + type);
    }

    private void validateKeyset(JSONObject json) throws JSONException {
        if (!json.has("key") || json.getJSONArray("key").length() == 0) {
            throw new JSONException("invalid keyset");
        }
    }

    private void validateEncryptedKeyset(JSONObject json) throws JSONException {
        if (!json.has("encryptedKeyset")) {
            throw new JSONException("invalid encrypted keyset");
        }
    }

    private void validateKey(JSONObject json) throws JSONException {
        if (!(json.has("keyData") && json.has("status") && json.has("keyId") && json.has("outputPrefixType"))) {
            throw new JSONException("invalid key");
        }
    }

    private void validateKeyData(JSONObject json) throws JSONException {
        if (!(json.has("typeUrl") && json.has("value") && json.has("keyMaterialType"))) {
            throw new JSONException("invalid keyData");
        }
    }
}

