/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SitemapValidator {
    private static Schema sitemapSchema;
    private static Schema sitemapIndexSchema;

    private static synchronized void lazyLoad() {
        if (sitemapSchema != null) {
            return;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            InputStream stream = SitemapValidator.class.getResourceAsStream("sitemap.xsd");
            if (stream == null) {
                throw new RuntimeException("BUG Couldn't load sitemap.xsd");
            }
            StreamSource source = new StreamSource(stream);
            sitemapSchema = factory.newSchema(source);
            stream = SitemapValidator.class.getResourceAsStream("siteindex.xsd");
            if (stream == null) {
                throw new RuntimeException("BUG Couldn't load siteindex.xsd");
            }
            source = new StreamSource(stream);
            sitemapIndexSchema = factory.newSchema(source);
        }
        catch (SAXException e) {
            throw new RuntimeException("BUG", e);
        }
    }

    public static void validateWebSitemap(File sitemap) throws SAXException {
        SitemapValidator.lazyLoad();
        SitemapValidator.validateXml(sitemap, sitemapSchema);
    }

    public static void validateSitemapIndex(File sitemap) throws SAXException {
        SitemapValidator.lazyLoad();
        SitemapValidator.validateXml(sitemap, sitemapIndexSchema);
    }

    private static void validateXml(File sitemap, Schema schema) throws SAXException {
        Validator validator = schema.newValidator();
        try {
            FileReader reader = new FileReader(sitemap);
            SAXSource source = new SAXSource(new InputSource(reader));
            validator.validate(source);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

