/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.W3CDateFormat;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.io.IOException;
import java.io.OutputStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSitemapUrlRenderer<T extends WebSitemapUrl>
implements ISitemapUrlRenderer<T> {
    AbstractSitemapUrlRenderer() {
    }

    public void render(WebSitemapUrl url, OutputStreamWriter out, W3CDateFormat dateFormat, String additionalData) throws IOException {
        out.write("  <url>\n");
        out.write("    <loc>");
        out.write(url.getUrl().toString());
        out.write("</loc>\n");
        if (url.getLastMod() != null) {
            out.write("    <lastmod>");
            out.write(dateFormat.format(url.getLastMod()));
            out.write("</lastmod>\n");
        }
        if (url.getChangeFreq() != null) {
            out.write("    <changefreq>");
            out.write(url.getChangeFreq().toString());
            out.write("</changefreq>\n");
        }
        if (url.getPriority() != null) {
            out.write("    <priority>");
            out.write(url.getPriority().toString());
            out.write("</priority>\n");
        }
        if (additionalData != null) {
            out.write(additionalData);
        }
        out.write("  </url>\n");
    }

    public void renderTag(StringBuilder sb, String namespace, String tagName, Object value) {
        if (value == null) {
            return;
        }
        sb.append("      <");
        sb.append(namespace);
        sb.append(':');
        sb.append(tagName);
        sb.append('>');
        sb.append(value);
        sb.append("</");
        sb.append(namespace);
        sb.append(':');
        sb.append(tagName);
        sb.append(">\n");
    }
}

