/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.spring;

import com.google.code.ssm.Cache;
import com.google.code.ssm.PrefixedCacheImpl;
import com.google.code.ssm.spring.SSMCache;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SSMCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, org.springframework.cache.Cache> cacheMap = new ConcurrentHashMap<String, org.springframework.cache.Cache>();
    private final Set<String> cacheNames = new LinkedHashSet<String>();
    private Collection<SSMCache> caches;

    public void afterPropertiesSet() {
        Assert.notEmpty(this.caches, (String)"A collection of caches is required and cannot be empty");
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }

    public SSMCache getCache(String name) {
        SSMCache cache = (SSMCache)this.cacheMap.get(name);
        if (cache == null) {
            return null;
        }
        if (cache.getCache().getProperties().isUseNameAsKeyPrefix()) {
            return new SSMCache((Cache)new PrefixedCacheImpl(cache.getCache(), name, cache.getCache().getProperties().getKeyPrefixSeparator()), cache.getExpiration(), cache.isAllowClear(), cache.isRegisterAliases(), cache.isMuteExceptions());
        }
        return cache;
    }

    public void addCache(SSMCache cache) {
        this.caches.add(cache);
        this.registerCache(cache);
    }

    public void removeCache(String nameOrAlias) {
        org.springframework.cache.Cache cache = (org.springframework.cache.Cache)this.cacheMap.get(nameOrAlias);
        if (cache == null) {
            return;
        }
        SSMCache ssmCache = (SSMCache)cache;
        if (ssmCache.isRegisterAliases()) {
            ssmCache.getCache().getAliases().forEach(this::unregisterCache);
        }
        this.unregisterCache(nameOrAlias);
        this.unregisterCache(cache.getName());
        this.caches.removeIf(c -> c.getName().equals(cache.getName()));
    }

    public void setCaches(Collection<SSMCache> caches) {
        Assert.notEmpty(caches, (String)"A collection of caches cannot be empty or null");
        this.caches = caches;
        this.cacheMap.clear();
        this.cacheNames.clear();
        caches.forEach(this::registerCache);
    }

    private void registerCache(SSMCache cache) {
        this.registerCache(cache.getName(), cache);
        if (cache.isRegisterAliases() && !CollectionUtils.isEmpty((Collection)cache.getCache().getAliases())) {
            for (String alias : cache.getCache().getAliases()) {
                this.registerCache(alias, cache);
            }
        }
    }

    private void registerCache(String name, org.springframework.cache.Cache cache) {
        this.cacheMap.put(name, cache);
        this.cacheNames.add(name);
    }

    private void unregisterCache(String name) {
        this.cacheMap.remove(name);
        this.cacheNames.removeIf(n -> n.equals(name));
    }

    public Collection<SSMCache> getCaches() {
        return this.caches;
    }
}

