/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.spring;

import com.google.code.ssm.Cache;
import com.google.code.ssm.aop.support.PertinentNegativeNull;
import com.google.code.ssm.providers.CacheException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class SSMCache
implements org.springframework.cache.Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSMCache.class);
    private final Cache cache;
    private final int expiration;
    private final boolean allowClear;
    private final boolean registerAliases;

    public SSMCache(Cache cache, int expiration, boolean allowClear, boolean registerAliases) {
        this.cache = cache;
        this.expiration = expiration;
        this.allowClear = allowClear;
        this.registerAliases = registerAliases;
    }

    public SSMCache(Cache cache, int expiration, boolean allowClear) {
        this(cache, expiration, allowClear, false);
    }

    public SSMCache(Cache cache, int expiration) {
        this(cache, expiration, false);
    }

    public SSMCache(SSMCache ssmCache, int expiration) {
        this(ssmCache.cache, expiration, ssmCache.allowClear);
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.getValue(key);
        if (value == null) {
            LOGGER.info("Cache miss. Get by key {} from cache {}", key, (Object)this.cache.getName());
            return null;
        }
        LOGGER.info("Cache hit. Get by key {} from cache {} value '{}'", new Object[]{key, this.cache.getName(), value});
        return value instanceof PertinentNegativeNull ? new SimpleValueWrapper(null) : new SimpleValueWrapper(value);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.getValue(key);
        if (value == null) {
            LOGGER.info("Cache miss. Get by key {} and type {} from cache {}", new Object[]{key, type, this.cache.getName()});
            return null;
        }
        if (value instanceof PertinentNegativeNull) {
            return null;
        }
        if (type != null && !type.isInstance(value)) {
            String msg = "Cached value is not of required type [" + type.getName() + "]: " + value;
            LOGGER.error(msg, (Throwable)new IllegalStateException(msg));
            return null;
        }
        LOGGER.info("Cache hit. Get by key {} and type {}  from cache {} value '{}'", new Object[]{key, type, this.cache.getName(), value});
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (key != null) {
            try {
                LOGGER.info("Put '{}' under key {} to cache {}", new Object[]{value, key, this.cache.getName()});
                Object store = value;
                if (value == null) {
                    store = PertinentNegativeNull.NULL;
                }
                this.cache.set(this.getKey(key), this.expiration, store, null);
            }
            catch (TimeoutException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
            catch (CacheException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
        } else {
            LOGGER.info("Cannot put to cache {} because key is null", (Object)this.cache.getName());
        }
    }

    public void evict(Object key) {
        if (key != null) {
            try {
                LOGGER.info("Evict {} from cache {}", key, (Object)this.cache.getName());
                this.cache.delete(this.getKey(key));
            }
            catch (TimeoutException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
            catch (CacheException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
            }
        } else {
            LOGGER.info("Cannot evict from cache {} because key is null", (Object)this.cache.getName());
        }
    }

    public void clear() {
        if (!this.allowClear) {
            LOGGER.error("Clearing cache '{}' is not allowed. To enable it set allowClear to true. Make sure that caches don't overlap (one memcached instance isn't used by more than one cache) otherwise clearing one cache will affect another.", (Object)this.getName());
            throw new IllegalStateException("Cannot clear cache " + this.getName());
        }
        try {
            LOGGER.info("Clear {}", (Object)this.cache.getName());
            this.cache.flush();
        }
        catch (TimeoutException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName(), (Throwable)e);
        }
        catch (CacheException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName(), (Throwable)e);
        }
    }

    private Object getValue(Object key) {
        Object value = null;
        try {
            value = this.cache.get(this.getKey(key), null);
        }
        catch (TimeoutException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
        }
        catch (CacheException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.warn("An error has ocurred for cache " + this.getName() + " and key " + this.getKey(key), (Throwable)e);
        }
        return value;
    }

    private String getKey(Object key) {
        return key.toString();
    }

    public Cache getCache() {
        return this.cache;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public boolean isAllowClear() {
        return this.allowClear;
    }

    public boolean isRegisterAliases() {
        return this.registerAliases;
    }
}

