/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import com.google.inject.internal.Preconditions;
import com.google.inject.internal.Sets;
import com.google.inject.servlet.ServletDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class ManagedServletPipeline {
    private final List<ServletDefinition> servletDefinitions;
    private static final TypeLiteral<List<ServletDefinition>> SERVLET_DEFS = new TypeLiteral<List<ServletDefinition>>(){};

    @Inject
    public ManagedServletPipeline(Injector injector) {
        this.servletDefinitions = Collections.unmodifiableList(this.collectServletDefinitions(injector));
    }

    boolean hasServletsMapped() {
        return !this.servletDefinitions.isEmpty();
    }

    private List<ServletDefinition> collectServletDefinitions(Injector injector) {
        ArrayList servletDefinitions = Lists.newArrayList();
        for (Binding entry : injector.findBindingsByType(SERVLET_DEFS)) {
            Key defsKey = entry.getKey();
            servletDefinitions.addAll((Collection)injector.getInstance(defsKey));
        }
        return servletDefinitions;
    }

    public void init(ServletContext servletContext, Injector injector) throws ServletException {
        Set initializedSoFar = Sets.newSetFromMap((Map)Maps.newIdentityHashMap());
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            servletDefinition.init(servletContext, injector, initializedSoFar);
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.service(request, response)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        Set destroyedSoFar = Sets.newSetFromMap((Map)Maps.newIdentityHashMap());
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            servletDefinition.destroy(destroyedSoFar);
        }
    }

    RequestDispatcher getRequestDispatcher(String path) {
        for (final ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.shouldServe(path)) continue;
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    Preconditions.checkState((!servletResponse.isCommitted() ? 1 : 0) != 0, (Object)"Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                    servletResponse.resetBuffer();
                    servletDefinition.doService(servletRequest, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    servletDefinition.doService(servletRequest, servletResponse);
                }
            };
        }
        return null;
    }
}

