/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class UnionBugs2
extends AbstractFindBugsTask {
    private String to;
    private ArrayList<FileSet> fileSets = new ArrayList();

    public void setTo(String arg) {
        this.to = arg;
    }

    public void setFileset(FileSet arg) {
        this.fileSets.add(arg);
    }

    protected UnionBugs2() {
        super("edu.umd.cs.findbugs.workflow.UnionResults");
        this.setFailOnError(true);
    }

    protected void checkParameters() {
        super.checkParameters();
        if (this.to == null) {
            throw new BuildException("to attribute is required", this.getLocation());
        }
        if (this.fileSets.size() < 1) {
            throw new BuildException("fileset is required");
        }
    }

    protected void afterExecuteJavaProcess(int rc) {
        if (rc != 0) {
            throw new BuildException("execution of " + this.getTaskName() + " failed");
        }
    }

    protected void beforeExecuteJavaProcess() {
        this.log("unioning bugs...");
    }

    protected void configureFindbugsEngine() {
        this.addArg("-withMessages");
        this.addArg("-output");
        this.addArg(this.to);
        for (FileSet s : this.fileSets) {
            File fromDir = s.getDir(this.getProject());
            for (String file : s.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                this.addArg(new File(fromDir, file).toString());
            }
        }
    }
}

