/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ApplicationProperty {
    ABOUT_URL("about_url", "string"),
    APPLICATION_NAME("application_name", "string"),
    AUTHORIZE_URL("authorize_url", "string"),
    CALLBACK_URL("callback_url", "string"),
    CANVAS_NAME("canvas_name", "string"),
    CONNECT_LOGO_URL("connect_logo_url", "string"),
    DASHBOARD_URL("dashboard_url", "string"),
    DEFAULT_ACTION_URL("default_action_fbml", "string"),
    DEFAULT_COLUMN("default_column", "bool"),
    DEFAULT_FBML("default_fbml", "string"),
    DESCRIPTION("description", "string"),
    DESKTOP("desktop", "bool"),
    DEV_MODE("dev_mode", "bool"),
    EDIT_URL("edit_url", "string"),
    EMAIL("email", "string"),
    HELP_URL("help_url", "string"),
    ICON_URL("icon_url", "string"),
    INFO_CHANGED_URL("info_changed_url", "string"),
    INSTALLABLE("installable", "bool"),
    IP_LIST("ip_list", "string"),
    IS_MOBILE("is_mobile", "bool"),
    LOGO_URL("logo_url", "string"),
    MESSAGE_ACTION("message_action", "string"),
    MESSAGE_URL("message_url", "string"),
    POST_AUTHORIZE_REDIRECT_URL("post_authorize_redirect_url", "string"),
    POST_INSTALL_URL("post_install_url", "string"),
    PRELOAD_FQL("preload_fql", "string"),
    PRIVACY_URL("privacy_url", "string"),
    PRIVATE_INSTALL("private_install", "bool"),
    PROFILE_TAB_URL("profile_tab_url", "string"),
    PUBLISH_ACTION("publish_action", "string"),
    PUBLISH_SELF_ACTION("publish_self_action", "string"),
    PUBLISH_SELF_URL("publish_self_url", "string"),
    PUBLISH_URL("publish_url", "string"),
    SEE_ALL_URL("see_all_url", "string"),
    TAB_DEFAULT_NAME("tab_default_name", "string"),
    TOS_URL("tos_url", "string"),
    UNINSTALL_URL("uninstall_url", "string"),
    USE_IFRAME("use_iframe", "bool"),
    WIDE_MODE("wide_mode", "bool");

    protected static final Map<String, ApplicationProperty> PROP_TABLE;
    private String name;
    private String type;

    private ApplicationProperty(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static ApplicationProperty getPropertyForString(String propName) {
        return PROP_TABLE.get(propName);
    }

    public static ApplicationProperty getProperty(String name) {
        return ApplicationProperty.getPropertyForString(name);
    }

    public String propertyName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isBooleanProperty() {
        return "bool".equals(this.type);
    }

    public boolean isStringProperty() {
        return "string".equals(this.type);
    }

    public boolean isName(String name) {
        return this.toString().equals(name);
    }

    static {
        PROP_TABLE = new HashMap<String, ApplicationProperty>();
        for (ApplicationProperty prop : ApplicationProperty.values()) {
            PROP_TABLE.put(prop.getName(), prop);
        }
    }
}

